/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.internal.bind.JsonTreeReader;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.util.Map;

class TypeAdapters$27
extends TypeAdapter<JsonElement> {
    TypeAdapters$27() {
    }

    @Override
    public JsonElement read(JsonReader jsonReader) {
        if (jsonReader instanceof JsonTreeReader) {
            return ((JsonTreeReader)jsonReader).nextJsonElement();
        }
        switch (jsonReader.peek()) {
            case STRING: {
                return new JsonPrimitive(jsonReader.nextString());
            }
            case NUMBER: {
                String string = jsonReader.nextString();
                return new JsonPrimitive(new LazilyParsedNumber(string));
            }
            case BOOLEAN: {
                return new JsonPrimitive(jsonReader.nextBoolean());
            }
            case NULL: {
                jsonReader.nextNull();
                return JsonNull.INSTANCE;
            }
            case BEGIN_ARRAY: {
                JsonArray jsonArray = new JsonArray();
                jsonReader.beginArray();
                while (jsonReader.hasNext()) {
                    jsonArray.add(this.read(jsonReader));
                }
                jsonReader.endArray();
                return jsonArray;
            }
            case BEGIN_OBJECT: {
                JsonObject jsonObject = new JsonObject();
                jsonReader.beginObject();
                while (jsonReader.hasNext()) {
                    jsonObject.add(jsonReader.nextName(), this.read(jsonReader));
                }
                jsonReader.endObject();
                return jsonObject;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void write(JsonWriter jsonWriter, JsonElement jsonElement) {
        if (jsonElement == null || jsonElement.isJsonNull()) {
            jsonWriter.nullValue();
        } else if (jsonElement.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = jsonElement.getAsJsonPrimitive();
            if (jsonPrimitive.isNumber()) {
                jsonWriter.value(jsonPrimitive.getAsNumber());
            } else if (jsonPrimitive.isBoolean()) {
                jsonWriter.value(jsonPrimitive.getAsBoolean());
            } else {
                jsonWriter.value(jsonPrimitive.getAsString());
            }
        } else if (jsonElement.isJsonArray()) {
            jsonWriter.beginArray();
            for (JsonElement jsonElement2 : jsonElement.getAsJsonArray()) {
                this.write(jsonWriter, jsonElement2);
            }
            jsonWriter.endArray();
        } else if (jsonElement.isJsonObject()) {
            jsonWriter.beginObject();
            for (Map.Entry<String, JsonElement> entry : jsonElement.getAsJsonObject().entrySet()) {
                jsonWriter.name(entry.getKey());
                this.write(jsonWriter, entry.getValue());
            }
            jsonWriter.endObject();
        } else {
            throw new IllegalArgumentException("Couldn't write " + jsonElement.getClass());
        }
    }
}

