/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.bind.TypeAdapters$EnumTypeAdapter$1;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;

final class TypeAdapters$EnumTypeAdapter<T extends Enum<T>>
extends TypeAdapter<T> {
    private final Map<String, T> nameToConstant = new HashMap<String, T>();
    private final Map<T, String> constantToName = new HashMap<T, String>();

    public TypeAdapters$EnumTypeAdapter(Class<T> clazz) {
        try {
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.isEnumConstant()) continue;
                AccessController.doPrivileged(new TypeAdapters$EnumTypeAdapter$1(this, field));
                Enum enum_ = (Enum)field.get(null);
                String string = enum_.name();
                SerializedName serializedName = field.getAnnotation(SerializedName.class);
                if (serializedName != null) {
                    string = serializedName.value();
                    for (String string2 : serializedName.alternate()) {
                        this.nameToConstant.put(string2, enum_);
                    }
                }
                this.nameToConstant.put(string, enum_);
                this.constantToName.put(enum_, string);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
    }

    @Override
    public T read(JsonReader jsonReader) {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        return (T)((Enum)this.nameToConstant.get(jsonReader.nextString()));
    }

    @Override
    public void write(JsonWriter jsonWriter, T t) {
        jsonWriter.value(t == null ? null : this.constantToName.get(t));
    }
}

