/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.reflect;

import com.google.gson.JsonIOException;
import com.google.gson.internal.reflect.ReflectionAccessor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

final class UnsafeReflectionAccessor
extends ReflectionAccessor {
    private static Class unsafeClass;
    private final Object theUnsafe = UnsafeReflectionAccessor.getUnsafeInstance();
    private final Field overrideField = UnsafeReflectionAccessor.getOverrideField();

    UnsafeReflectionAccessor() {
    }

    @Override
    public void makeAccessible(AccessibleObject accessibleObject) {
        boolean bl = this.makeAccessibleWithUnsafe(accessibleObject);
        if (!bl) {
            try {
                accessibleObject.setAccessible(true);
            }
            catch (SecurityException securityException) {
                throw new JsonIOException("Gson couldn't modify fields for " + accessibleObject + "\nand sun.misc.Unsafe not found.\nEither write a custom type adapter, or make fields accessible, or include sun.misc.Unsafe.", securityException);
            }
        }
    }

    boolean makeAccessibleWithUnsafe(AccessibleObject accessibleObject) {
        if (this.theUnsafe != null && this.overrideField != null) {
            try {
                Method method = unsafeClass.getMethod("objectFieldOffset", Field.class);
                long l = (Long)method.invoke(this.theUnsafe, this.overrideField);
                Method method2 = unsafeClass.getMethod("putBoolean", Object.class, Long.TYPE, Boolean.TYPE);
                method2.invoke(this.theUnsafe, accessibleObject, l, true);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static Object getUnsafeInstance() {
        try {
            unsafeClass = Class.forName("sun.misc.Unsafe");
            Field field = unsafeClass.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            return field.get(null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Field getOverrideField() {
        try {
            return AccessibleObject.class.getDeclaredField("override");
        }
        catch (Exception exception) {
            return null;
        }
    }
}

