/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.WeakMemoryHolder;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class Memory
extends Pointer {
    private static ReferenceQueue<Memory> QUEUE = new ReferenceQueue();
    private static LinkedReference HEAD;
    private static final WeakMemoryHolder buffers;
    private final LinkedReference reference;
    protected long size;

    public static void purge() {
        buffers.clean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeAll() {
        Object object = LinkedReference.class;
        synchronized (LinkedReference.class) {
            LinkedReference linkedReference;
            while ((linkedReference = HEAD) != null) {
                Memory memory = (Memory)HEAD.get();
                if (memory != null) {
                    memory.dispose();
                } else {
                    Memory.HEAD.unlink();
                }
                if (HEAD != linkedReference) continue;
                throw new IllegalStateException("the HEAD did not change");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            object = QUEUE;
            synchronized (object) {
                while ((linkedReference = (LinkedReference)QUEUE.poll()) != null) {
                    linkedReference.unlink();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int integrityCheck() {
        Class<LinkedReference> clazz = LinkedReference.class;
        synchronized (LinkedReference.class) {
            if (HEAD == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return 0;
            }
            ArrayList<LinkedReference> arrayList = new ArrayList<LinkedReference>();
            LinkedReference linkedReference = HEAD;
            while (linkedReference != null) {
                arrayList.add(linkedReference);
                linkedReference = linkedReference.next;
            }
            int n = arrayList.size() - 1;
            linkedReference = (LinkedReference)arrayList.get(n);
            while (linkedReference != null) {
                if (arrayList.get(n) != linkedReference) {
                    throw new IllegalStateException(arrayList.get(n) + " vs. " + linkedReference + " at index " + n);
                }
                linkedReference = linkedReference.prev;
                --n;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return arrayList.size();
        }
    }

    public Memory(long l) {
        this.size = l;
        if (l <= 0L) {
            throw new IllegalArgumentException("Allocation size must be greater than zero");
        }
        this.peer = Memory.malloc(l);
        if (this.peer == 0L) {
            throw new OutOfMemoryError("Cannot allocate " + l + " bytes");
        }
        this.reference = LinkedReference.track(this);
    }

    protected Memory() {
        this.reference = null;
    }

    @Override
    public Pointer share(long l) {
        return this.share(l, this.size() - l);
    }

    @Override
    public Pointer share(long l, long l2) {
        this.boundsCheck(l, l2);
        return new SharedMemory(l, l2);
    }

    public Memory align(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Byte boundary must be positive: " + n);
        }
        for (int i = 0; i < 32; ++i) {
            if (n != 1 << i) continue;
            long l = (long)n - 1L ^ 0xFFFFFFFFFFFFFFFFL;
            if ((this.peer & l) != this.peer) {
                long l2 = this.peer + (long)n - 1L & l;
                long l3 = this.peer + this.size - l2;
                if (l3 <= 0L) {
                    throw new IllegalArgumentException("Insufficient memory to align to the requested boundary");
                }
                return (Memory)this.share(l2 - this.peer, l3);
            }
            return this;
        }
        throw new IllegalArgumentException("Byte boundary must be a power of two");
    }

    protected void finalize() {
        this.dispose();
    }

    protected synchronized void dispose() {
        if (this.peer == 0L) {
            return;
        }
        try {
            Memory.free(this.peer);
        }
        finally {
            this.peer = 0L;
            this.reference.unlink();
        }
    }

    public void clear() {
        this.clear(this.size);
    }

    public boolean valid() {
        return this.peer != 0L;
    }

    public long size() {
        return this.size;
    }

    protected void boundsCheck(long l, long l2) {
        if (l < 0L) {
            throw new IndexOutOfBoundsException("Invalid offset: " + l);
        }
        if (l + l2 > this.size) {
            String string = "Bounds exceeds available space : size=" + this.size + ", offset=" + (l + l2);
            throw new IndexOutOfBoundsException(string);
        }
    }

    @Override
    public void read(long l, byte[] byArray, int n, int n2) {
        this.boundsCheck(l, (long)n2 * 1L);
        super.read(l, byArray, n, n2);
    }

    @Override
    public void read(long l, short[] sArray, int n, int n2) {
        this.boundsCheck(l, (long)n2 * 2L);
        super.read(l, sArray, n, n2);
    }

    @Override
    public void read(long l, char[] cArray, int n, int n2) {
        this.boundsCheck(l, n2 * Native.WCHAR_SIZE);
        super.read(l, cArray, n, n2);
    }

    @Override
    public void read(long l, int[] nArray, int n, int n2) {
        this.boundsCheck(l, (long)n2 * 4L);
        super.read(l, nArray, n, n2);
    }

    @Override
    public void read(long l, long[] lArray, int n, int n2) {
        this.boundsCheck(l, (long)n2 * 8L);
        super.read(l, lArray, n, n2);
    }

    @Override
    public void read(long l, float[] fArray, int n, int n2) {
        this.boundsCheck(l, (long)n2 * 4L);
        super.read(l, fArray, n, n2);
    }

    @Override
    public void read(long l, double[] dArray, int n, int n2) {
        this.boundsCheck(l, (long)n2 * 8L);
        super.read(l, dArray, n, n2);
    }

    @Override
    public void read(long l, Pointer[] pointerArray, int n, int n2) {
        this.boundsCheck(l, n2 * Native.POINTER_SIZE);
        super.read(l, pointerArray, n, n2);
    }

    @Override
    public void write(long l, byte[] byArray, int n, int n2) {
        this.boundsCheck(l, (long)n2 * 1L);
        super.write(l, byArray, n, n2);
    }

    @Override
    public void write(long l, short[] sArray, int n, int n2) {
        this.boundsCheck(l, (long)n2 * 2L);
        super.write(l, sArray, n, n2);
    }

    @Override
    public void write(long l, char[] cArray, int n, int n2) {
        this.boundsCheck(l, n2 * Native.WCHAR_SIZE);
        super.write(l, cArray, n, n2);
    }

    @Override
    public void write(long l, int[] nArray, int n, int n2) {
        this.boundsCheck(l, (long)n2 * 4L);
        super.write(l, nArray, n, n2);
    }

    @Override
    public void write(long l, long[] lArray, int n, int n2) {
        this.boundsCheck(l, (long)n2 * 8L);
        super.write(l, lArray, n, n2);
    }

    @Override
    public void write(long l, float[] fArray, int n, int n2) {
        this.boundsCheck(l, (long)n2 * 4L);
        super.write(l, fArray, n, n2);
    }

    @Override
    public void write(long l, double[] dArray, int n, int n2) {
        this.boundsCheck(l, (long)n2 * 8L);
        super.write(l, dArray, n, n2);
    }

    @Override
    public void write(long l, Pointer[] pointerArray, int n, int n2) {
        this.boundsCheck(l, n2 * Native.POINTER_SIZE);
        super.write(l, pointerArray, n, n2);
    }

    @Override
    public byte getByte(long l) {
        this.boundsCheck(l, 1L);
        return super.getByte(l);
    }

    @Override
    public char getChar(long l) {
        this.boundsCheck(l, Native.WCHAR_SIZE);
        return super.getChar(l);
    }

    @Override
    public short getShort(long l) {
        this.boundsCheck(l, 2L);
        return super.getShort(l);
    }

    @Override
    public int getInt(long l) {
        this.boundsCheck(l, 4L);
        return super.getInt(l);
    }

    @Override
    public long getLong(long l) {
        this.boundsCheck(l, 8L);
        return super.getLong(l);
    }

    @Override
    public float getFloat(long l) {
        this.boundsCheck(l, 4L);
        return super.getFloat(l);
    }

    @Override
    public double getDouble(long l) {
        this.boundsCheck(l, 8L);
        return super.getDouble(l);
    }

    @Override
    public Pointer getPointer(long l) {
        this.boundsCheck(l, Native.POINTER_SIZE);
        return this.shareReferenceIfInBounds(super.getPointer(l));
    }

    @Override
    public ByteBuffer getByteBuffer(long l, long l2) {
        this.boundsCheck(l, l2);
        ByteBuffer byteBuffer = super.getByteBuffer(l, l2);
        buffers.put(byteBuffer, this);
        return byteBuffer;
    }

    @Override
    public String getString(long l, String string) {
        this.boundsCheck(l, 0L);
        return super.getString(l, string);
    }

    @Override
    public String getWideString(long l) {
        this.boundsCheck(l, 0L);
        return super.getWideString(l);
    }

    @Override
    public void setByte(long l, byte by) {
        this.boundsCheck(l, 1L);
        super.setByte(l, by);
    }

    @Override
    public void setChar(long l, char c) {
        this.boundsCheck(l, Native.WCHAR_SIZE);
        super.setChar(l, c);
    }

    @Override
    public void setShort(long l, short s) {
        this.boundsCheck(l, 2L);
        super.setShort(l, s);
    }

    @Override
    public void setInt(long l, int n) {
        this.boundsCheck(l, 4L);
        super.setInt(l, n);
    }

    @Override
    public void setLong(long l, long l2) {
        this.boundsCheck(l, 8L);
        super.setLong(l, l2);
    }

    @Override
    public void setFloat(long l, float f) {
        this.boundsCheck(l, 4L);
        super.setFloat(l, f);
    }

    @Override
    public void setDouble(long l, double d) {
        this.boundsCheck(l, 8L);
        super.setDouble(l, d);
    }

    @Override
    public void setPointer(long l, Pointer pointer) {
        this.boundsCheck(l, Native.POINTER_SIZE);
        super.setPointer(l, pointer);
    }

    @Override
    public void setString(long l, String string, String string2) {
        this.boundsCheck(l, (long)Native.getBytes(string, string2).length + 1L);
        super.setString(l, string, string2);
    }

    @Override
    public void setWideString(long l, String string) {
        this.boundsCheck(l, ((long)string.length() + 1L) * (long)Native.WCHAR_SIZE);
        super.setWideString(l, string);
    }

    @Override
    public String toString() {
        return "allocated@0x" + Long.toHexString(this.peer) + " (" + this.size + " bytes)";
    }

    protected static void free(long l) {
        if (l != 0L) {
            Native.free(l);
        }
    }

    protected static long malloc(long l) {
        return Native.malloc(l);
    }

    public String dump() {
        return this.dump(0L, (int)this.size());
    }

    private Pointer shareReferenceIfInBounds(Pointer pointer) {
        if (pointer == null) {
            return null;
        }
        long l = pointer.peer - this.peer;
        if (l >= 0L && l < this.size) {
            return this.share(l);
        }
        return pointer;
    }

    static {
        buffers = new WeakMemoryHolder();
    }

    private class SharedMemory
    extends Memory {
        public SharedMemory(long l, long l2) {
            this.size = l2;
            this.peer = Memory.this.peer + l;
        }

        @Override
        protected synchronized void dispose() {
            this.peer = 0L;
        }

        @Override
        protected void boundsCheck(long l, long l2) {
            Memory.this.boundsCheck(this.peer - Memory.this.peer + l, l2);
        }

        @Override
        public String toString() {
            return super.toString() + " (shared from " + Memory.this.toString() + ")";
        }
    }

    private static class LinkedReference
    extends WeakReference<Memory> {
        private LinkedReference next;
        private LinkedReference prev;

        private LinkedReference(Memory memory) {
            super(memory, QUEUE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static LinkedReference track(Memory memory) {
            Object object;
            Object object2 = QUEUE;
            synchronized (object2) {
                while ((object = (LinkedReference)QUEUE.poll()) != null) {
                    ((LinkedReference)object).unlink();
                }
            }
            object2 = new LinkedReference(memory);
            object = LinkedReference.class;
            synchronized (LinkedReference.class) {
                if (HEAD != null) {
                    ((LinkedReference)object2).next = HEAD;
                    HEAD.prev = object2;
                    HEAD = (LinkedReference)HEAD.prev;
                } else {
                    HEAD = (LinkedReference)object2;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return object2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unlink() {
            Class<LinkedReference> clazz = LinkedReference.class;
            synchronized (LinkedReference.class) {
                LinkedReference linkedReference;
                if (HEAD != this) {
                    if (this.prev == null) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                    linkedReference = this.prev.next = this.next;
                } else {
                    linkedReference = HEAD = HEAD.next;
                }
                if (linkedReference != null) {
                    linkedReference.prev = this.prev;
                }
                this.prev = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }
}

