/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.unix.aix;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.platform.unix.LibCAPI;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.jna.platform.unix.aix.AixLibc;
import oshi.util.tuples.Pair;
import oshi.util.tuples.Triplet;

@ThreadSafe
public final class PsInfo {
    private static final Logger LOG = LoggerFactory.getLogger(PsInfo.class);
    private static final AixLibc LIBC = AixLibc.INSTANCE;
    private static final long PAGE_SIZE = 4096L;
    private static Map<LwpsInfoT, Integer> lwpsInfoOffsets = PsInfo.initLwpsOffsets();
    private static Map<PsInfoT, Integer> psInfoOffsets = PsInfo.initPsOffsets();

    private PsInfo() {
    }

    private static Map<LwpsInfoT, Integer> initLwpsOffsets() {
        EnumMap<LwpsInfoT, Integer> enumMap = new EnumMap<LwpsInfoT, Integer>(LwpsInfoT.class);
        int n = 0;
        for (LwpsInfoT lwpsInfoT : LwpsInfoT.values()) {
            enumMap.put(lwpsInfoT, n);
            n += lwpsInfoT.size;
        }
        return enumMap;
    }

    private static Map<PsInfoT, Integer> initPsOffsets() {
        EnumMap<PsInfoT, Integer> enumMap = new EnumMap<PsInfoT, Integer>(PsInfoT.class);
        int n = 0;
        for (PsInfoT psInfoT : PsInfoT.values()) {
            enumMap.put(psInfoT, n);
            n += psInfoT.size;
        }
        return enumMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Triplet<Integer, Long, Long> queryArgsEnvAddrs(int n) {
        File file = new File("/proc/" + n + "/psinfo");
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
             FileChannel fileChannel = randomAccessFile.getChannel();
             ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            ByteBuffer byteBuffer;
            int n2 = psInfoOffsets.get((Object)PsInfoT.SIZE);
            if ((long)n2 > fileChannel.size()) {
                n2 = (int)fileChannel.size();
            }
            if (fileChannel.read(byteBuffer = ByteBuffer.allocate(n2)) < psInfoOffsets.get((Object)PsInfoT.PR_FNAME)) return null;
            int n3 = byteBuffer.getInt(psInfoOffsets.get((Object)PsInfoT.PR_ARGC));
            long l = byteBuffer.getLong(psInfoOffsets.get((Object)PsInfoT.PR_ARGV));
            long l2 = byteBuffer.getLong(psInfoOffsets.get((Object)PsInfoT.PR_ENVP));
            Triplet<Integer, Long, Long> triplet = new Triplet<Integer, Long, Long>(n3, l, l2);
            return triplet;
        }
        catch (IOException iOException) {
            LOG.debug("Failed to read file: {} ", (Object)file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<List<String>, Map<String, String>> queryArgsEnv(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        Triplet<Integer, Long, Long> triplet = PsInfo.queryArgsEnvAddrs(n);
        if (triplet != null) {
            String string = "/proc/" + n + "/as";
            int n2 = LIBC.open(string, 0);
            if (n2 < 0) {
                LOG.trace("No permission to read file: {} ", (Object)string);
                return new Pair<List<String>, Map<String, String>>(arrayList, linkedHashMap);
            }
            try {
                int n3 = triplet.getA();
                long l = triplet.getB();
                long l2 = triplet.getC();
                long l3 = (l2 - l) / (long)(n3 + 1);
                long l4 = 0L;
                Memory memory = new Memory(8192L);
                LibCAPI.size_t size_t2 = new LibCAPI.size_t(memory.size());
                long[] lArray = new long[n3];
                long l5 = l;
                for (int i = 0; i < n3; ++i) {
                    lArray[i] = (l4 = PsInfo.conditionallyReadBufferFromStartOfPage(n2, memory, size_t2, l4, l5)) == 0L ? 0L : PsInfo.getOffsetFromBuffer(memory, l5 - l4, l3);
                    l5 += l3;
                }
                ArrayList<Long> arrayList2 = new ArrayList<Long>();
                l5 = l2;
                long l6 = 0L;
                int n4 = 500;
                do {
                    long l7 = l6 = (l4 = PsInfo.conditionallyReadBufferFromStartOfPage(n2, memory, size_t2, l4, l5)) == 0L ? 0L : PsInfo.getOffsetFromBuffer(memory, l5 - l4, l3);
                    if (l6 != 0L) {
                        arrayList2.add(l6);
                    }
                    l5 += l3;
                } while (l6 != 0L && --n4 > 0);
                for (int i = 0; i < lArray.length && lArray[i] != 0L; ++i) {
                    String object;
                    if ((l4 = PsInfo.conditionallyReadBufferFromStartOfPage(n2, memory, size_t2, l4, lArray[i])) == 0L || (object = memory.getString(lArray[i] - l4)).isEmpty()) continue;
                    arrayList.add(object);
                }
                for (Long l8 : arrayList2) {
                    String string2;
                    int n5;
                    if ((l4 = PsInfo.conditionallyReadBufferFromStartOfPage(n2, memory, size_t2, l4, l8)) == 0L || (n5 = (string2 = memory.getString(l8 - l4)).indexOf(61)) <= 0) continue;
                    linkedHashMap.put(string2.substring(0, n5), string2.substring(n5 + 1));
                }
            }
            finally {
                LIBC.close(n2);
            }
        }
        return new Pair<List<String>, Map<String, String>>(arrayList, linkedHashMap);
    }

    private static long conditionallyReadBufferFromStartOfPage(int n, Memory memory, LibCAPI.size_t size_t2, long l, long l2) {
        if (l2 < l || l2 - l > 4096L) {
            long l3 = Math.floorDiv(l2, 4096L) * 4096L;
            LibCAPI.ssize_t ssize_t2 = LIBC.pread(n, memory, size_t2, new NativeLong(l3));
            if (ssize_t2.longValue() < 4096L) {
                LOG.debug("Failed to read page from address space: {} bytes read", (Object)ssize_t2.longValue());
                return 0L;
            }
            return l3;
        }
        return l;
    }

    private static long getOffsetFromBuffer(Memory memory, long l, long l2) {
        return l2 == 8L ? memory.getLong(l) : (long)memory.getInt(l);
    }

    static /* synthetic */ Map access$000() {
        return lwpsInfoOffsets;
    }

    static enum LwpsInfoT {
        PR_LWPID(8),
        PR_ADDR(8),
        PR_WCHAN(8),
        PR_FLAG(4),
        PR_WTYPE(1),
        PR_STATE(1),
        PR_SNAME(1),
        PR_NICE(1),
        PR_PRI(4),
        PR_POLICY(4),
        PR_CLNAME(8),
        PR_ONPRO(Native.POINTER_SIZE),
        PR_BINDPRO(Native.POINTER_SIZE),
        SIZE(0);

        private final int size;

        private LwpsInfoT(int n2) {
            this.size = n2;
        }

        public int size() {
            return this.size;
        }
    }

    static enum PsInfoT {
        PR_FLAG(4),
        PR_FLAG2(4),
        PR_NLWP(4),
        PR_PAD1(4),
        PR_UID(8),
        PR_EUID(8),
        PR_GID(8),
        PR_EGID(8),
        PR_PID(8),
        PR_PPID(8),
        PR_PGID(8),
        PR_SID(8),
        PR_TTYDEV(8),
        PR_ADDR(8),
        PR_SIZE(8),
        PR_RSSIZE(8),
        PR_START(16),
        PR_TIME(16),
        PR_CID(2),
        PR_PAD2(2),
        PR_ARGC(4),
        PR_ARGV(8),
        PR_ENVP(8),
        PR_FNAME(16),
        PR_PSARGS(80),
        PR_PAD(64),
        PR_LWP((Integer)PsInfo.access$000().get((Object)((Object)LwpsInfoT.SIZE))),
        SIZE(0);

        private final int size;

        private PsInfoT(int n2) {
            this.size = n2;
        }

        public int size() {
            return this.size;
        }
    }
}

