/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.unix.solaris;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.platform.unix.LibCAPI;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.jna.platform.unix.solaris.SolarisLibc;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;
import oshi.util.tuples.Pair;
import oshi.util.tuples.Quartet;

@ThreadSafe
public final class PsInfo {
    private static final Logger LOG = LoggerFactory.getLogger(PsInfo.class);
    private static final boolean IS_LITTLE_ENDIAN = "little".equals(System.getProperty("sun.cpu.endian"));
    private static final SolarisLibc LIBC = SolarisLibc.INSTANCE;
    private static final long PAGE_SIZE = ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("pagesize"), 4096L);
    private static Map<LwpsInfoT, Integer> lwpsInfoOffsets = PsInfo.initLwpsOffsets();
    private static Map<PsInfoT, Integer> psInfoOffsets = PsInfo.initPsOffsets();

    private PsInfo() {
    }

    private static Map<LwpsInfoT, Integer> initLwpsOffsets() {
        EnumMap<LwpsInfoT, Integer> enumMap = new EnumMap<LwpsInfoT, Integer>(LwpsInfoT.class);
        int n = 0;
        for (LwpsInfoT lwpsInfoT : LwpsInfoT.values()) {
            enumMap.put(lwpsInfoT, n);
            n += lwpsInfoT.size;
        }
        return enumMap;
    }

    private static Map<PsInfoT, Integer> initPsOffsets() {
        EnumMap<PsInfoT, Integer> enumMap = new EnumMap<PsInfoT, Integer>(PsInfoT.class);
        int n = 0;
        for (PsInfoT psInfoT : PsInfoT.values()) {
            enumMap.put(psInfoT, n);
            n += psInfoT.size;
        }
        return enumMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Quartet<Integer, Long, Long, Byte> queryArgsEnvAddrs(int n) {
        File file = new File("/proc/" + n + "/psinfo");
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
             FileChannel fileChannel = randomAccessFile.getChannel();
             ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            int n2;
            ByteBuffer byteBuffer;
            int n3 = psInfoOffsets.get((Object)PsInfoT.SIZE);
            if ((long)n3 > fileChannel.size()) {
                n3 = (int)fileChannel.size();
            }
            if (fileChannel.read(byteBuffer = ByteBuffer.allocate(n3)) <= psInfoOffsets.get((Object)PsInfoT.PR_DMODEL)) return null;
            if (IS_LITTLE_ENDIAN) {
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            if ((n2 = byteBuffer.getInt(psInfoOffsets.get((Object)PsInfoT.PR_ARGC))) > 0) {
                long l = Native.POINTER_SIZE == 8 ? byteBuffer.getLong(psInfoOffsets.get((Object)PsInfoT.PR_ARGV)) : (long)byteBuffer.getInt(psInfoOffsets.get((Object)PsInfoT.PR_ARGV));
                long l2 = Native.POINTER_SIZE == 8 ? byteBuffer.getLong(psInfoOffsets.get((Object)PsInfoT.PR_ENVP)) : (long)byteBuffer.getInt(psInfoOffsets.get((Object)PsInfoT.PR_ENVP));
                byte by = byteBuffer.get(psInfoOffsets.get((Object)PsInfoT.PR_DMODEL));
                if ((long)(by * 4) != (l2 - l) / (long)(n2 + 1)) {
                    LOG.trace("Failed data model and offset increment sanity check: dm={} diff={}", (Object)by, (Object)(l2 - l));
                    Quartet<Integer, Long, Long, Byte> quartet = null;
                    return quartet;
                }
                Quartet<Integer, Long, Long, Byte> quartet = new Quartet<Integer, Long, Long, Byte>(n2, l, l2, by);
                return quartet;
            }
            LOG.trace("No permission to read file: {} ", (Object)file);
            return null;
        }
        catch (IOException iOException) {
            LOG.debug("Failed to read file: {} ", (Object)file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<List<String>, Map<String, String>> queryArgsEnv(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        Quartet<Integer, Long, Long, Byte> quartet = PsInfo.queryArgsEnvAddrs(n);
        if (quartet != null) {
            String string = "/proc/" + n + "/as";
            int n2 = LIBC.open(string, 0);
            if (n2 < 0) {
                LOG.trace("No permission to read file: {} ", (Object)string);
                return new Pair<List<String>, Map<String, String>>(arrayList, linkedHashMap);
            }
            try {
                int n3 = quartet.getA();
                long l = quartet.getB();
                long l2 = quartet.getC();
                long l3 = (long)quartet.getD().byteValue() * 4L;
                long l4 = 0L;
                Memory memory = new Memory(PAGE_SIZE * 2L);
                LibCAPI.size_t size_t2 = new LibCAPI.size_t(memory.size());
                long[] lArray = new long[n3];
                long l5 = l;
                for (int i = 0; i < n3; ++i) {
                    lArray[i] = (l4 = PsInfo.conditionallyReadBufferFromStartOfPage(n2, memory, size_t2, l4, l5)) == 0L ? 0L : PsInfo.getOffsetFromBuffer(memory, l5 - l4, l3);
                    l5 += l3;
                }
                ArrayList<Long> arrayList2 = new ArrayList<Long>();
                l5 = l2;
                long l6 = 0L;
                int n4 = 500;
                do {
                    long l7 = l6 = (l4 = PsInfo.conditionallyReadBufferFromStartOfPage(n2, memory, size_t2, l4, l5)) == 0L ? 0L : PsInfo.getOffsetFromBuffer(memory, l5 - l4, l3);
                    if (l6 != 0L) {
                        arrayList2.add(l6);
                    }
                    l5 += l3;
                } while (l6 != 0L && --n4 > 0);
                for (int i = 0; i < lArray.length && lArray[i] != 0L; ++i) {
                    String object;
                    if ((l4 = PsInfo.conditionallyReadBufferFromStartOfPage(n2, memory, size_t2, l4, lArray[i])) == 0L || (object = memory.getString(lArray[i] - l4)).isEmpty()) continue;
                    arrayList.add(object);
                }
                for (Long l8 : arrayList2) {
                    String string2;
                    int n5;
                    if ((l4 = PsInfo.conditionallyReadBufferFromStartOfPage(n2, memory, size_t2, l4, l8)) == 0L || (n5 = (string2 = memory.getString(l8 - l4)).indexOf(61)) <= 0) continue;
                    linkedHashMap.put(string2.substring(0, n5), string2.substring(n5 + 1));
                }
            }
            finally {
                LIBC.close(n2);
            }
        }
        return new Pair<List<String>, Map<String, String>>(arrayList, linkedHashMap);
    }

    private static long conditionallyReadBufferFromStartOfPage(int n, Memory memory, LibCAPI.size_t size_t2, long l, long l2) {
        if (l2 < l || l2 - l > PAGE_SIZE) {
            long l3 = Math.floorDiv(l2, PAGE_SIZE) * PAGE_SIZE;
            LibCAPI.ssize_t ssize_t2 = LIBC.pread(n, memory, size_t2, new NativeLong(l3));
            if (ssize_t2.longValue() < PAGE_SIZE) {
                LOG.debug("Failed to read page from address space: {} bytes read", (Object)ssize_t2.longValue());
                return 0L;
            }
            return l3;
        }
        return l;
    }

    private static long getOffsetFromBuffer(Memory memory, long l, long l2) {
        return l2 == 8L ? memory.getLong(l) : (long)memory.getInt(l);
    }

    static /* synthetic */ Map access$000() {
        return lwpsInfoOffsets;
    }

    static enum LwpsInfoT {
        PR_FLAG(4),
        PR_LWPID(4),
        PR_ADDR(Native.POINTER_SIZE),
        PR_WCHAN(Native.POINTER_SIZE),
        PR_STYPE(1),
        PR_STATE(1),
        PR_SNAME(1),
        PR_NICE(1),
        PR_SYSCALL(2),
        PR_OLDPRI(1),
        PR_CPU(1),
        PR_PRI(4),
        PR_PCTCPU(2),
        PAD(2),
        PR_START(2 * NativeLong.SIZE),
        PR_TIME(2 * NativeLong.SIZE),
        PR_CLNAME(8),
        PR_NAME(16),
        PR_ONPRO(4),
        PR_BINDPRO(4),
        PR_BINDPSET(4),
        PR_LGRP(4),
        PR_LAST_ONPROC(8),
        SIZE(0);

        private final int size;

        private LwpsInfoT(int n2) {
            this.size = n2;
        }

        public int size() {
            return this.size;
        }
    }

    static enum PsInfoT {
        PR_FLAG(4),
        PR_NLWP(4),
        PR_NZOMB(4),
        PR_PID(4),
        PR_PPID(4),
        PR_PGID(4),
        PR_SID(4),
        PR_UID(4),
        PR_EUID(4),
        PR_GID(4),
        PR_EGID(4),
        PAD1(Native.POINTER_SIZE - 4),
        PR_ADDR(Native.POINTER_SIZE),
        PR_SIZE(Native.SIZE_T_SIZE),
        PR_RSSIZE(Native.SIZE_T_SIZE),
        PR_TTYDEV(NativeLong.SIZE),
        PR_PCTCPU(2),
        PR_PCTMEM(2),
        PAD2(Native.POINTER_SIZE - 4),
        PR_START(2 * NativeLong.SIZE),
        PR_TIME(2 * NativeLong.SIZE),
        PR_CTIME(2 * NativeLong.SIZE),
        PR_FNAME(16),
        PR_PSARGS(80),
        PR_WSTAT(4),
        PR_ARGC(4),
        PR_ARGV(Native.POINTER_SIZE),
        PR_ENVP(Native.POINTER_SIZE),
        PR_DMODEL(1),
        PAD3(7),
        PR_LWP((Integer)PsInfo.access$000().get((Object)((Object)LwpsInfoT.SIZE))),
        PR_TASKID(4),
        PR_PROJID(4),
        PR_POOLID(4),
        PR_ZONEID(4),
        PR_CONTRACT(4),
        SIZE(0);

        private final int size;

        private PsInfoT(int n2) {
            this.size = n2;
        }

        public int size() {
            return this.size;
        }
    }
}

