/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.windows;

import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinNT;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.CentralProcessor;

@ThreadSafe
public final class LogicalProcessorInformation {
    private LogicalProcessorInformation() {
    }

    public static List<CentralProcessor.LogicalProcessor> getLogicalProcessorInformationEx() {
        WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX[] sYSTEM_LOGICAL_PROCESSOR_INFORMATION_EXArray = Kernel32Util.getLogicalProcessorInformationEx(65535);
        ArrayList<WinNT.GROUP_AFFINITY[]> arrayList = new ArrayList<WinNT.GROUP_AFFINITY[]>();
        ArrayList<WinNT.GROUP_AFFINITY> arrayList2 = new ArrayList<WinNT.GROUP_AFFINITY>();
        ArrayList<WinNT.NUMA_NODE_RELATIONSHIP> arrayList3 = new ArrayList<WinNT.NUMA_NODE_RELATIONSHIP>();
        block5: for (int i = 0; i < sYSTEM_LOGICAL_PROCESSOR_INFORMATION_EXArray.length; ++i) {
            switch (sYSTEM_LOGICAL_PROCESSOR_INFORMATION_EXArray[i].relationship) {
                case 3: {
                    arrayList.add(((WinNT.PROCESSOR_RELATIONSHIP)sYSTEM_LOGICAL_PROCESSOR_INFORMATION_EXArray[i]).groupMask);
                    continue block5;
                }
                case 0: {
                    arrayList2.add(((WinNT.PROCESSOR_RELATIONSHIP)sYSTEM_LOGICAL_PROCESSOR_INFORMATION_EXArray[i]).groupMask[0]);
                    continue block5;
                }
                case 1: {
                    arrayList3.add((WinNT.NUMA_NODE_RELATIONSHIP)sYSTEM_LOGICAL_PROCESSOR_INFORMATION_EXArray[i]);
                    continue block5;
                }
            }
        }
        arrayList2.sort(Comparator.comparing(gROUP_AFFINITY -> (long)gROUP_AFFINITY.group * 64L + gROUP_AFFINITY.mask.longValue()));
        arrayList.sort(Comparator.comparing(gROUP_AFFINITYArray -> (long)gROUP_AFFINITYArray[0].group * 64L + gROUP_AFFINITYArray[0].mask.longValue()));
        arrayList3.sort(Comparator.comparing(nUMA_NODE_RELATIONSHIP -> nUMA_NODE_RELATIONSHIP.nodeNumber));
        ArrayList<CentralProcessor.LogicalProcessor> arrayList4 = new ArrayList<CentralProcessor.LogicalProcessor>();
        for (WinNT.NUMA_NODE_RELATIONSHIP nUMA_NODE_RELATIONSHIP2 : arrayList3) {
            int n = nUMA_NODE_RELATIONSHIP2.nodeNumber;
            short s = nUMA_NODE_RELATIONSHIP2.groupMask.group;
            long l = nUMA_NODE_RELATIONSHIP2.groupMask.mask.longValue();
            int n2 = Long.numberOfTrailingZeros(l);
            int n3 = 63 - Long.numberOfLeadingZeros(l);
            for (int i = n2; i <= n3; ++i) {
                if ((l & 1L << i) == 0L) continue;
                CentralProcessor.LogicalProcessor logicalProcessor = new CentralProcessor.LogicalProcessor(i, LogicalProcessorInformation.getMatchingCore(arrayList2, s, i), LogicalProcessorInformation.getMatchingPackage(arrayList, s, i), n, s);
                arrayList4.add(logicalProcessor);
            }
        }
        return arrayList4;
    }

    private static int getMatchingPackage(List<WinNT.GROUP_AFFINITY[]> list, int n, int n2) {
        for (int i = 0; i < list.size(); ++i) {
            for (int j = 0; j < list.get(i).length; ++j) {
                if ((list.get((int)i)[j].mask.longValue() & 1L << n2) == 0L || list.get((int)i)[j].group != n) continue;
                return i;
            }
        }
        return 0;
    }

    private static int getMatchingCore(List<WinNT.GROUP_AFFINITY> list, int n, int n2) {
        for (int i = 0; i < list.size(); ++i) {
            if ((list.get((int)i).mask.longValue() & 1L << n2) == 0L || list.get((int)i).group != n) continue;
            return i;
        }
        return 0;
    }

    public static List<CentralProcessor.LogicalProcessor> getLogicalProcessorInformation() {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION[] sYSTEM_LOGICAL_PROCESSOR_INFORMATIONArray = Kernel32Util.getLogicalProcessorInformation();
        for (WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION sYSTEM_LOGICAL_PROCESSOR_INFORMATION : sYSTEM_LOGICAL_PROCESSOR_INFORMATIONArray) {
            if (sYSTEM_LOGICAL_PROCESSOR_INFORMATION.relationship == 3) {
                arrayList.add(sYSTEM_LOGICAL_PROCESSOR_INFORMATION.processorMask.longValue());
                continue;
            }
            if (sYSTEM_LOGICAL_PROCESSOR_INFORMATION.relationship != 0) continue;
            arrayList2.add(sYSTEM_LOGICAL_PROCESSOR_INFORMATION.processorMask.longValue());
        }
        arrayList2.sort(null);
        arrayList.sort(null);
        ArrayList arrayList3 = new ArrayList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            long l = (Long)arrayList2.get(i);
            int n = Long.numberOfTrailingZeros(l);
            int n2 = 63 - Long.numberOfLeadingZeros(l);
            for (int j = n; j <= n2; ++j) {
                if ((l & 1L << j) == 0L) continue;
                CentralProcessor.LogicalProcessor logicalProcessor = new CentralProcessor.LogicalProcessor(j, i, LogicalProcessorInformation.getBitMatchingPackageNumber(arrayList, j));
                arrayList3.add(logicalProcessor);
            }
        }
        return arrayList3;
    }

    private static int getBitMatchingPackageNumber(List<Long> list, int n) {
        for (int i = 0; i < list.size(); ++i) {
            if ((list.get(i) & 1L << n) == 0L) continue;
            return i;
        }
        return 0;
    }
}

