/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.windows.registry;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinPerf;
import com.sun.jna.platform.win32.WinReg;
import com.sun.jna.ptr.IntByReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.util.platform.windows.PerfCounterWildcardQuery;
import oshi.util.tuples.Pair;
import oshi.util.tuples.Triplet;

@ThreadSafe
public final class HkeyPerformanceDataUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HkeyPerformanceDataUtil.class);
    private static final String HKEY_PERFORMANCE_TEXT = "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Perflib\\009";
    private static final String COUNTER = "Counter";
    private static final Map<String, Integer> COUNTER_INDEX_MAP = HkeyPerformanceDataUtil.mapCounterIndicesFromRegistry();

    private HkeyPerformanceDataUtil() {
    }

    public static <T extends Enum<T>> Triplet<List<Map<T, Object>>, Long, Long> readPerfDataFromRegistry(String string, Class<T> clazz) {
        Pair<Integer, EnumMap<T, Integer>> pair = HkeyPerformanceDataUtil.getCounterIndices(string, clazz);
        if (pair == null) {
            return null;
        }
        Memory memory = HkeyPerformanceDataUtil.readPerfDataBuffer(string);
        if (memory == null) {
            return null;
        }
        WinPerf.PERF_DATA_BLOCK pERF_DATA_BLOCK = new WinPerf.PERF_DATA_BLOCK(memory.share(0L));
        long l = pERF_DATA_BLOCK.PerfTime100nSec.getValue();
        long l2 = WinBase.FILETIME.filetimeToDate((int)(l >> 32), (int)(l & 0xFFFFFFFFL)).getTime();
        long l3 = pERF_DATA_BLOCK.HeaderLength;
        for (int i = 0; i < pERF_DATA_BLOCK.NumObjectTypes; ++i) {
            WinPerf.PERF_OBJECT_TYPE pERF_OBJECT_TYPE = new WinPerf.PERF_OBJECT_TYPE(memory.share(l3));
            if (pERF_OBJECT_TYPE.ObjectNameTitleIndex == COUNTER_INDEX_MAP.get(string)) {
                long l4 = l3 + (long)pERF_OBJECT_TYPE.HeaderLength;
                HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
                HashMap<Integer, Integer> hashMap2 = new HashMap<Integer, Integer>();
                for (int j = 0; j < pERF_OBJECT_TYPE.NumCounters; ++j) {
                    WinPerf.PERF_COUNTER_DEFINITION pERF_COUNTER_DEFINITION = new WinPerf.PERF_COUNTER_DEFINITION(memory.share(l4));
                    hashMap.put(pERF_COUNTER_DEFINITION.CounterNameTitleIndex, pERF_COUNTER_DEFINITION.CounterOffset);
                    hashMap2.put(pERF_COUNTER_DEFINITION.CounterNameTitleIndex, pERF_COUNTER_DEFINITION.CounterSize);
                    l4 += (long)pERF_COUNTER_DEFINITION.ByteLength;
                }
                long l5 = l3 + (long)pERF_OBJECT_TYPE.DefinitionLength;
                ArrayList arrayList = new ArrayList(pERF_OBJECT_TYPE.NumInstances);
                for (int j = 0; j < pERF_OBJECT_TYPE.NumInstances; ++j) {
                    WinPerf.PERF_INSTANCE_DEFINITION pERF_INSTANCE_DEFINITION = new WinPerf.PERF_INSTANCE_DEFINITION(memory.share(l5));
                    long l6 = l5 + (long)pERF_INSTANCE_DEFINITION.ByteLength;
                    EnumMap<T, Object> enumMap = new EnumMap<T, Object>(clazz);
                    Enum[] enumArray = (Enum[])clazz.getEnumConstants();
                    enumMap.put((T)enumArray[0], (Object)memory.getWideString(l5 + (long)pERF_INSTANCE_DEFINITION.NameOffset));
                    for (int k = 1; k < enumArray.length; ++k) {
                        Enum enum_ = enumArray[k];
                        int n = COUNTER_INDEX_MAP.get(((PerfCounterWildcardQuery.PdhCounterWildcardProperty)((Object)enum_)).getCounter());
                        int n2 = hashMap2.getOrDefault(n, 0);
                        if (n2 == 4) {
                            enumMap.put((T)enum_, (Object)memory.getInt(l6 + (long)((Integer)hashMap.get(n)).intValue()));
                            continue;
                        }
                        if (n2 == 8) {
                            enumMap.put((T)enum_, (Object)memory.getLong(l6 + (long)((Integer)hashMap.get(n)).intValue()));
                            continue;
                        }
                        return null;
                    }
                    arrayList.add(enumMap);
                    l5 = l6 + (long)new WinPerf.PERF_COUNTER_BLOCK((Pointer)memory.share((long)l6)).ByteLength;
                }
                return new Triplet<List<Map<T, Object>>, Long, Long>(arrayList, l, l2);
            }
            l3 += (long)pERF_OBJECT_TYPE.TotalByteLength;
        }
        return null;
    }

    private static <T extends Enum<T>> Pair<Integer, EnumMap<T, Integer>> getCounterIndices(String string, Class<T> clazz) {
        if (!COUNTER_INDEX_MAP.containsKey(string)) {
            LOG.debug("Couldn't find counter index of {}.", (Object)string);
            return null;
        }
        int n = COUNTER_INDEX_MAP.get(string);
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        EnumMap<T, Integer> enumMap = new EnumMap<T, Integer>(clazz);
        for (int i = 1; i < enumArray.length; ++i) {
            Enum enum_ = enumArray[i];
            String string2 = ((PerfCounterWildcardQuery.PdhCounterWildcardProperty)((Object)enum_)).getCounter();
            if (!COUNTER_INDEX_MAP.containsKey(string2)) {
                LOG.debug("Couldn't find counter index of {}.", (Object)string2);
                return null;
            }
            enumMap.put(enum_, COUNTER_INDEX_MAP.get(string2));
        }
        return new Pair<Integer, EnumMap<T, Integer>>(n, enumMap);
    }

    private static Memory readPerfDataBuffer(String string) {
        IntByReference intByReference;
        int n;
        Memory memory;
        String string2 = Integer.toString(COUNTER_INDEX_MAP.get(string));
        int n2 = Advapi32.INSTANCE.RegQueryValueEx(WinReg.HKEY_PERFORMANCE_DATA, string2, 0, null, memory = new Memory(n = 4096), intByReference = new IntByReference(n));
        if (n2 != 0 && n2 != 234) {
            LOG.error("Error reading performance data from registry for {}.", (Object)string);
            return null;
        }
        while (n2 == 234) {
            intByReference.setValue(n += 4096);
            memory = new Memory(n);
            n2 = Advapi32.INSTANCE.RegQueryValueEx(WinReg.HKEY_PERFORMANCE_DATA, string2, 0, null, memory, intByReference);
        }
        return memory;
    }

    private static Map<String, Integer> mapCounterIndicesFromRegistry() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        try {
            String[] stringArray = Advapi32Util.registryGetStringArray(WinReg.HKEY_LOCAL_MACHINE, HKEY_PERFORMANCE_TEXT, COUNTER);
            for (int i = 1; i < stringArray.length; i += 2) {
                hashMap.putIfAbsent(stringArray[i], Integer.parseInt(stringArray[i - 1]));
            }
        }
        catch (Win32Exception win32Exception) {
            LOG.error("Unable to locate English counter names in registry Perflib 009. Counters may need to be rebuilt: ", win32Exception);
        }
        catch (NumberFormatException numberFormatException) {
            LOG.error("Unable to parse English counter names in registry Perflib 009.");
        }
        return Collections.unmodifiableMap(hashMap);
    }
}

