/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.windows.registry;

import com.sun.jna.platform.win32.WinBase;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oshi.annotation.concurrent.Immutable;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.windows.perfmon.ProcessInformation;
import oshi.driver.windows.registry.HkeyPerformanceDataUtil;
import oshi.util.GlobalConfig;
import oshi.util.tuples.Pair;
import oshi.util.tuples.Triplet;

@ThreadSafe
public final class ProcessPerformanceData {
    private static final String PROCESS = "Process";
    public static final String WIN_HKEY_PERFDATA = "oshi.os.windows.hkeyperfdata";
    private static final boolean PERFDATA = GlobalConfig.get("oshi.os.windows.hkeyperfdata", true);

    private ProcessPerformanceData() {
    }

    public static Map<Integer, PerfCounterBlock> buildProcessMapFromRegistry(Collection<Integer> collection) {
        Triplet<List<Map<ProcessInformation.ProcessPerformanceProperty, Object>>, Long, Long> triplet = null;
        if (PERFDATA) {
            triplet = HkeyPerformanceDataUtil.readPerfDataFromRegistry(PROCESS, ProcessInformation.ProcessPerformanceProperty.class);
        }
        if (triplet == null) {
            return null;
        }
        List<Map<ProcessInformation.ProcessPerformanceProperty, Object>> list = triplet.getA();
        long l = triplet.getC();
        HashMap<Integer, PerfCounterBlock> hashMap = new HashMap<Integer, PerfCounterBlock>();
        for (Map<ProcessInformation.ProcessPerformanceProperty, Object> map : list) {
            long l2;
            int n = (Integer)map.get(ProcessInformation.ProcessPerformanceProperty.IDPROCESS);
            String string = (String)map.get(ProcessInformation.ProcessPerformanceProperty.NAME);
            if (collection != null && !collection.contains(n) || "_Total".equals(string)) continue;
            long l3 = (Long)map.get(ProcessInformation.ProcessPerformanceProperty.ELAPSEDTIME);
            if (l3 > l) {
                l3 = WinBase.FILETIME.filetimeToDate((int)(l3 >> 32), (int)(l3 & 0xFFFFFFFFL)).getTime();
            }
            if ((l2 = l - l3) < 1L) {
                l2 = 1L;
            }
            hashMap.put(n, new PerfCounterBlock(string, (Integer)map.get(ProcessInformation.ProcessPerformanceProperty.CREATINGPROCESSID), (Integer)map.get(ProcessInformation.ProcessPerformanceProperty.PRIORITYBASE), (Long)map.get(ProcessInformation.ProcessPerformanceProperty.PRIVATEBYTES), l3, l2, (Long)map.get(ProcessInformation.ProcessPerformanceProperty.IOREADBYTESPERSEC), (Long)map.get(ProcessInformation.ProcessPerformanceProperty.IOWRITEBYTESPERSEC), (Integer)map.get(ProcessInformation.ProcessPerformanceProperty.PAGEFAULTSPERSEC)));
        }
        return hashMap;
    }

    public static Map<Integer, PerfCounterBlock> buildProcessMapFromPerfCounters(Collection<Integer> collection) {
        HashMap<Integer, PerfCounterBlock> hashMap = new HashMap<Integer, PerfCounterBlock>();
        Pair<List<String>, Map<ProcessInformation.ProcessPerformanceProperty, List<Long>>> pair = ProcessInformation.queryProcessCounters();
        long l = System.currentTimeMillis();
        List<String> list = pair.getA();
        Map<ProcessInformation.ProcessPerformanceProperty, List<Long>> map = pair.getB();
        List<Long> list2 = map.get(ProcessInformation.ProcessPerformanceProperty.IDPROCESS);
        List<Long> list3 = map.get(ProcessInformation.ProcessPerformanceProperty.CREATINGPROCESSID);
        List<Long> list4 = map.get(ProcessInformation.ProcessPerformanceProperty.PRIORITYBASE);
        List<Long> list5 = map.get(ProcessInformation.ProcessPerformanceProperty.IOREADBYTESPERSEC);
        List<Long> list6 = map.get(ProcessInformation.ProcessPerformanceProperty.IOWRITEBYTESPERSEC);
        List<Long> list7 = map.get(ProcessInformation.ProcessPerformanceProperty.PRIVATEBYTES);
        List<Long> list8 = map.get(ProcessInformation.ProcessPerformanceProperty.ELAPSEDTIME);
        List<Long> list9 = map.get(ProcessInformation.ProcessPerformanceProperty.PAGEFAULTSPERSEC);
        for (int i = 0; i < list.size(); ++i) {
            long l2;
            int n = list2.get(i).intValue();
            if (collection != null && !collection.contains(n)) continue;
            long l3 = list8.get(i);
            if (l3 > l) {
                l3 = WinBase.FILETIME.filetimeToDate((int)(l3 >> 32), (int)(l3 & 0xFFFFFFFFL)).getTime();
            }
            if ((l2 = l - l3) < 1L) {
                l2 = 1L;
            }
            hashMap.put(n, new PerfCounterBlock(list.get(i), list3.get(i).intValue(), list4.get(i).intValue(), list7.get(i), l3, l2, list5.get(i), list6.get(i), list9.get(i).intValue()));
        }
        return hashMap;
    }

    @Immutable
    public static class PerfCounterBlock {
        private final String name;
        private final int parentProcessID;
        private final int priority;
        private final long residentSetSize;
        private final long startTime;
        private final long upTime;
        private final long bytesRead;
        private final long bytesWritten;
        private final int pageFaults;

        public PerfCounterBlock(String string, int n, int n2, long l, long l2, long l3, long l4, long l5, int n3) {
            this.name = string;
            this.parentProcessID = n;
            this.priority = n2;
            this.residentSetSize = l;
            this.startTime = l2;
            this.upTime = l3;
            this.bytesRead = l4;
            this.bytesWritten = l5;
            this.pageFaults = n3;
        }

        public String getName() {
            return this.name;
        }

        public int getParentProcessID() {
            return this.parentProcessID;
        }

        public int getPriority() {
            return this.priority;
        }

        public long getResidentSetSize() {
            return this.residentSetSize;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getUpTime() {
            return this.upTime;
        }

        public long getBytesRead() {
            return this.bytesRead;
        }

        public long getBytesWritten() {
            return this.bytesWritten;
        }

        public long getPageFaults() {
            return this.pageFaults;
        }
    }
}

