/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.windows.wmi;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import java.util.Collection;
import java.util.Set;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.util.platform.windows.WmiQueryHandler;

@ThreadSafe
public final class Win32Process {
    private static final String WIN32_PROCESS = "Win32_Process";

    private Win32Process() {
    }

    public static WbemcliUtil.WmiResult<CommandLineProperty> queryCommandLines(Set<Integer> set) {
        StringBuilder stringBuilder = new StringBuilder(WIN32_PROCESS);
        if (set != null) {
            boolean bl = true;
            for (Integer n : set) {
                if (bl) {
                    stringBuilder.append(" WHERE ProcessID=");
                    bl = false;
                } else {
                    stringBuilder.append(" OR ProcessID=");
                }
                stringBuilder.append(n);
            }
        }
        WbemcliUtil.WmiQuery<CommandLineProperty> wmiQuery = new WbemcliUtil.WmiQuery<CommandLineProperty>(stringBuilder.toString(), CommandLineProperty.class);
        return WmiQueryHandler.createInstance().queryWMI(wmiQuery);
    }

    public static WbemcliUtil.WmiResult<ProcessXPProperty> queryProcesses(Collection<Integer> collection) {
        StringBuilder stringBuilder = new StringBuilder(WIN32_PROCESS);
        if (collection != null) {
            boolean bl = true;
            for (Integer n : collection) {
                if (bl) {
                    stringBuilder.append(" WHERE ProcessID=");
                    bl = false;
                } else {
                    stringBuilder.append(" OR ProcessID=");
                }
                stringBuilder.append(n);
            }
        }
        WbemcliUtil.WmiQuery<ProcessXPProperty> wmiQuery = new WbemcliUtil.WmiQuery<ProcessXPProperty>(stringBuilder.toString(), ProcessXPProperty.class);
        return WmiQueryHandler.createInstance().queryWMI(wmiQuery);
    }

    public static enum CommandLineProperty {
        PROCESSID,
        COMMANDLINE;

    }

    public static enum ProcessXPProperty {
        PROCESSID,
        NAME,
        KERNELMODETIME,
        USERMODETIME,
        THREADCOUNT,
        PAGEFILEUSAGE,
        HANDLECOUNT,
        EXECUTABLEPATH;

    }
}

