/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.LongStream;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.linux.Lshw;
import oshi.driver.linux.proc.CpuStat;
import oshi.hardware.CentralProcessor;
import oshi.hardware.common.AbstractCentralProcessor;
import oshi.jna.platform.linux.LinuxLibc;
import oshi.software.os.linux.LinuxOperatingSystem;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;
import oshi.util.GlobalConfig;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.ProcPath;

@ThreadSafe
final class LinuxCentralProcessor
extends AbstractCentralProcessor {
    private static final String CPUFREQ_PATH = "oshi.cpu.freq.path";

    LinuxCentralProcessor() {
    }

    @Override
    protected CentralProcessor.ProcessorIdentifier queryProcessorId() {
        Object object;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        long l = 0L;
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = new String[]{};
        List<String> list = FileUtil.readFile(ProcPath.CPUINFO);
        block25: for (String object2 : list) {
            object = ParseUtil.whitespacesColonWhitespace.split(object2);
            if (((String[])object).length < 2) {
                if (!object2.startsWith("CPU architecture: ")) continue;
                string3 = object2.replace("CPU architecture: ", "").trim();
                continue;
            }
            block14 : switch (object[0]) {
                case "vendor_id": 
                case "CPU implementer": {
                    string = object[1];
                    break;
                }
                case "model name": 
                case "Processor": {
                    string2 = object[1];
                    break;
                }
                case "flags": {
                    for (String string6 : stringArray = object[1].toLowerCase().split(" ")) {
                        if (!"lm".equals(string6)) continue;
                        bl = true;
                        break block14;
                    }
                    continue block25;
                }
                case "stepping": {
                    string5 = object[1];
                    break;
                }
                case "CPU variant": {
                    if (stringBuilder.toString().startsWith("r")) break;
                    stringBuilder.insert(0, "r" + (String)object[1]);
                    break;
                }
                case "CPU revision": {
                    if (stringBuilder.toString().contains("p")) break;
                    stringBuilder.append('p').append(object[1]);
                    break;
                }
                case "model": 
                case "CPU part": {
                    string4 = object[1];
                    break;
                }
                case "cpu family": {
                    string3 = object[1];
                    break;
                }
                case "cpu MHz": {
                    l = ParseUtil.parseHertz(object[1]);
                    break;
                }
            }
        }
        if (string2.contains("Hz")) {
            l = -1L;
        } else {
            long l2 = Lshw.queryCpuCapacity();
            if (l2 > l) {
                l = l2;
            }
        }
        if (string5.isEmpty()) {
            string5 = stringBuilder.toString();
        }
        String string7 = LinuxCentralProcessor.getProcessorID(string, string5, string4, string3, stringArray);
        if (string.startsWith("0x")) {
            List<String> list2 = ExecutingCommand.runNative("lscpu");
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                if (!((String)object).startsWith("Architecture:")) continue;
                string = ((String)object).replace("Architecture:", "").trim();
            }
        }
        return new CentralProcessor.ProcessorIdentifier(string, string2, string3, string4, string5, string7, bl, l);
    }

    @Override
    protected List<CentralProcessor.LogicalProcessor> initProcessorCounts() {
        Map<Integer, Integer> map = LinuxCentralProcessor.mapNumaNodes();
        List<String> list = FileUtil.readFile(ProcPath.CPUINFO);
        ArrayList<CentralProcessor.LogicalProcessor> arrayList = new ArrayList<CentralProcessor.LogicalProcessor>();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = true;
        for (String string : list) {
            if (string.startsWith("processor")) {
                if (!bl) {
                    arrayList.add(new CentralProcessor.LogicalProcessor(n, n2, n3, map.getOrDefault(n, 0)));
                } else {
                    bl = false;
                }
                n = ParseUtil.parseLastInt(string, 0);
                continue;
            }
            if (string.startsWith("core id") || string.startsWith("cpu number")) {
                n2 = ParseUtil.parseLastInt(string, 0);
                continue;
            }
            if (!string.startsWith("physical id")) continue;
            n3 = ParseUtil.parseLastInt(string, 0);
        }
        arrayList.add(new CentralProcessor.LogicalProcessor(n, n2, n3, map.getOrDefault(n, 0)));
        return arrayList;
    }

    private static Map<Integer, Integer> mapNumaNodes() {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        List<String> list = ExecutingCommand.runNative("lscpu -p=cpu,node");
        for (String string : list) {
            String[] stringArray;
            if (string.startsWith("#") || (stringArray = string.split(",")).length != 2) continue;
            hashMap.put(ParseUtil.parseIntOrDefault(stringArray[0], 0), ParseUtil.parseIntOrDefault(stringArray[1], 0));
        }
        return hashMap;
    }

    @Override
    public long[] querySystemCpuLoadTicks() {
        long[] lArray = CpuStat.getSystemCpuLoadTicks();
        if (LongStream.of(lArray).sum() == 0L) {
            lArray = CpuStat.getSystemCpuLoadTicks();
        }
        long l = LinuxOperatingSystem.getHz();
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = lArray[i] * 1000L / l;
        }
        return lArray;
    }

    @Override
    public long[] queryCurrentFreq() {
        int n;
        String string = GlobalConfig.get(CPUFREQ_PATH, "");
        long[] lArray = new long[this.getLogicalProcessorCount()];
        long l = 0L;
        for (n = 0; n < lArray.length; ++n) {
            lArray[n] = FileUtil.getLongFromFile(string + "/cpu" + n + "/cpufreq/scaling_cur_freq");
            if (lArray[n] == 0L) {
                lArray[n] = FileUtil.getLongFromFile(string + "/cpu" + n + "/cpufreq/cpuinfo_cur_freq");
            }
            if (l >= lArray[n]) continue;
            l = lArray[n];
        }
        if (l > 0L) {
            n = 0;
            while (n < lArray.length) {
                int n2 = n++;
                lArray[n2] = lArray[n2] * 1000L;
            }
            return lArray;
        }
        Arrays.fill(lArray, -1L);
        List<String> list = FileUtil.readFile(ProcPath.CPUINFO);
        int n3 = 0;
        for (String string2 : list) {
            if (!string2.toLowerCase().contains("cpu mhz")) continue;
            lArray[n3] = Math.round(ParseUtil.parseLastDouble(string2, 0.0) * 1000000.0);
            if (++n3 < lArray.length) continue;
            break;
        }
        return lArray;
    }

    @Override
    public long queryMaxFreq() {
        File file;
        File[] fileArray;
        String string = GlobalConfig.get(CPUFREQ_PATH, "");
        long l = Arrays.stream(this.getCurrentFreq()).max().orElse(-1L);
        if (l > 0L) {
            l /= 1000L;
        }
        if ((fileArray = (file = new File(string + "/cpufreq")).listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (!file2.getName().startsWith("policy")) continue;
                long l2 = FileUtil.getLongFromFile(string + "/cpufreq/" + file2.getName() + "/scaling_max_freq");
                if (l2 == 0L) {
                    l2 = FileUtil.getLongFromFile(string + "/cpufreq/" + file2.getName() + "/cpuinfo_max_freq");
                }
                if (l >= l2) continue;
                l = l2;
            }
        }
        if (l > 0L) {
            long l3 = Lshw.queryCpuCapacity();
            return l3 > (l *= 1000L) ? l3 : l;
        }
        return -1L;
    }

    @Override
    public double[] getSystemLoadAverage(int n) {
        if (n < 1 || n > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] dArray = new double[n];
        int n2 = LinuxLibc.INSTANCE.getloadavg(dArray, n);
        if (n2 < n) {
            for (int i = Math.max(n2, 0); i < dArray.length; ++i) {
                dArray[i] = -1.0;
            }
        }
        return dArray;
    }

    @Override
    public long[][] queryProcessorCpuLoadTicks() {
        long[][] lArray = CpuStat.getProcessorCpuLoadTicks(this.getLogicalProcessorCount());
        if (LongStream.of(lArray[0]).sum() == 0L) {
            lArray = CpuStat.getProcessorCpuLoadTicks(this.getLogicalProcessorCount());
        }
        long l = LinuxOperatingSystem.getHz();
        for (int i = 0; i < lArray.length; ++i) {
            for (int j = 0; j < lArray[i].length; ++j) {
                lArray[i][j] = lArray[i][j] * 1000L / l;
            }
        }
        return lArray;
    }

    private static String getProcessorID(String string, String string2, String string3, String string4, String[] stringArray) {
        boolean bl = false;
        String string5 = "Processor Information";
        for (String string6 : ExecutingCommand.runNative("dmidecode -t 4")) {
            if (!bl && string6.contains(string5)) {
                string5 = "ID:";
                bl = true;
                continue;
            }
            if (!bl || !string6.contains(string5)) continue;
            return string6.split(string5)[1].trim();
        }
        string5 = "eax=";
        for (String string6 : ExecutingCommand.runNative("cpuid -1r")) {
            if (!string6.contains(string5) || !string6.trim().startsWith("0x00000001")) continue;
            String string7 = "";
            String string8 = "";
            for (String string9 : ParseUtil.whitespaces.split(string6)) {
                if (string9.startsWith("eax=")) {
                    string7 = ParseUtil.removeMatchingString(string9, "eax=0x");
                    continue;
                }
                if (!string9.startsWith("edx=")) continue;
                string8 = ParseUtil.removeMatchingString(string9, "edx=0x");
            }
            return string8 + string7;
        }
        if (string.startsWith("0x")) {
            return LinuxCentralProcessor.createMIDR(string, string2, string3, string4) + "00000000";
        }
        return LinuxCentralProcessor.createProcessorID(string2, string3, string4, stringArray);
    }

    private static String createMIDR(String string, String string2, String string3, String string4) {
        int n = 0;
        if (string2.startsWith("r") && string2.contains("p")) {
            String[] stringArray = string2.substring(1).split("p");
            n |= ParseUtil.parseLastInt(stringArray[1], 0);
            n |= ParseUtil.parseLastInt(stringArray[0], 0) << 20;
        }
        n |= ParseUtil.parseLastInt(string3, 0) << 4;
        n |= ParseUtil.parseLastInt(string4, 0) << 16;
        return String.format("%08X", n |= ParseUtil.parseLastInt(string, 0) << 24);
    }

    @Override
    public long queryContextSwitches() {
        return CpuStat.getContextSwitches();
    }

    @Override
    public long queryInterrupts() {
        return CpuStat.getInterrupts();
    }
}

