/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.solaris;

import com.sun.jna.platform.unix.solaris.LibKstat;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.PowerSource;
import oshi.hardware.common.AbstractPowerSource;
import oshi.util.platform.unix.solaris.KstatUtil;

@ThreadSafe
public final class SolarisPowerSource
extends AbstractPowerSource {
    private static final String[] KSTAT_BATT_MOD = new String[]{null, "battery", "acpi_drv"};
    private static final int KSTAT_BATT_IDX;

    public SolarisPowerSource(String string, String string2, double d, double d2, double d3, double d4, double d5, double d6, boolean bl, boolean bl2, boolean bl3, PowerSource.CapacityUnits capacityUnits, int n, int n2, int n3, int n4, String string3, LocalDate localDate, String string4, String string5, double d7) {
        super(string, string2, d, d2, d3, d4, d5, d6, bl, bl2, bl3, capacityUnits, n, n2, n3, n4, string3, localDate, string4, string5, d7);
    }

    public static List<PowerSource> getPowerSources() {
        return Arrays.asList(SolarisPowerSource.getPowerSource("BAT0"));
    }

    private static SolarisPowerSource getPowerSource(String string) {
        String string2 = string;
        String string3 = "unknown";
        double d = 1.0;
        double d2 = -1.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = -1.0;
        double d6 = 0.0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        PowerSource.CapacityUnits capacityUnits = PowerSource.CapacityUnits.RELATIVE;
        int n = 0;
        int n2 = 1;
        int n3 = 1;
        int n4 = -1;
        String string4 = "unknown";
        LocalDate localDate = null;
        String string5 = "unknown";
        String string6 = "unknown";
        double d7 = 0.0;
        if (KSTAT_BATT_IDX > 0) {
            try (KstatUtil.KstatChain kstatChain = KstatUtil.openChain();){
                long l;
                long l2;
                LibKstat.Kstat kstat = KstatUtil.KstatChain.lookup(KSTAT_BATT_MOD[KSTAT_BATT_IDX], 0, "battery BIF0");
                if (kstat != null) {
                    l2 = KstatUtil.dataLookupLong(kstat, "bif_last_cap");
                    if (l2 == -1L || l2 <= 0L) {
                        l2 = KstatUtil.dataLookupLong(kstat, "bif_design_cap");
                    }
                    if (l2 != -1L && l2 > 0L) {
                        n2 = (int)l2;
                    }
                    if ((l = KstatUtil.dataLookupLong(kstat, "bif_unit")) == 0L) {
                        capacityUnits = PowerSource.CapacityUnits.MWH;
                    } else if (l == 1L) {
                        capacityUnits = PowerSource.CapacityUnits.MAH;
                    }
                    string3 = KstatUtil.dataLookupString(kstat, "bif_model");
                    string6 = KstatUtil.dataLookupString(kstat, "bif_serial");
                    string4 = KstatUtil.dataLookupString(kstat, "bif_type");
                    string5 = KstatUtil.dataLookupString(kstat, "bif_oem_info");
                }
                if ((kstat = KstatUtil.KstatChain.lookup(KSTAT_BATT_MOD[KSTAT_BATT_IDX], 0, "battery BST0")) != null) {
                    long l3;
                    boolean bl4;
                    l2 = KstatUtil.dataLookupLong(kstat, "bst_rem_cap");
                    if (l2 >= 0L) {
                        n = (int)l2;
                    }
                    if ((l = KstatUtil.dataLookupLong(kstat, "bst_rate")) == -1L) {
                        l = 0L;
                    }
                    boolean bl5 = bl4 = (KstatUtil.dataLookupLong(kstat, "bst_state") & 0x10L) > 0L;
                    if (!bl4) {
                        double d8 = d2 = l > 0L ? 3600.0 * (double)l2 / (double)l : -1.0;
                    }
                    if ((l3 = KstatUtil.dataLookupLong(kstat, "bst_voltage")) > 0L) {
                        d5 = (double)l3 / 1000.0;
                        d6 = d4 * 1000.0 / (double)l3;
                    }
                }
            }
        }
        return new SolarisPowerSource(string2, string3, d, d2, d3, d4, d5, d6, bl, bl2, bl3, capacityUnits, n, n2, n3, n4, string4, localDate, string5, string6, d7);
    }

    static {
        try (KstatUtil.KstatChain kstatChain = KstatUtil.openChain();){
            KSTAT_BATT_IDX = KstatUtil.KstatChain.lookup(KSTAT_BATT_MOD[1], 0, null) != null ? 1 : (KstatUtil.KstatChain.lookup(KSTAT_BATT_MOD[2], 0, null) != null ? 2 : 0);
        }
    }
}

