/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.unix.openbsd;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.unix.LibCAPI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.jna.platform.unix.openbsd.OpenBsdLibc;
import oshi.software.common.AbstractOSProcess;
import oshi.software.os.OSProcess;
import oshi.software.os.OSThread;
import oshi.software.os.unix.openbsd.OpenBsdOSThread;
import oshi.software.os.unix.openbsd.OpenBsdOperatingSystem;
import oshi.util.ExecutingCommand;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.platform.unix.openbsd.FstatUtil;

@ThreadSafe
public class OpenBsdOSProcess
extends AbstractOSProcess {
    private static final Logger LOG = LoggerFactory.getLogger(OpenBsdOSProcess.class);
    static final String PS_THREAD_COLUMNS = Arrays.stream(PsThreadColumns.values()).map(Enum::name).map(String::toLowerCase).collect(Collectors.joining(","));
    private static final int ARGMAX;
    private Supplier<String> commandLine = Memoizer.memoize(this::queryCommandLine);
    private Supplier<List<String>> arguments = Memoizer.memoize(this::queryArguments);
    private Supplier<Map<String, String>> environmentVariables = Memoizer.memoize(this::queryEnvironmentVariables);
    private String name;
    private String path = "";
    private String user;
    private String userID;
    private String group;
    private String groupID;
    private OSProcess.State state = OSProcess.State.INVALID;
    private int parentProcessID;
    private int threadCount;
    private int priority;
    private long virtualSize;
    private long residentSetSize;
    private long kernelTime;
    private long userTime;
    private long startTime;
    private long upTime;
    private long bytesRead;
    private long bytesWritten;
    private long minorFaults;
    private long majorFaults;
    private long contextSwitches;
    private int bitness = Native.LONG_SIZE * 8;
    private String commandLineBackup;

    public OpenBsdOSProcess(int n, Map<OpenBsdOperatingSystem.PsKeywords, String> map) {
        super(n);
        this.updateThreadCount();
        this.updateAttributes(map);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getCommandLine() {
        return this.commandLine.get();
    }

    private String queryCommandLine() {
        String string = String.join((CharSequence)" ", this.getArguments());
        return string.isEmpty() ? this.commandLineBackup : string;
    }

    @Override
    public List<String> getArguments() {
        return this.arguments.get();
    }

    private List<String> queryArguments() {
        LibCAPI.size_t.ByReference byReference;
        Memory memory;
        int[] nArray;
        if (ARGMAX > 0 && OpenBsdLibc.INSTANCE.sysctl(nArray = new int[]{1, 55, this.getProcessID(), 1}, nArray.length, memory = new Memory(ARGMAX), byReference = new LibCAPI.size_t.ByReference(new LibCAPI.size_t((long)ARGMAX)), null, LibCAPI.size_t.ZERO) == 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            long l = 0L;
            long l2 = Pointer.nativeValue(memory);
            long l3 = l2 + byReference.getValue().longValue();
            long l4 = Pointer.nativeValue(memory.getPointer(l));
            while (l4 > l2 && l4 < l3) {
                arrayList.add(memory.getString(l4 - l2));
                l4 = Pointer.nativeValue(memory.getPointer(l += (long)Native.POINTER_SIZE));
            }
            return Collections.unmodifiableList(arrayList);
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables.get();
    }

    private Map<String, String> queryEnvironmentVariables() {
        LibCAPI.size_t.ByReference byReference;
        Memory memory;
        int[] nArray = new int[]{1, 55, this.getProcessID(), 3};
        if (OpenBsdLibc.INSTANCE.sysctl(nArray, nArray.length, memory = new Memory(ARGMAX), byReference = new LibCAPI.size_t.ByReference(new LibCAPI.size_t((long)ARGMAX)), null, LibCAPI.size_t.ZERO) == 0) {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            long l = 0L;
            long l2 = Pointer.nativeValue(memory);
            long l3 = l2 + byReference.longValue();
            long l4 = Pointer.nativeValue(memory.getPointer(l));
            while (l4 > l2 && l4 < l3) {
                String string = memory.getString(l4 - l2);
                int n = string.indexOf(61);
                if (n > 0) {
                    linkedHashMap.put(string.substring(0, n), string.substring(n + 1));
                }
                l4 = Pointer.nativeValue(memory.getPointer(l += (long)Native.POINTER_SIZE));
            }
            return Collections.unmodifiableMap(linkedHashMap);
        }
        return Collections.emptyMap();
    }

    @Override
    public String getCurrentWorkingDirectory() {
        return FstatUtil.getCwd(this.getProcessID());
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getUserID() {
        return this.userID;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getGroupID() {
        return this.groupID;
    }

    @Override
    public OSProcess.State getState() {
        return this.state;
    }

    @Override
    public int getParentProcessID() {
        return this.parentProcessID;
    }

    @Override
    public int getThreadCount() {
        return this.threadCount;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public long getVirtualSize() {
        return this.virtualSize;
    }

    @Override
    public long getResidentSetSize() {
        return this.residentSetSize;
    }

    @Override
    public long getKernelTime() {
        return this.kernelTime;
    }

    @Override
    public long getUserTime() {
        return this.userTime;
    }

    @Override
    public long getUpTime() {
        return this.upTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getBytesRead() {
        return this.bytesRead;
    }

    @Override
    public long getBytesWritten() {
        return this.bytesWritten;
    }

    @Override
    public long getOpenFiles() {
        return FstatUtil.getOpenFiles(this.getProcessID());
    }

    @Override
    public int getBitness() {
        return this.bitness;
    }

    @Override
    public long getAffinityMask() {
        long l = 0L;
        String string = ExecutingCommand.getFirstAnswer("cpuset -gp " + this.getProcessID());
        String[] stringArray = string.split(":");
        if (stringArray.length > 1) {
            String[] stringArray2;
            for (String string2 : stringArray2 = stringArray[1].split(",")) {
                int n = ParseUtil.parseIntOrDefault(string2.trim(), -1);
                if (n < 0) continue;
                l |= 1L << n;
            }
        }
        return l;
    }

    @Override
    public List<OSThread> getThreadDetails() {
        List<String> list;
        ArrayList<OSThread> arrayList = new ArrayList<OSThread>();
        String string = "ps -aHwwxo " + PS_THREAD_COLUMNS;
        if (this.getProcessID() >= 0) {
            string = string + " -p " + this.getProcessID();
        }
        if ((list = ExecutingCommand.runNative(string)).isEmpty() || list.size() < 2) {
            return arrayList;
        }
        list.remove(0);
        for (String string2 : list) {
            Map<PsThreadColumns, String> map = ParseUtil.stringToEnumMap(PsThreadColumns.class, string2.trim(), ' ');
            if (!map.containsKey((Object)PsThreadColumns.ARGS)) continue;
            arrayList.add(new OpenBsdOSThread(this.getProcessID(), map));
        }
        return arrayList;
    }

    @Override
    public long getMinorFaults() {
        return this.minorFaults;
    }

    @Override
    public long getMajorFaults() {
        return this.majorFaults;
    }

    @Override
    public long getContextSwitches() {
        return this.contextSwitches;
    }

    @Override
    public boolean updateAttributes() {
        Map<OpenBsdOperatingSystem.PsKeywords, String> map;
        String string = "ps -awwxo " + OpenBsdOperatingSystem.PS_COMMAND_ARGS + " -p " + this.getProcessID();
        List<String> list = ExecutingCommand.runNative(string);
        if (list.size() > 1 && (map = ParseUtil.stringToEnumMap(OpenBsdOperatingSystem.PsKeywords.class, list.get(1).trim(), ' ')).containsKey((Object)OpenBsdOperatingSystem.PsKeywords.ARGS)) {
            this.updateThreadCount();
            return this.updateAttributes(map);
        }
        this.state = OSProcess.State.INVALID;
        return false;
    }

    private boolean updateAttributes(Map<OpenBsdOperatingSystem.PsKeywords, String> map) {
        long l = System.currentTimeMillis();
        switch (map.get((Object)OpenBsdOperatingSystem.PsKeywords.STATE).charAt(0)) {
            case 'R': {
                this.state = OSProcess.State.RUNNING;
                break;
            }
            case 'I': 
            case 'S': {
                this.state = OSProcess.State.SLEEPING;
                break;
            }
            case 'D': 
            case 'L': 
            case 'U': {
                this.state = OSProcess.State.WAITING;
                break;
            }
            case 'Z': {
                this.state = OSProcess.State.ZOMBIE;
                break;
            }
            case 'T': {
                this.state = OSProcess.State.STOPPED;
                break;
            }
            default: {
                this.state = OSProcess.State.OTHER;
            }
        }
        this.parentProcessID = ParseUtil.parseIntOrDefault(map.get((Object)OpenBsdOperatingSystem.PsKeywords.PPID), 0);
        this.user = map.get((Object)OpenBsdOperatingSystem.PsKeywords.USER);
        this.userID = map.get((Object)OpenBsdOperatingSystem.PsKeywords.UID);
        this.group = map.get((Object)OpenBsdOperatingSystem.PsKeywords.GROUP);
        this.groupID = map.get((Object)OpenBsdOperatingSystem.PsKeywords.GID);
        this.priority = ParseUtil.parseIntOrDefault(map.get((Object)OpenBsdOperatingSystem.PsKeywords.PRI), 0);
        this.virtualSize = ParseUtil.parseLongOrDefault(map.get((Object)OpenBsdOperatingSystem.PsKeywords.VSZ), 0L) * 1024L;
        this.residentSetSize = ParseUtil.parseLongOrDefault(map.get((Object)OpenBsdOperatingSystem.PsKeywords.RSS), 0L) * 1024L;
        long l2 = ParseUtil.parseDHMSOrDefault(map.get((Object)OpenBsdOperatingSystem.PsKeywords.ETIME), 0L);
        this.upTime = l2 < 1L ? 1L : l2;
        this.startTime = l - this.upTime;
        this.userTime = ParseUtil.parseDHMSOrDefault(map.get((Object)OpenBsdOperatingSystem.PsKeywords.CPUTIME), 0L);
        this.kernelTime = 0L;
        this.path = map.get((Object)OpenBsdOperatingSystem.PsKeywords.COMM);
        this.name = this.path.substring(this.path.lastIndexOf(47) + 1);
        this.minorFaults = ParseUtil.parseLongOrDefault(map.get((Object)OpenBsdOperatingSystem.PsKeywords.MINFLT), 0L);
        this.majorFaults = ParseUtil.parseLongOrDefault(map.get((Object)OpenBsdOperatingSystem.PsKeywords.MAJFLT), 0L);
        long l3 = ParseUtil.parseLongOrDefault(map.get((Object)OpenBsdOperatingSystem.PsKeywords.NIVCSW), 0L);
        long l4 = ParseUtil.parseLongOrDefault(map.get((Object)OpenBsdOperatingSystem.PsKeywords.NVCSW), 0L);
        this.contextSwitches = l4 + l3;
        this.commandLineBackup = map.get((Object)OpenBsdOperatingSystem.PsKeywords.ARGS);
        return true;
    }

    private void updateThreadCount() {
        List<String> list = ExecutingCommand.runNative("ps -axHo tid -p " + this.getProcessID());
        if (!list.isEmpty()) {
            this.threadCount = list.size() - 1;
        }
        this.threadCount = 1;
    }

    static {
        int[] nArray = new int[]{1, 8};
        Memory memory = new Memory(4L);
        LibCAPI.size_t.ByReference byReference = new LibCAPI.size_t.ByReference(new LibCAPI.size_t(4L));
        if (OpenBsdLibc.INSTANCE.sysctl(nArray, nArray.length, memory, byReference, null, LibCAPI.size_t.ZERO) == 0) {
            ARGMAX = memory.getInt(0L);
        } else {
            LOG.warn("Failed sysctl call for process arguments max size (kern.argmax). Error code: {}", (Object)Native.getLastError());
            ARGMAX = 0;
        }
    }

    static enum PsThreadColumns {
        TID,
        STATE,
        ETIME,
        CPUTIME,
        NIVCSW,
        NVCSW,
        MAJFLT,
        MINFLT,
        PRI,
        ARGS;

    }
}

