/*
 * Decompiled with CFR 0.152.
 */
package oshi.util;

import java.math.BigInteger;
import java.util.concurrent.TimeUnit;
import oshi.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class FormatUtil {
    private static final long KIBI = 1024L;
    private static final long MEBI = 0x100000L;
    private static final long GIBI = 0x40000000L;
    private static final long TEBI = 0x10000000000L;
    private static final long PEBI = 0x4000000000000L;
    private static final long EXBI = 0x1000000000000000L;
    private static final long KILO = 1000L;
    private static final long MEGA = 1000000L;
    private static final long GIGA = 1000000000L;
    private static final long TERA = 1000000000000L;
    private static final long PETA = 1000000000000000L;
    private static final long EXA = 1000000000000000000L;
    private static final BigInteger TWOS_COMPLEMENT_REF = BigInteger.ONE.shiftLeft(64);
    public static final String HEX_ERROR = "0x%08X";

    private FormatUtil() {
    }

    public static String formatBytes(long l) {
        if (l == 1L) {
            return String.format("%d byte", l);
        }
        if (l < 1024L) {
            return String.format("%d bytes", l);
        }
        if (l < 0x100000L) {
            return FormatUtil.formatUnits(l, 1024L, "KiB");
        }
        if (l < 0x40000000L) {
            return FormatUtil.formatUnits(l, 0x100000L, "MiB");
        }
        if (l < 0x10000000000L) {
            return FormatUtil.formatUnits(l, 0x40000000L, "GiB");
        }
        if (l < 0x4000000000000L) {
            return FormatUtil.formatUnits(l, 0x10000000000L, "TiB");
        }
        if (l < 0x1000000000000000L) {
            return FormatUtil.formatUnits(l, 0x4000000000000L, "PiB");
        }
        return FormatUtil.formatUnits(l, 0x1000000000000000L, "EiB");
    }

    private static String formatUnits(long l, long l2, String string) {
        if (l % l2 == 0L) {
            return String.format("%d %s", l / l2, string);
        }
        return String.format("%.1f %s", (double)l / (double)l2, string);
    }

    public static String formatBytesDecimal(long l) {
        if (l == 1L) {
            return String.format("%d byte", l);
        }
        if (l < 1000L) {
            return String.format("%d bytes", l);
        }
        return FormatUtil.formatValue(l, "B");
    }

    public static String formatHertz(long l) {
        return FormatUtil.formatValue(l, "Hz");
    }

    public static String formatValue(long l, String string) {
        if (l < 1000L) {
            return String.format("%d %s", l, string).trim();
        }
        if (l < 1000000L) {
            return FormatUtil.formatUnits(l, 1000L, "K" + string);
        }
        if (l < 1000000000L) {
            return FormatUtil.formatUnits(l, 1000000L, "M" + string);
        }
        if (l < 1000000000000L) {
            return FormatUtil.formatUnits(l, 1000000000L, "G" + string);
        }
        if (l < 1000000000000000L) {
            return FormatUtil.formatUnits(l, 1000000000000L, "T" + string);
        }
        if (l < 1000000000000000000L) {
            return FormatUtil.formatUnits(l, 1000000000000000L, "P" + string);
        }
        return FormatUtil.formatUnits(l, 1000000000000000000L, "E" + string);
    }

    public static String formatElapsedSecs(long l) {
        long l2 = l;
        long l3 = TimeUnit.SECONDS.toDays(l2);
        long l4 = TimeUnit.SECONDS.toHours(l2 -= TimeUnit.DAYS.toSeconds(l3));
        long l5 = TimeUnit.SECONDS.toMinutes(l2 -= TimeUnit.HOURS.toSeconds(l4));
        long l6 = l2 -= TimeUnit.MINUTES.toSeconds(l5);
        return String.format("%d days, %02d:%02d:%02d", l3, l4, l5, l6);
    }

    public static long getUnsignedInt(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    public static String toUnsignedString(int n) {
        if (n >= 0) {
            return Integer.toString(n);
        }
        return Long.toString(FormatUtil.getUnsignedInt(n));
    }

    public static String toUnsignedString(long l) {
        if (l >= 0L) {
            return Long.toString(l);
        }
        return BigInteger.valueOf(l).add(TWOS_COMPLEMENT_REF).toString();
    }

    public static String formatError(int n) {
        return String.format(HEX_ERROR, n);
    }

    public static int roundToInt(double d) {
        return (int)Math.round(d);
    }
}

