/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.mac;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.unix.LibCAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.jna.platform.mac.SystemB;

@ThreadSafe
public final class SysctlUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SysctlUtil.class);
    private static final String SYSCTL_FAIL = "Failed sysctl call: {}, Error code: {}";

    private SysctlUtil() {
    }

    public static int sysctl(String string, int n) {
        LibCAPI.size_t.ByReference byReference = new LibCAPI.size_t.ByReference((long)com.sun.jna.platform.mac.SystemB.INT_SIZE);
        Memory memory = new Memory(byReference.longValue());
        if (0 != SystemB.INSTANCE.sysctlbyname(string, (Pointer)memory, byReference, null, LibCAPI.size_t.ZERO)) {
            LOG.warn(SYSCTL_FAIL, (Object)string, (Object)Native.getLastError());
            return n;
        }
        return ((Pointer)memory).getInt(0L);
    }

    public static long sysctl(String string, long l) {
        LibCAPI.size_t.ByReference byReference = new LibCAPI.size_t.ByReference((long)com.sun.jna.platform.mac.SystemB.UINT64_SIZE);
        Memory memory = new Memory(byReference.longValue());
        if (0 != SystemB.INSTANCE.sysctlbyname(string, (Pointer)memory, byReference, null, LibCAPI.size_t.ZERO)) {
            LOG.error(SYSCTL_FAIL, (Object)string, (Object)Native.getLastError());
            return l;
        }
        return ((Pointer)memory).getLong(0L);
    }

    public static String sysctl(String string, String string2) {
        LibCAPI.size_t.ByReference byReference = new LibCAPI.size_t.ByReference();
        if (0 != SystemB.INSTANCE.sysctlbyname(string, null, byReference, null, LibCAPI.size_t.ZERO)) {
            LOG.error(SYSCTL_FAIL, (Object)string, (Object)Native.getLastError());
            return string2;
        }
        Memory memory = new Memory(byReference.longValue() + 1L);
        if (0 != SystemB.INSTANCE.sysctlbyname(string, (Pointer)memory, byReference, null, LibCAPI.size_t.ZERO)) {
            LOG.error(SYSCTL_FAIL, (Object)string, (Object)Native.getLastError());
            return string2;
        }
        return memory.getString(0L);
    }

    public static boolean sysctl(String string, Structure structure) {
        if (0 != SystemB.INSTANCE.sysctlbyname(string, structure.getPointer(), new LibCAPI.size_t.ByReference((long)structure.size()), null, LibCAPI.size_t.ZERO)) {
            LOG.error(SYSCTL_FAIL, (Object)string, (Object)Native.getLastError());
            return false;
        }
        structure.read();
        return true;
    }

    public static Memory sysctl(String string) {
        LibCAPI.size_t.ByReference byReference = new LibCAPI.size_t.ByReference();
        if (0 != SystemB.INSTANCE.sysctlbyname(string, null, byReference, null, LibCAPI.size_t.ZERO)) {
            LOG.error(SYSCTL_FAIL, (Object)string, (Object)Native.getLastError());
            return null;
        }
        Memory memory = new Memory(byReference.longValue());
        if (0 != SystemB.INSTANCE.sysctlbyname(string, (Pointer)memory, byReference, null, LibCAPI.size_t.ZERO)) {
            LOG.error(SYSCTL_FAIL, (Object)string, (Object)Native.getLastError());
            return null;
        }
        return memory;
    }
}

