/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.profiles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import pro.gravit.launcher.OmIcHxysqmBdp7;
import pro.gravit.launcher.omiCh5EShyqqIA;
import pro.gravit.launcher.profiles.ClientProfile$ClassLoaderConfig;
import pro.gravit.launcher.profiles.ClientProfile$ProfileDefaultSettings;
import pro.gravit.launcher.profiles.ClientProfile$RuntimeInClientConfig;
import pro.gravit.launcher.profiles.ClientProfile$SecurityManagerConfig;
import pro.gravit.launcher.profiles.ClientProfile$ServerProfile;
import pro.gravit.launcher.profiles.ClientProfile$SignedClientConfig;
import pro.gravit.launcher.profiles.ClientProfile$Version;
import pro.gravit.launcher.profiles.optional.OptionalDepend;
import pro.gravit.launcher.profiles.optional.OptionalFile;
import pro.gravit.launcher.profiles.optional.triggers.OptionalTrigger;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.VerifyHelper;

public final class ClientProfile
implements Comparable<ClientProfile> {
    private static final OmIcHxysqmBdp7 ASSET_MATCHER = new OmIcHxysqmBdp7(new String[0], new String[]{"indexes", "objects"}, new String[0]);
    @omiCh5EShyqqIA
    private String title;
    @omiCh5EShyqqIA
    private UUID uuid;
    @omiCh5EShyqqIA
    private String version;
    @omiCh5EShyqqIA
    private String info;
    @omiCh5EShyqqIA
    private String dir;
    @omiCh5EShyqqIA
    private int sortIndex;
    @omiCh5EShyqqIA
    private String assetIndex;
    @omiCh5EShyqqIA
    private String assetDir;
    @omiCh5EShyqqIA
    private List<String> update;
    @omiCh5EShyqqIA
    private List<String> updateExclusions;
    @omiCh5EShyqqIA
    private List<String> updateShared;
    @omiCh5EShyqqIA
    private List<String> updateVerify;
    @omiCh5EShyqqIA
    private Set<OptionalFile> updateOptional;
    @omiCh5EShyqqIA
    private List<String> jvmArgs;
    @omiCh5EShyqqIA
    private List<String> classPath;
    @omiCh5EShyqqIA
    private List<String> altClassPath;
    @omiCh5EShyqqIA
    private List<String> clientArgs;
    @omiCh5EShyqqIA
    private List<String> compatClasses;
    @omiCh5EShyqqIA
    private Map<String, String> properties;
    @omiCh5EShyqqIA
    private List<ClientProfile$ServerProfile> servers;
    @omiCh5EShyqqIA
    private ClientProfile$SecurityManagerConfig securityManagerConfig;
    @omiCh5EShyqqIA
    private ClientProfile$ClassLoaderConfig classLoaderConfig;
    @omiCh5EShyqqIA
    private ClientProfile$SignedClientConfig signedClientConfig;
    @omiCh5EShyqqIA
    private ClientProfile$RuntimeInClientConfig runtimeInClientConfig;
    @omiCh5EShyqqIA
    private int recommendJavaVersion = 8;
    @omiCh5EShyqqIA
    private int minJavaVersion = 8;
    @omiCh5EShyqqIA
    private int maxJavaVersion = 999;
    @omiCh5EShyqqIA
    private boolean warnMissJavaVersion = true;
    @omiCh5EShyqqIA
    private ClientProfile$ProfileDefaultSettings settings = new ClientProfile$ProfileDefaultSettings();
    @omiCh5EShyqqIA
    private boolean updateFastCheck;
    @omiCh5EShyqqIA
    private boolean limited;
    @omiCh5EShyqqIA
    private String mainClass;

    public ClientProfile() {
        this.update = new ArrayList<String>();
        this.updateExclusions = new ArrayList<String>();
        this.updateShared = new ArrayList<String>();
        this.updateVerify = new ArrayList<String>();
        this.updateOptional = new HashSet<OptionalFile>();
        this.jvmArgs = new ArrayList<String>();
        this.classPath = new ArrayList<String>();
        this.altClassPath = new ArrayList<String>();
        this.clientArgs = new ArrayList<String>();
        this.compatClasses = new ArrayList<String>();
        this.properties = new HashMap<String, String>();
        this.servers = new ArrayList<ClientProfile$ServerProfile>(1);
        this.securityManagerConfig = ClientProfile$SecurityManagerConfig.CLIENT;
        this.classLoaderConfig = ClientProfile$ClassLoaderConfig.LAUNCHER;
        this.signedClientConfig = ClientProfile$SignedClientConfig.NONE;
        this.runtimeInClientConfig = ClientProfile$RuntimeInClientConfig.NONE;
    }

    public ClientProfile(List<String> list, List<String> list2, List<String> list3, List<String> list4, Set<OptionalFile> set, List<String> list5, List<String> list6, List<String> list7, List<String> list8, List<String> list9, Map<String, String> map, List<ClientProfile$ServerProfile> list10, ClientProfile$SecurityManagerConfig clientProfile$SecurityManagerConfig, ClientProfile$ClassLoaderConfig clientProfile$ClassLoaderConfig, ClientProfile$SignedClientConfig clientProfile$SignedClientConfig, ClientProfile$RuntimeInClientConfig clientProfile$RuntimeInClientConfig, String string, String string2, String string3, String string4, int n, int n2, int n3, boolean bl, ClientProfile$ProfileDefaultSettings clientProfile$ProfileDefaultSettings, int n4, UUID uUID, String string5, String string6, boolean bl2, String string7) {
        this.update = list;
        this.updateExclusions = list2;
        this.updateShared = list3;
        this.updateVerify = list4;
        this.updateOptional = set;
        this.jvmArgs = list5;
        this.classPath = list6;
        this.altClassPath = list7;
        this.clientArgs = list8;
        this.compatClasses = list9;
        this.properties = map;
        this.servers = list10;
        this.securityManagerConfig = clientProfile$SecurityManagerConfig;
        this.classLoaderConfig = clientProfile$ClassLoaderConfig;
        this.signedClientConfig = clientProfile$SignedClientConfig;
        this.runtimeInClientConfig = clientProfile$RuntimeInClientConfig;
        this.version = string;
        this.assetIndex = string2;
        this.dir = string3;
        this.assetDir = string4;
        this.recommendJavaVersion = n;
        this.minJavaVersion = n2;
        this.maxJavaVersion = n3;
        this.warnMissJavaVersion = bl;
        this.settings = clientProfile$ProfileDefaultSettings;
        this.sortIndex = n4;
        this.uuid = uUID;
        this.title = string5;
        this.info = string6;
        this.updateFastCheck = bl2;
        this.mainClass = string7;
    }

    public ClientProfile$ServerProfile getDefaultServerProfile() {
        for (ClientProfile$ServerProfile clientProfile$ServerProfile : this.servers) {
            if (!clientProfile$ServerProfile.isDefault) continue;
            return clientProfile$ServerProfile;
        }
        return null;
    }

    @Override
    public int compareTo(ClientProfile clientProfile) {
        return Integer.compare(this.getSortIndex(), clientProfile.getSortIndex());
    }

    public String getAssetIndex() {
        return this.assetIndex;
    }

    public OmIcHxysqmBdp7 getAssetUpdateMatcher() {
        return this.getVersion().compareTo(ClientProfile$Version.MC1710) >= 0 ? ASSET_MATCHER : null;
    }

    public String[] getClassPath() {
        return this.classPath.toArray(new String[0]);
    }

    public String[] getAlternativeClassPath() {
        return this.altClassPath.toArray(new String[0]);
    }

    public String[] getClientArgs() {
        return this.clientArgs.toArray(new String[0]);
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String string) {
        this.dir = string;
    }

    public String getAssetDir() {
        return this.assetDir;
    }

    public List<String> getUpdateExclusions() {
        return Collections.unmodifiableList(this.updateExclusions);
    }

    public OmIcHxysqmBdp7 getClientUpdateMatcher() {
        String[] stringArray = this.update.toArray(new String[0]);
        String[] stringArray2 = this.updateVerify.toArray(new String[0]);
        List<String> list = this.updateExclusions;
        String[] stringArray3 = list.toArray(new String[0]);
        return new OmIcHxysqmBdp7(stringArray, stringArray2, stringArray3);
    }

    public String[] getJvmArgs() {
        return this.jvmArgs.toArray(new String[0]);
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public List<ClientProfile$ServerProfile> getServers() {
        return this.servers;
    }

    public String getServerAddress() {
        ClientProfile$ServerProfile clientProfile$ServerProfile = this.getDefaultServerProfile();
        return clientProfile$ServerProfile == null ? "localhost" : clientProfile$ServerProfile.serverAddress;
    }

    public Set<OptionalFile> getOptional() {
        return this.updateOptional;
    }

    public int getRecommendJavaVersion() {
        return this.recommendJavaVersion;
    }

    public int getMinJavaVersion() {
        return this.minJavaVersion;
    }

    public int getMaxJavaVersion() {
        return this.maxJavaVersion;
    }

    public boolean isWarnMissJavaVersion() {
        return this.warnMissJavaVersion;
    }

    public ClientProfile$ProfileDefaultSettings getSettings() {
        return this.settings;
    }

    public void updateOptionalGraph() {
        for (OptionalFile optionalFile : this.updateOptional) {
            int n;
            if (optionalFile.dependenciesFile != null) {
                optionalFile.dependencies = new OptionalFile[optionalFile.dependenciesFile.length];
                for (n = 0; n < optionalFile.dependenciesFile.length; ++n) {
                    optionalFile.dependencies[n] = this.getOptionalFile(optionalFile.dependenciesFile[n].name);
                }
            }
            if (optionalFile.conflictFile == null) continue;
            optionalFile.conflict = new OptionalFile[optionalFile.conflictFile.length];
            for (n = 0; n < optionalFile.conflictFile.length; ++n) {
                optionalFile.conflict[n] = this.getOptionalFile(optionalFile.conflictFile[n].name);
            }
        }
    }

    public OptionalFile getOptionalFile(String string) {
        for (OptionalFile optionalFile : this.updateOptional) {
            if (!optionalFile.name.equals(string)) continue;
            return optionalFile;
        }
        return null;
    }

    public Collection<String> getShared() {
        return this.updateShared;
    }

    public int getServerPort() {
        ClientProfile$ServerProfile clientProfile$ServerProfile = this.getDefaultServerProfile();
        return clientProfile$ServerProfile == null ? 25565 : clientProfile$ServerProfile.serverPort;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String string) {
        this.info = string;
    }

    public ClientProfile$Version getVersion() {
        return ClientProfile$Version.byName(this.version);
    }

    public void setVersion(ClientProfile$Version clientProfile$Version) {
        this.version = clientProfile$Version.name;
    }

    public boolean isUpdateFastCheck() {
        return this.updateFastCheck;
    }

    public String toString() {
        return String.format("%s (%s)", this.title, this.uuid);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void setUUID(UUID uUID) {
        this.uuid = uUID;
    }

    public void verify() {
        this.getVersion();
        IOHelper.verifyFileName(this.getAssetIndex());
        VerifyHelper.verify(this.getTitle(), VerifyHelper.NOT_EMPTY, "Profile title can't be empty");
        VerifyHelper.verify(this.getInfo(), VerifyHelper.NOT_EMPTY, "Profile info can't be empty");
        VerifyHelper.verify(this.getTitle(), VerifyHelper.NOT_EMPTY, "Main class can't be empty");
        if (this.getUUID() == null) {
            throw new IllegalArgumentException("Profile UUID can't be null");
        }
        for (String object : this.update) {
            if (object != null) continue;
            throw new IllegalArgumentException("Found null entry in update");
        }
        for (String string : this.updateVerify) {
            if (string != null) continue;
            throw new IllegalArgumentException("Found null entry in updateVerify");
        }
        for (String string : this.updateExclusions) {
            if (string != null) continue;
            throw new IllegalArgumentException("Found null entry in updateExclusions");
        }
        for (String string : this.classPath) {
            if (string != null) continue;
            throw new IllegalArgumentException("Found null entry in classPath");
        }
        for (String string : this.jvmArgs) {
            if (string != null) continue;
            throw new IllegalArgumentException("Found null entry in jvmArgs");
        }
        for (String string : this.clientArgs) {
            if (string != null) continue;
            throw new IllegalArgumentException("Found null entry in clientArgs");
        }
        for (String string : this.compatClasses) {
            if (string != null) continue;
            throw new IllegalArgumentException("Found null entry in compatClasses");
        }
        for (OptionalFile optionalFile : this.updateOptional) {
            if (optionalFile == null) {
                throw new IllegalArgumentException("Found null entry in updateOptional");
            }
            if (optionalFile.name == null) {
                throw new IllegalArgumentException("Optional: name must not be null");
            }
            if (optionalFile.conflictFile != null) {
                for (OptionalDepend optionalDepend : optionalFile.conflictFile) {
                    if (optionalDepend != null) continue;
                    throw new IllegalArgumentException(String.format("Found null entry in updateOptional.%s.conflictFile", optionalFile.name));
                }
            }
            if (optionalFile.dependenciesFile != null) {
                for (OptionalDepend optionalDepend : optionalFile.dependenciesFile) {
                    if (optionalDepend != null) continue;
                    throw new IllegalArgumentException(String.format("Found null entry in updateOptional.%s.dependenciesFile", optionalFile.name));
                }
            }
            if (optionalFile.triggersList == null) continue;
            for (OptionalTrigger optionalTrigger : optionalFile.triggersList) {
                if (optionalTrigger != null) continue;
                throw new IllegalArgumentException(String.format("Found null entry in updateOptional.%s.triggers", optionalFile.name));
            }
        }
    }

    public String getProperty(String string) {
        return this.properties.get(string);
    }

    public void putProperty(String string, String string2) {
        this.properties.put(string, string2);
    }

    public boolean containsProperty(String string) {
        return this.properties.containsKey(string);
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public List<String> getCompatClasses() {
        return Collections.unmodifiableList(this.compatClasses);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ClientProfile clientProfile = (ClientProfile)object;
        return Objects.equals(this.uuid, clientProfile.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    public ClientProfile$SecurityManagerConfig getSecurityManagerConfig() {
        return this.securityManagerConfig;
    }

    public void setSecurityManagerConfig(ClientProfile$SecurityManagerConfig clientProfile$SecurityManagerConfig) {
        this.securityManagerConfig = clientProfile$SecurityManagerConfig;
    }

    public ClientProfile$ClassLoaderConfig getClassLoaderConfig() {
        return this.classLoaderConfig;
    }

    public void setClassLoaderConfig(ClientProfile$ClassLoaderConfig clientProfile$ClassLoaderConfig) {
        this.classLoaderConfig = clientProfile$ClassLoaderConfig;
    }

    public ClientProfile$SignedClientConfig getSignedClientConfig() {
        return this.signedClientConfig;
    }

    public void setSignedClientConfig(ClientProfile$SignedClientConfig clientProfile$SignedClientConfig) {
        this.signedClientConfig = clientProfile$SignedClientConfig;
    }

    public ClientProfile$RuntimeInClientConfig getRuntimeInClientConfig() {
        return this.runtimeInClientConfig;
    }

    public void setRuntimeInClientConfig(ClientProfile$RuntimeInClientConfig clientProfile$RuntimeInClientConfig) {
        this.runtimeInClientConfig = clientProfile$RuntimeInClientConfig;
    }

    public boolean isLimited() {
        return this.limited;
    }
}

