/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.profiles.optional;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.profiles.optional.OptionalFile;
import pro.gravit.launcher.profiles.optional.OptionalView$OptionalFileInstallInfo;
import pro.gravit.launcher.profiles.optional.actions.OptionalAction;

public class OptionalView {
    public Set<OptionalFile> enabled = new HashSet<OptionalFile>();
    public Map<OptionalFile, OptionalView$OptionalFileInstallInfo> installInfo = new HashMap<OptionalFile, OptionalView$OptionalFileInstallInfo>();
    public Set<OptionalFile> all;

    public OptionalView(ClientProfile clientProfile) {
        this.all = clientProfile.getOptional();
        for (OptionalFile optionalFile : this.all) {
            if (!optionalFile.mark) continue;
            this.enable(optionalFile, true, null);
        }
    }

    public OptionalView(OptionalView optionalView) {
        this.enabled = new HashSet<OptionalFile>(optionalView.enabled);
        this.installInfo = new HashMap<OptionalFile, OptionalView$OptionalFileInstallInfo>(optionalView.installInfo);
        this.all = optionalView.all;
    }

    public <T extends OptionalAction> Set<T> getActionsByClass(Class<T> clazz) {
        HashSet<OptionalAction> hashSet = new HashSet<OptionalAction>();
        for (OptionalFile optionalFile : this.enabled) {
            if (optionalFile.actions == null) continue;
            for (OptionalAction optionalAction : optionalFile.actions) {
                if (!clazz.isAssignableFrom(optionalAction.getClass())) continue;
                hashSet.add(optionalAction);
            }
        }
        return hashSet;
    }

    public Set<OptionalAction> getEnabledActions() {
        HashSet<OptionalAction> hashSet = new HashSet<OptionalAction>();
        for (OptionalFile optionalFile : this.enabled) {
            if (optionalFile.actions == null) continue;
            hashSet.addAll(optionalFile.actions);
        }
        return hashSet;
    }

    public Set<OptionalAction> getDisabledActions() {
        HashSet<OptionalAction> hashSet = new HashSet<OptionalAction>();
        for (OptionalFile optionalFile : this.all) {
            if (this.enabled.contains(optionalFile) || optionalFile.actions == null) continue;
            hashSet.addAll(optionalFile.actions);
        }
        return hashSet;
    }

    public void enable(OptionalFile optionalFile, boolean bl, BiConsumer<OptionalFile, Boolean> biConsumer) {
        OptionalView$OptionalFileInstallInfo optionalView$OptionalFileInstallInfo;
        if (this.enabled.contains(optionalFile)) {
            return;
        }
        this.enabled.add(optionalFile);
        if (biConsumer != null) {
            biConsumer.accept(optionalFile, true);
        }
        if ((optionalView$OptionalFileInstallInfo = this.installInfo.get(optionalFile)) == null) {
            optionalView$OptionalFileInstallInfo = new OptionalView$OptionalFileInstallInfo();
            this.installInfo.put(optionalFile, optionalView$OptionalFileInstallInfo);
        }
        optionalView$OptionalFileInstallInfo.isManual = bl;
        if (optionalFile.dependencies != null) {
            for (OptionalFile optionalFile2 : optionalFile.dependencies) {
                this.enable(optionalFile2, false, biConsumer);
            }
        }
        if (optionalFile.conflict != null) {
            for (OptionalFile optionalFile2 : optionalFile.conflict) {
                this.disable(optionalFile2, biConsumer);
            }
        }
    }

    public void disable(OptionalFile optionalFile, BiConsumer<OptionalFile, Boolean> biConsumer) {
        if (!this.enabled.remove(optionalFile)) {
            return;
        }
        if (biConsumer != null) {
            biConsumer.accept(optionalFile, false);
        }
        for (OptionalFile optionalFile2 : this.all) {
            if (optionalFile2.dependencies == null || !this.contains(optionalFile, optionalFile2.dependencies)) continue;
            this.disable(optionalFile2, biConsumer);
        }
        if (optionalFile.dependencies != null) {
            for (OptionalFile optionalFile3 : optionalFile.dependencies) {
                OptionalView$OptionalFileInstallInfo optionalView$OptionalFileInstallInfo = this.installInfo.get(optionalFile3);
                if (optionalView$OptionalFileInstallInfo == null || optionalView$OptionalFileInstallInfo.isManual) continue;
                this.disable(optionalFile, biConsumer);
            }
        }
    }

    private boolean contains(OptionalFile optionalFile, OptionalFile[] optionalFileArray) {
        for (OptionalFile optionalFile2 : optionalFileArray) {
            if (optionalFile2 != optionalFile) continue;
            return true;
        }
        return false;
    }
}

