/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.request.update;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import pro.gravit.launcher.OmiChftqXz3Adi;
import pro.gravit.launcher.events.request.LauncherRequestEvent;
import pro.gravit.launcher.omiCh5EShyqqIA;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.RequestService;
import pro.gravit.launcher.request.websockets.WebSocketRequest;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;
import pro.gravit.utils.helper.SecurityHelper$DigestAlgorithm;

public final class LauncherRequest
extends Request<LauncherRequestEvent>
implements WebSocketRequest {
    public static final Path BINARY_PATH = IOHelper.getCodeSource(OmiChftqXz3Adi.class);
    public static final Path C_BINARY_PATH = BINARY_PATH.getParent().resolve(IOHelper.getFileName(BINARY_PATH) + ".tmp");
    public static final boolean EXE_BINARY = IOHelper.hasExtension(BINARY_PATH, "exe");
    @omiCh5EShyqqIA
    public final String secureHash;
    @omiCh5EShyqqIA
    public final String secureSalt;
    @omiCh5EShyqqIA
    public byte[] digest;
    @omiCh5EShyqqIA
    public int launcher_type = EXE_BINARY ? 2 : 1;

    public LauncherRequest() {
        Path path = IOHelper.getCodeSource(LauncherRequest.class);
        try {
            this.digest = SecurityHelper.digest(SecurityHelper$DigestAlgorithm.SHA512, path);
        }
        catch (IOException iOException) {
            LogHelper.error(iOException);
        }
        this.secureHash = OmiChftqXz3Adi.OMichZVYUFTw1s().oMiChQr7yRaqk2;
        this.secureSalt = OmiChftqXz3Adi.OMichZVYUFTw1s().OmIChEYMed9pxW;
    }

    public static void update(LauncherRequestEvent launcherRequestEvent) {
        ArrayList<String> arrayList = new ArrayList<String>(8);
        arrayList.add(IOHelper.resolveJavaBin(null).toString());
        if (LogHelper.isDebugEnabled()) {
            arrayList.add(JVMHelper.jvmProperty("launcher.debug", Boolean.toString(LogHelper.isDebugEnabled())));
        }
        arrayList.add("-jar");
        arrayList.add(BINARY_PATH.toString());
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList.toArray(new String[0]));
        processBuilder.inheritIO();
        if (launcherRequestEvent.binary != null) {
            IOHelper.write(BINARY_PATH, launcherRequestEvent.binary);
        } else {
            try {
                Files.deleteIfExists(C_BINARY_PATH);
                URL uRL = new URL(launcherRequestEvent.url);
                URLConnection uRLConnection = uRL.openConnection();
                try (InputStream inputStream = uRLConnection.getInputStream();){
                    IOHelper.transfer(inputStream, C_BINARY_PATH);
                }
                inputStream = IOHelper.newInput(C_BINARY_PATH);
                try {
                    IOHelper.transfer(inputStream, BINARY_PATH);
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                Files.deleteIfExists(C_BINARY_PATH);
            }
            catch (Throwable throwable) {
                LogHelper.error(throwable);
            }
        }
        processBuilder.start();
        JVMHelper.RUNTIME.exit(255);
        throw new AssertionError((Object)"Why Launcher wasn't restarted?!");
    }

    @Override
    public LauncherRequestEvent requestDo(RequestService requestService) {
        LauncherRequestEvent launcherRequestEvent = (LauncherRequestEvent)super.request(requestService);
        if (launcherRequestEvent.needUpdate) {
            LauncherRequest.update(launcherRequestEvent);
        }
        return launcherRequestEvent;
    }

    @Override
    public String getType() {
        return "launcher";
    }
}

