/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.buffer;

import java.util.Arrays;

final class LongPriorityQueue {
    public static final int NO_VALUE = -1;
    private long[] array = new long[9];
    private int size;

    LongPriorityQueue() {
    }

    public void offer(long l) {
        if (l == -1L) {
            throw new IllegalArgumentException("The NO_VALUE (-1) cannot be added to the queue.");
        }
        ++this.size;
        if (this.size == this.array.length) {
            this.array = Arrays.copyOf(this.array, 1 + (this.array.length - 1) * 2);
        }
        this.array[this.size] = l;
        this.lift(this.size);
    }

    public void remove(long l) {
        for (int i = 1; i <= this.size; ++i) {
            if (this.array[i] != l) continue;
            this.array[i] = this.array[this.size--];
            this.lift(i);
            this.sink(i);
            return;
        }
    }

    public long peek() {
        if (this.size == 0) {
            return -1L;
        }
        return this.array[1];
    }

    public long poll() {
        if (this.size == 0) {
            return -1L;
        }
        long l = this.array[1];
        this.array[1] = this.array[this.size];
        this.array[this.size] = 0L;
        --this.size;
        this.sink(1);
        return l;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private void lift(int n) {
        int n2;
        while (n > 1 && this.subord(n2 = n >> 1, n)) {
            this.swap(n, n2);
            n = n2;
        }
    }

    private void sink(int n) {
        int n2;
        while ((n2 = n << 1) <= this.size) {
            if (n2 < this.size && this.subord(n2, n2 + 1)) {
                ++n2;
            }
            if (!this.subord(n, n2)) break;
            this.swap(n, n2);
            n = n2;
        }
    }

    private boolean subord(int n, int n2) {
        return this.array[n] > this.array[n2];
    }

    private void swap(int n, int n2) {
        long l = this.array[n];
        this.array[n] = this.array[n2];
        this.array[n2] = l;
    }
}

