/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.buffer;

import pro.gravit.repackage.io.netty.buffer.PoolArena;
import pro.gravit.repackage.io.netty.buffer.PoolChunk;
import pro.gravit.repackage.io.netty.buffer.PoolSubpageMetric;

final class PoolSubpage<T>
implements PoolSubpageMetric {
    final PoolChunk<T> chunk;
    private final int pageShifts;
    private final int runOffset;
    private final int runSize;
    private final long[] bitmap;
    PoolSubpage<T> prev;
    PoolSubpage<T> next;
    boolean doNotDestroy;
    int elemSize;
    private int maxNumElems;
    private int bitmapLength;
    private int nextAvail;
    private int numAvail;

    PoolSubpage() {
        this.chunk = null;
        this.pageShifts = -1;
        this.runOffset = -1;
        this.elemSize = -1;
        this.runSize = -1;
        this.bitmap = null;
    }

    PoolSubpage(PoolSubpage<T> poolSubpage, PoolChunk<T> poolChunk, int n, int n2, int n3, int n4) {
        this.chunk = poolChunk;
        this.pageShifts = n;
        this.runOffset = n2;
        this.runSize = n3;
        this.elemSize = n4;
        this.bitmap = new long[n3 >>> 10];
        this.doNotDestroy = true;
        if (n4 != 0) {
            this.maxNumElems = this.numAvail = n3 / n4;
            this.nextAvail = 0;
            this.bitmapLength = this.maxNumElems >>> 6;
            if ((this.maxNumElems & 0x3F) != 0) {
                ++this.bitmapLength;
            }
            for (int i = 0; i < this.bitmapLength; ++i) {
                this.bitmap[i] = 0L;
            }
        }
        this.addToPool(poolSubpage);
    }

    long allocate() {
        if (this.numAvail == 0 || !this.doNotDestroy) {
            return -1L;
        }
        int n = this.getNextAvail();
        int n2 = n >>> 6;
        int n3 = n & 0x3F;
        assert ((this.bitmap[n2] >>> n3 & 1L) == 0L);
        int n4 = n2;
        this.bitmap[n4] = this.bitmap[n4] | 1L << n3;
        if (--this.numAvail == 0) {
            this.removeFromPool();
        }
        return this.toHandle(n);
    }

    boolean free(PoolSubpage<T> poolSubpage, int n) {
        if (this.elemSize == 0) {
            return true;
        }
        int n2 = n >>> 6;
        int n3 = n & 0x3F;
        assert ((this.bitmap[n2] >>> n3 & 1L) != 0L);
        int n4 = n2;
        this.bitmap[n4] = this.bitmap[n4] ^ 1L << n3;
        this.setNextAvail(n);
        if (this.numAvail++ == 0) {
            this.addToPool(poolSubpage);
            if (this.maxNumElems > 1) {
                return true;
            }
        }
        if (this.numAvail != this.maxNumElems) {
            return true;
        }
        if (this.prev == this.next) {
            return true;
        }
        this.doNotDestroy = false;
        this.removeFromPool();
        return false;
    }

    private void addToPool(PoolSubpage<T> poolSubpage) {
        assert (this.prev == null && this.next == null);
        this.prev = poolSubpage;
        this.next = poolSubpage.next;
        this.next.prev = this;
        poolSubpage.next = this;
    }

    private void removeFromPool() {
        assert (this.prev != null && this.next != null);
        this.prev.next = this.next;
        this.next.prev = this.prev;
        this.next = null;
        this.prev = null;
    }

    private void setNextAvail(int n) {
        this.nextAvail = n;
    }

    private int getNextAvail() {
        int n = this.nextAvail;
        if (n >= 0) {
            this.nextAvail = -1;
            return n;
        }
        return this.findNextAvail();
    }

    private int findNextAvail() {
        long[] lArray = this.bitmap;
        int n = this.bitmapLength;
        for (int i = 0; i < n; ++i) {
            long l = lArray[i];
            if ((l ^ 0xFFFFFFFFFFFFFFFFL) == 0L) continue;
            return this.findNextAvail0(i, l);
        }
        return -1;
    }

    private int findNextAvail0(int n, long l) {
        int n2 = this.maxNumElems;
        int n3 = n << 6;
        for (int i = 0; i < 64; ++i) {
            if ((l & 1L) == 0L) {
                int n4 = n3 | i;
                if (n4 >= n2) break;
                return n4;
            }
            l >>>= 1;
        }
        return -1;
    }

    private long toHandle(int n) {
        int n2 = this.runSize >> this.pageShifts;
        return (long)this.runOffset << 49 | (long)n2 << 34 | 0x200000000L | 0x100000000L | (long)n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int n;
        int n2;
        int n3;
        boolean bl;
        if (this.chunk == null) {
            bl = true;
            n3 = 0;
            n2 = 0;
            n = -1;
        } else {
            PoolArena poolArena = this.chunk.arena;
            synchronized (poolArena) {
                if (!this.doNotDestroy) {
                    bl = false;
                    n = -1;
                    n2 = -1;
                    n3 = -1;
                } else {
                    bl = true;
                    n3 = this.maxNumElems;
                    n2 = this.numAvail;
                    n = this.elemSize;
                }
            }
        }
        if (!bl) {
            return "(" + this.runOffset + ": not in use)";
        }
        return "(" + this.runOffset + ": " + (n3 - n2) + '/' + n3 + ", offset: " + this.runOffset + ", length: " + this.runSize + ", elemSize: " + n + ')';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int maxNumElements() {
        if (this.chunk == null) {
            return 0;
        }
        PoolArena poolArena = this.chunk.arena;
        synchronized (poolArena) {
            return this.maxNumElems;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int numAvailable() {
        if (this.chunk == null) {
            return 0;
        }
        PoolArena poolArena = this.chunk.arena;
        synchronized (poolArena) {
            return this.numAvail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int elementSize() {
        if (this.chunk == null) {
            return -1;
        }
        PoolArena poolArena = this.chunk.arena;
        synchronized (poolArena) {
            return this.elemSize;
        }
    }

    @Override
    public int pageSize() {
        return 1 << this.pageShifts;
    }

    void destroy() {
        if (this.chunk != null) {
            this.chunk.destroy();
        }
    }
}

