/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.buffer;

import pro.gravit.repackage.io.netty.buffer.PoolThreadCache;
import pro.gravit.repackage.io.netty.buffer.SizeClassesMetric;

abstract class SizeClasses
implements SizeClassesMetric {
    static final int LOG2_QUANTUM = 4;
    private static final int LOG2_SIZE_CLASS_GROUP = 2;
    private static final int LOG2_MAX_LOOKUP_SIZE = 12;
    private static final int INDEX_IDX = 0;
    private static final int LOG2GROUP_IDX = 1;
    private static final int LOG2DELTA_IDX = 2;
    private static final int NDELTA_IDX = 3;
    private static final int PAGESIZE_IDX = 4;
    private static final int SUBPAGE_IDX = 5;
    private static final int LOG2_DELTA_LOOKUP_IDX = 6;
    private static final byte no = 0;
    private static final byte yes = 1;
    protected final int pageSize;
    protected final int pageShifts;
    protected final int chunkSize;
    protected final int directMemoryCacheAlignment;
    final int nSizes;
    int nSubpages;
    int nPSizes;
    int smallMaxSizeIdx;
    private int lookupMaxSize;
    private final short[][] sizeClasses;
    private final int[] pageIdx2sizeTab;
    private final int[] sizeIdx2sizeTab;
    private final int[] size2idxTab;

    protected SizeClasses(int n, int n2, int n3, int n4) {
        this.pageSize = n;
        this.pageShifts = n2;
        this.chunkSize = n3;
        this.directMemoryCacheAlignment = n4;
        int n5 = PoolThreadCache.log2(n3) + 1 - 4;
        this.sizeClasses = new short[n5 << 2][7];
        this.nSizes = this.sizeClasses();
        this.sizeIdx2sizeTab = new int[this.nSizes];
        this.pageIdx2sizeTab = new int[this.nPSizes];
        this.idx2SizeTab(this.sizeIdx2sizeTab, this.pageIdx2sizeTab);
        this.size2idxTab = new int[this.lookupMaxSize >> 4];
        this.size2idxTab(this.size2idxTab);
    }

    private int sizeClasses() {
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        int n4 = 4;
        int n5 = 4;
        int n6 = 4;
        int n7 = 0;
        while (n7 < n6) {
            n3 = this.sizeClass(n2++, n4, n5, n7++);
        }
        n4 += 2;
        while (n3 < this.chunkSize) {
            n7 = 1;
            while (n7 <= n6 && n3 < this.chunkSize) {
                n = n3 = this.sizeClass(n2++, n4, n5, n7++);
            }
            ++n4;
            ++n5;
        }
        assert (this.chunkSize == n);
        return n2;
    }

    private int sizeClass(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        short s = n3 >= this.pageShifts ? (short)1 : ((n7 = (1 << n2) + (1 << n3) * n4) == n7 / (n6 = 1 << this.pageShifts) * n6 ? (short)1 : 0);
        n6 = n4 == 0 ? 0 : PoolThreadCache.log2(n4);
        n7 = 1 << n6 < n4 ? 1 : 0;
        int n8 = n5 = n3 + n6 == n2 ? n2 + 1 : n2;
        if (n5 == n2) {
            n7 = 1;
        }
        short s2 = n5 < this.pageShifts + 2 ? (short)1 : 0;
        int n9 = n5 < 12 || n5 == 12 && n7 == 0 ? n3 : 0;
        short[] sArray = new short[]{(short)n, (short)n2, (short)n3, (short)n4, s, s2, (short)n9};
        this.sizeClasses[n] = sArray;
        int n10 = (1 << n2) + (n4 << n3);
        if (sArray[4] == 1) {
            ++this.nPSizes;
        }
        if (sArray[5] == 1) {
            ++this.nSubpages;
            this.smallMaxSizeIdx = n;
        }
        if (sArray[6] != 0) {
            this.lookupMaxSize = n10;
        }
        return n10;
    }

    private void idx2SizeTab(int[] nArray, int[] nArray2) {
        int n = 0;
        for (int i = 0; i < this.nSizes; ++i) {
            int n2;
            short[] sArray = this.sizeClasses[i];
            short s = sArray[1];
            short s2 = sArray[2];
            short s3 = sArray[3];
            nArray[i] = n2 = (1 << s) + (s3 << s2);
            if (sArray[4] != 1) continue;
            nArray2[n++] = n2;
        }
    }

    private void size2idxTab(int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n2 <= this.lookupMaxSize) {
            short s = this.sizeClasses[n3][2];
            int n4 = 1 << s - 4;
            while (n2 <= this.lookupMaxSize && n4-- > 0) {
                nArray[n++] = n3;
                n2 = n + 1 << 4;
            }
            ++n3;
        }
    }

    @Override
    public int sizeIdx2size(int n) {
        return this.sizeIdx2sizeTab[n];
    }

    @Override
    public int sizeIdx2sizeCompute(int n) {
        int n2 = n >> 2;
        int n3 = n & 3;
        int n4 = n2 == 0 ? 0 : 32 << n2;
        int n5 = n2 == 0 ? 1 : n2;
        int n6 = n5 + 4 - 1;
        int n7 = n3 + 1 << n6;
        return n4 + n7;
    }

    @Override
    public long pageIdx2size(int n) {
        return this.pageIdx2sizeTab[n];
    }

    @Override
    public long pageIdx2sizeCompute(int n) {
        int n2 = n >> 2;
        int n3 = n & 3;
        long l = n2 == 0 ? 0L : 1L << this.pageShifts + 2 - 1 << n2;
        int n4 = n2 == 0 ? 1 : n2;
        int n5 = n4 + this.pageShifts - 1;
        int n6 = n3 + 1 << n5;
        return l + (long)n6;
    }

    @Override
    public int size2SizeIdx(int n) {
        if (n == 0) {
            return 0;
        }
        if (n > this.chunkSize) {
            return this.nSizes;
        }
        if (this.directMemoryCacheAlignment > 0) {
            n = this.alignSize(n);
        }
        if (n <= this.lookupMaxSize) {
            return this.size2idxTab[n - 1 >> 4];
        }
        int n2 = PoolThreadCache.log2((n << 1) - 1);
        int n3 = n2 < 7 ? 0 : n2 - 6;
        int n4 = n3 << 2;
        int n5 = n2 < 7 ? 4 : n2 - 2 - 1;
        int n6 = -1 << n5;
        int n7 = (n - 1 & n6) >> n5 & 3;
        return n4 + n7;
    }

    @Override
    public int pages2pageIdx(int n) {
        return this.pages2pageIdxCompute(n, false);
    }

    @Override
    public int pages2pageIdxFloor(int n) {
        return this.pages2pageIdxCompute(n, true);
    }

    private int pages2pageIdxCompute(int n, boolean bl) {
        int n2 = n << this.pageShifts;
        if (n2 > this.chunkSize) {
            return this.nPSizes;
        }
        int n3 = PoolThreadCache.log2((n2 << 1) - 1);
        int n4 = n3 < 2 + this.pageShifts ? 0 : n3 - (2 + this.pageShifts);
        int n5 = n4 << 2;
        int n6 = n3 < 2 + this.pageShifts + 1 ? this.pageShifts : n3 - 2 - 1;
        int n7 = -1 << n6;
        int n8 = (n2 - 1 & n7) >> n6 & 3;
        int n9 = n5 + n8;
        if (bl && this.pageIdx2sizeTab[n9] > n << this.pageShifts) {
            --n9;
        }
        return n9;
    }

    private int alignSize(int n) {
        int n2 = n & this.directMemoryCacheAlignment - 1;
        return n2 == 0 ? n : n + this.directMemoryCacheAlignment - n2;
    }

    @Override
    public int normalizeSize(int n) {
        if (n == 0) {
            return this.sizeIdx2sizeTab[0];
        }
        if (this.directMemoryCacheAlignment > 0) {
            n = this.alignSize(n);
        }
        if (n <= this.lookupMaxSize) {
            int n2 = this.sizeIdx2sizeTab[this.size2idxTab[n - 1 >> 4]];
            assert (n2 == SizeClasses.normalizeSizeCompute(n));
            return n2;
        }
        return SizeClasses.normalizeSizeCompute(n);
    }

    private static int normalizeSizeCompute(int n) {
        int n2 = PoolThreadCache.log2((n << 1) - 1);
        int n3 = n2 < 7 ? 4 : n2 - 2 - 1;
        int n4 = 1 << n3;
        int n5 = n4 - 1;
        return n + n5 & ~n5;
    }
}

