/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel;

import java.net.SocketAddress;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.channel.AbstractChannel$AbstractUnsafe;
import pro.gravit.repackage.io.netty.channel.AbstractChannel$CloseFuture;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.Channel$Unsafe;
import pro.gravit.repackage.io.netty.channel.ChannelConfig;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.ChannelId;
import pro.gravit.repackage.io.netty.channel.ChannelOption;
import pro.gravit.repackage.io.netty.channel.ChannelOutboundBuffer;
import pro.gravit.repackage.io.netty.channel.ChannelPipeline;
import pro.gravit.repackage.io.netty.channel.ChannelProgressivePromise;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.channel.DefaultChannelConfig;
import pro.gravit.repackage.io.netty.channel.DefaultChannelId;
import pro.gravit.repackage.io.netty.channel.DefaultChannelPipeline;
import pro.gravit.repackage.io.netty.channel.DefaultFileRegion;
import pro.gravit.repackage.io.netty.channel.EventLoop;
import pro.gravit.repackage.io.netty.channel.VoidChannelPromise;
import pro.gravit.repackage.io.netty.util.DefaultAttributeMap;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public abstract class AbstractChannel
extends DefaultAttributeMap
implements Channel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractChannel.class);
    private final Channel parent;
    private final ChannelId id;
    private final Channel$Unsafe unsafe;
    private final DefaultChannelPipeline pipeline;
    private final VoidChannelPromise unsafeVoidPromise = new VoidChannelPromise(this, false);
    private final AbstractChannel$CloseFuture closeFuture = new AbstractChannel$CloseFuture(this);
    private volatile SocketAddress localAddress;
    private volatile SocketAddress remoteAddress;
    private volatile EventLoop eventLoop;
    private volatile boolean registered;
    private boolean closeInitiated;
    private Throwable initialCloseCause;
    private boolean strValActive;
    private String strVal;

    protected AbstractChannel(Channel channel) {
        this.parent = channel;
        this.id = this.newId();
        this.unsafe = this.newUnsafe();
        this.pipeline = this.newChannelPipeline();
    }

    protected AbstractChannel(Channel channel, ChannelId channelId) {
        this.parent = channel;
        this.id = channelId;
        this.unsafe = this.newUnsafe();
        this.pipeline = this.newChannelPipeline();
    }

    protected final int maxMessagesPerWrite() {
        ChannelConfig channelConfig = this.config();
        if (channelConfig instanceof DefaultChannelConfig) {
            return ((DefaultChannelConfig)channelConfig).getMaxMessagesPerWrite();
        }
        Integer n = channelConfig.getOption(ChannelOption.MAX_MESSAGES_PER_WRITE);
        if (n == null) {
            return Integer.MAX_VALUE;
        }
        return n;
    }

    @Override
    public final ChannelId id() {
        return this.id;
    }

    protected ChannelId newId() {
        return DefaultChannelId.newInstance();
    }

    protected DefaultChannelPipeline newChannelPipeline() {
        return new DefaultChannelPipeline(this);
    }

    @Override
    public boolean isWritable() {
        ChannelOutboundBuffer channelOutboundBuffer = this.unsafe.outboundBuffer();
        return channelOutboundBuffer != null && channelOutboundBuffer.isWritable();
    }

    @Override
    public long bytesBeforeUnwritable() {
        ChannelOutboundBuffer channelOutboundBuffer = this.unsafe.outboundBuffer();
        return channelOutboundBuffer != null ? channelOutboundBuffer.bytesBeforeUnwritable() : 0L;
    }

    @Override
    public long bytesBeforeWritable() {
        ChannelOutboundBuffer channelOutboundBuffer = this.unsafe.outboundBuffer();
        return channelOutboundBuffer != null ? channelOutboundBuffer.bytesBeforeWritable() : Long.MAX_VALUE;
    }

    @Override
    public Channel parent() {
        return this.parent;
    }

    @Override
    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.config().getAllocator();
    }

    @Override
    public EventLoop eventLoop() {
        EventLoop eventLoop = this.eventLoop;
        if (eventLoop == null) {
            throw new IllegalStateException("channel not registered to an event loop");
        }
        return eventLoop;
    }

    @Override
    public SocketAddress localAddress() {
        SocketAddress socketAddress = this.localAddress;
        if (socketAddress == null) {
            try {
                this.localAddress = socketAddress = this.unsafe().localAddress();
            }
            catch (Error error) {
                throw error;
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return socketAddress;
    }

    @Deprecated
    protected void invalidateLocalAddress() {
        this.localAddress = null;
    }

    @Override
    public SocketAddress remoteAddress() {
        SocketAddress socketAddress = this.remoteAddress;
        if (socketAddress == null) {
            try {
                this.remoteAddress = socketAddress = this.unsafe().remoteAddress();
            }
            catch (Error error) {
                throw error;
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return socketAddress;
    }

    @Deprecated
    protected void invalidateRemoteAddress() {
        this.remoteAddress = null;
    }

    @Override
    public boolean isRegistered() {
        return this.registered;
    }

    @Override
    public ChannelFuture bind(SocketAddress socketAddress) {
        return this.pipeline.bind(socketAddress);
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress) {
        return this.pipeline.connect(socketAddress);
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        return this.pipeline.connect(socketAddress, socketAddress2);
    }

    @Override
    public ChannelFuture disconnect() {
        return this.pipeline.disconnect();
    }

    @Override
    public ChannelFuture close() {
        return this.pipeline.close();
    }

    @Override
    public ChannelFuture deregister() {
        return this.pipeline.deregister();
    }

    @Override
    public Channel flush() {
        this.pipeline.flush();
        return this;
    }

    @Override
    public ChannelFuture bind(SocketAddress socketAddress, ChannelPromise channelPromise) {
        return this.pipeline.bind(socketAddress, channelPromise);
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, ChannelPromise channelPromise) {
        return this.pipeline.connect(socketAddress, channelPromise);
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        return this.pipeline.connect(socketAddress, socketAddress2, channelPromise);
    }

    @Override
    public ChannelFuture disconnect(ChannelPromise channelPromise) {
        return this.pipeline.disconnect(channelPromise);
    }

    @Override
    public ChannelFuture close(ChannelPromise channelPromise) {
        return this.pipeline.close(channelPromise);
    }

    @Override
    public ChannelFuture deregister(ChannelPromise channelPromise) {
        return this.pipeline.deregister(channelPromise);
    }

    @Override
    public Channel read() {
        this.pipeline.read();
        return this;
    }

    @Override
    public ChannelFuture write(Object object) {
        return this.pipeline.write(object);
    }

    @Override
    public ChannelFuture write(Object object, ChannelPromise channelPromise) {
        return this.pipeline.write(object, channelPromise);
    }

    @Override
    public ChannelFuture writeAndFlush(Object object) {
        return this.pipeline.writeAndFlush(object);
    }

    @Override
    public ChannelFuture writeAndFlush(Object object, ChannelPromise channelPromise) {
        return this.pipeline.writeAndFlush(object, channelPromise);
    }

    @Override
    public ChannelPromise newPromise() {
        return this.pipeline.newPromise();
    }

    @Override
    public ChannelProgressivePromise newProgressivePromise() {
        return this.pipeline.newProgressivePromise();
    }

    @Override
    public ChannelFuture newSucceededFuture() {
        return this.pipeline.newSucceededFuture();
    }

    @Override
    public ChannelFuture newFailedFuture(Throwable throwable) {
        return this.pipeline.newFailedFuture(throwable);
    }

    @Override
    public ChannelFuture closeFuture() {
        return this.closeFuture;
    }

    @Override
    public Channel$Unsafe unsafe() {
        return this.unsafe;
    }

    protected abstract AbstractChannel$AbstractUnsafe newUnsafe();

    public final int hashCode() {
        return this.id.hashCode();
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    @Override
    public final int compareTo(Channel channel) {
        if (this == channel) {
            return 0;
        }
        return this.id().compareTo(channel.id());
    }

    public String toString() {
        boolean bl = this.isActive();
        if (this.strValActive == bl && this.strVal != null) {
            return this.strVal;
        }
        SocketAddress socketAddress = this.remoteAddress();
        SocketAddress socketAddress2 = this.localAddress();
        if (socketAddress != null) {
            StringBuilder stringBuilder = new StringBuilder(96).append("[id: 0x").append(this.id.asShortText()).append(", L:").append(socketAddress2).append(bl ? " - " : " ! ").append("R:").append(socketAddress).append(']');
            this.strVal = stringBuilder.toString();
        } else if (socketAddress2 != null) {
            StringBuilder stringBuilder = new StringBuilder(64).append("[id: 0x").append(this.id.asShortText()).append(", L:").append(socketAddress2).append(']');
            this.strVal = stringBuilder.toString();
        } else {
            StringBuilder stringBuilder = new StringBuilder(16).append("[id: 0x").append(this.id.asShortText()).append(']');
            this.strVal = stringBuilder.toString();
        }
        this.strValActive = bl;
        return this.strVal;
    }

    @Override
    public final ChannelPromise voidPromise() {
        return this.pipeline.voidPromise();
    }

    protected abstract boolean isCompatible(EventLoop var1);

    protected abstract SocketAddress localAddress0();

    protected abstract SocketAddress remoteAddress0();

    protected void doRegister() {
    }

    protected abstract void doBind(SocketAddress var1);

    protected abstract void doDisconnect();

    protected abstract void doClose();

    protected void doShutdownOutput() {
        this.doClose();
    }

    protected void doDeregister() {
    }

    protected abstract void doBeginRead();

    protected abstract void doWrite(ChannelOutboundBuffer var1);

    protected Object filterOutboundMessage(Object object) {
        return object;
    }

    protected void validateFileRegion(DefaultFileRegion defaultFileRegion, long l) {
        DefaultFileRegion.validate(defaultFileRegion, l);
    }

    static /* synthetic */ boolean access$000(AbstractChannel abstractChannel) {
        return abstractChannel.registered;
    }

    static /* synthetic */ EventLoop access$100(AbstractChannel abstractChannel) {
        return abstractChannel.eventLoop;
    }

    static /* synthetic */ EventLoop access$102(AbstractChannel abstractChannel, EventLoop eventLoop) {
        abstractChannel.eventLoop = eventLoop;
        return abstractChannel.eventLoop;
    }

    static /* synthetic */ InternalLogger access$300() {
        return logger;
    }

    static /* synthetic */ AbstractChannel$CloseFuture access$400(AbstractChannel abstractChannel) {
        return abstractChannel.closeFuture;
    }

    static /* synthetic */ boolean access$002(AbstractChannel abstractChannel, boolean bl) {
        abstractChannel.registered = bl;
        return abstractChannel.registered;
    }

    static /* synthetic */ DefaultChannelPipeline access$500(AbstractChannel abstractChannel) {
        return abstractChannel.pipeline;
    }

    static /* synthetic */ SocketAddress access$602(AbstractChannel abstractChannel, SocketAddress socketAddress) {
        abstractChannel.remoteAddress = socketAddress;
        return abstractChannel.remoteAddress;
    }

    static /* synthetic */ SocketAddress access$702(AbstractChannel abstractChannel, SocketAddress socketAddress) {
        abstractChannel.localAddress = socketAddress;
        return abstractChannel.localAddress;
    }

    static /* synthetic */ boolean access$900(AbstractChannel abstractChannel) {
        return abstractChannel.closeInitiated;
    }

    static /* synthetic */ boolean access$902(AbstractChannel abstractChannel, boolean bl) {
        abstractChannel.closeInitiated = bl;
        return abstractChannel.closeInitiated;
    }

    static /* synthetic */ Throwable access$1300(AbstractChannel abstractChannel) {
        return abstractChannel.initialCloseCause;
    }

    static /* synthetic */ Throwable access$1302(AbstractChannel abstractChannel, Throwable throwable) {
        abstractChannel.initialCloseCause = throwable;
        return abstractChannel.initialCloseCause;
    }

    static /* synthetic */ VoidChannelPromise access$1400(AbstractChannel abstractChannel) {
        return abstractChannel.unsafeVoidPromise;
    }
}

