/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel;

import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufHolder;
import pro.gravit.repackage.io.netty.channel.AbstractChannel;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelOutboundBuffer$1;
import pro.gravit.repackage.io.netty.channel.ChannelOutboundBuffer$2;
import pro.gravit.repackage.io.netty.channel.ChannelOutboundBuffer$3;
import pro.gravit.repackage.io.netty.channel.ChannelOutboundBuffer$Entry;
import pro.gravit.repackage.io.netty.channel.ChannelOutboundBuffer$MessageProcessor;
import pro.gravit.repackage.io.netty.channel.ChannelPipeline;
import pro.gravit.repackage.io.netty.channel.ChannelProgressivePromise;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.channel.FileRegion;
import pro.gravit.repackage.io.netty.channel.VoidChannelPromise;
import pro.gravit.repackage.io.netty.util.ReferenceCountUtil;
import pro.gravit.repackage.io.netty.util.concurrent.FastThreadLocal;
import pro.gravit.repackage.io.netty.util.internal.InternalThreadLocalMap;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.PromiseNotificationUtil;
import pro.gravit.repackage.io.netty.util.internal.SystemPropertyUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public final class ChannelOutboundBuffer {
    static final int CHANNEL_OUTBOUND_BUFFER_ENTRY_OVERHEAD = SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.transport.outboundBufferEntrySizeOverhead", 96);
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelOutboundBuffer.class);
    private static final FastThreadLocal<ByteBuffer[]> NIO_BUFFERS = new ChannelOutboundBuffer$1();
    private final Channel channel;
    private ChannelOutboundBuffer$Entry flushedEntry;
    private ChannelOutboundBuffer$Entry unflushedEntry;
    private ChannelOutboundBuffer$Entry tailEntry;
    private int flushed;
    private int nioBufferCount;
    private long nioBufferSize;
    private boolean inFail;
    private static final AtomicLongFieldUpdater<ChannelOutboundBuffer> TOTAL_PENDING_SIZE_UPDATER = AtomicLongFieldUpdater.newUpdater(ChannelOutboundBuffer.class, "totalPendingSize");
    private volatile long totalPendingSize;
    private static final AtomicIntegerFieldUpdater<ChannelOutboundBuffer> UNWRITABLE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ChannelOutboundBuffer.class, "unwritable");
    private volatile int unwritable;
    private volatile Runnable fireChannelWritabilityChangedTask;

    ChannelOutboundBuffer(AbstractChannel abstractChannel) {
        this.channel = abstractChannel;
    }

    public void addMessage(Object object, int n, ChannelPromise channelPromise) {
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = ChannelOutboundBuffer$Entry.newInstance(object, n, ChannelOutboundBuffer.total(object), channelPromise);
        if (this.tailEntry == null) {
            this.flushedEntry = null;
        } else {
            ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry2 = this.tailEntry;
            channelOutboundBuffer$Entry2.next = channelOutboundBuffer$Entry;
        }
        this.tailEntry = channelOutboundBuffer$Entry;
        if (this.unflushedEntry == null) {
            this.unflushedEntry = channelOutboundBuffer$Entry;
        }
        this.incrementPendingOutboundBytes(channelOutboundBuffer$Entry.pendingSize, false);
    }

    public void addFlush() {
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.unflushedEntry;
        if (channelOutboundBuffer$Entry != null) {
            if (this.flushedEntry == null) {
                this.flushedEntry = channelOutboundBuffer$Entry;
            }
            do {
                ++this.flushed;
                if (channelOutboundBuffer$Entry.promise.setUncancellable()) continue;
                int n = channelOutboundBuffer$Entry.cancel();
                this.decrementPendingOutboundBytes(n, false, true);
            } while ((channelOutboundBuffer$Entry = channelOutboundBuffer$Entry.next) != null);
            this.unflushedEntry = null;
        }
    }

    void incrementPendingOutboundBytes(long l) {
        this.incrementPendingOutboundBytes(l, true);
    }

    private void incrementPendingOutboundBytes(long l, boolean bl) {
        if (l == 0L) {
            return;
        }
        long l2 = TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, l);
        if (l2 > (long)this.channel.config().getWriteBufferHighWaterMark()) {
            this.setUnwritable(bl);
        }
    }

    void decrementPendingOutboundBytes(long l) {
        this.decrementPendingOutboundBytes(l, true, true);
    }

    private void decrementPendingOutboundBytes(long l, boolean bl, boolean bl2) {
        if (l == 0L) {
            return;
        }
        long l2 = TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, -l);
        if (bl2 && l2 < (long)this.channel.config().getWriteBufferLowWaterMark()) {
            this.setWritable(bl);
        }
    }

    private static long total(Object object) {
        if (object instanceof ByteBuf) {
            return ((ByteBuf)object).readableBytes();
        }
        if (object instanceof FileRegion) {
            return ((FileRegion)object).count();
        }
        if (object instanceof ByteBufHolder) {
            return ((ByteBufHolder)object).content().readableBytes();
        }
        return -1L;
    }

    public Object current() {
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.flushedEntry;
        if (channelOutboundBuffer$Entry == null) {
            return null;
        }
        return channelOutboundBuffer$Entry.msg;
    }

    public long currentProgress() {
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.flushedEntry;
        if (channelOutboundBuffer$Entry == null) {
            return 0L;
        }
        return channelOutboundBuffer$Entry.progress;
    }

    public void progress(long l) {
        long l2;
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.flushedEntry;
        assert (channelOutboundBuffer$Entry != null);
        ChannelPromise channelPromise = channelOutboundBuffer$Entry.promise;
        channelOutboundBuffer$Entry.progress = l2 = channelOutboundBuffer$Entry.progress + l;
        if (channelPromise instanceof ChannelProgressivePromise) {
            ((ChannelProgressivePromise)channelPromise).tryProgress(l2, channelOutboundBuffer$Entry.total);
        }
    }

    public boolean remove() {
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.flushedEntry;
        if (channelOutboundBuffer$Entry == null) {
            this.clearNioBuffers();
            return false;
        }
        Object object = channelOutboundBuffer$Entry.msg;
        ChannelPromise channelPromise = channelOutboundBuffer$Entry.promise;
        int n = channelOutboundBuffer$Entry.pendingSize;
        this.removeEntry(channelOutboundBuffer$Entry);
        if (!channelOutboundBuffer$Entry.cancelled) {
            ReferenceCountUtil.safeRelease(object);
            ChannelOutboundBuffer.safeSuccess(channelPromise);
            this.decrementPendingOutboundBytes(n, false, true);
        }
        channelOutboundBuffer$Entry.recycle();
        return true;
    }

    public boolean remove(Throwable throwable) {
        return this.remove0(throwable, true);
    }

    private boolean remove0(Throwable throwable, boolean bl) {
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.flushedEntry;
        if (channelOutboundBuffer$Entry == null) {
            this.clearNioBuffers();
            return false;
        }
        Object object = channelOutboundBuffer$Entry.msg;
        ChannelPromise channelPromise = channelOutboundBuffer$Entry.promise;
        int n = channelOutboundBuffer$Entry.pendingSize;
        this.removeEntry(channelOutboundBuffer$Entry);
        if (!channelOutboundBuffer$Entry.cancelled) {
            ReferenceCountUtil.safeRelease(object);
            ChannelOutboundBuffer.safeFail(channelPromise, throwable);
            this.decrementPendingOutboundBytes(n, false, bl);
        }
        channelOutboundBuffer$Entry.recycle();
        return true;
    }

    private void removeEntry(ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry) {
        if (--this.flushed == 0) {
            this.flushedEntry = null;
            if (channelOutboundBuffer$Entry == this.tailEntry) {
                this.tailEntry = null;
                this.unflushedEntry = null;
            }
        } else {
            this.flushedEntry = channelOutboundBuffer$Entry.next;
        }
    }

    public void removeBytes(long l) {
        block5: {
            int n;
            ByteBuf byteBuf;
            while (true) {
                Object object;
                if (!((object = this.current()) instanceof ByteBuf)) {
                    assert (l == 0L);
                    break block5;
                }
                byteBuf = (ByteBuf)object;
                n = byteBuf.readerIndex();
                int n2 = byteBuf.writerIndex() - n;
                if ((long)n2 > l) break;
                if (l != 0L) {
                    this.progress(n2);
                    l -= (long)n2;
                }
                this.remove();
            }
            if (l != 0L) {
                byteBuf.readerIndex(n + (int)l);
                this.progress(l);
            }
        }
        this.clearNioBuffers();
    }

    private void clearNioBuffers() {
        int n = this.nioBufferCount;
        if (n > 0) {
            this.nioBufferCount = 0;
            Arrays.fill(NIO_BUFFERS.get(), 0, n, null);
        }
    }

    public ByteBuffer[] nioBuffers() {
        return this.nioBuffers(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public ByteBuffer[] nioBuffers(int n, long l) {
        assert (n > 0);
        assert (l > 0L);
        long l2 = 0L;
        int n2 = 0;
        InternalThreadLocalMap internalThreadLocalMap = InternalThreadLocalMap.get();
        ByteBuffer[] byteBufferArray = NIO_BUFFERS.get(internalThreadLocalMap);
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.flushedEntry;
        while (this.isFlushedEntry(channelOutboundBuffer$Entry) && channelOutboundBuffer$Entry.msg instanceof ByteBuf) {
            if (!channelOutboundBuffer$Entry.cancelled) {
                ByteBuf byteBuf = (ByteBuf)channelOutboundBuffer$Entry.msg;
                int n3 = byteBuf.readerIndex();
                int n4 = byteBuf.writerIndex() - n3;
                if (n4 > 0) {
                    int n5;
                    if (l - (long)n4 < l2 && n2 != 0) break;
                    l2 += (long)n4;
                    int n6 = channelOutboundBuffer$Entry.count;
                    if (n6 == -1) {
                        channelOutboundBuffer$Entry.count = n6 = byteBuf.nioBufferCount();
                    }
                    if ((n5 = Math.min(n, n2 + n6)) > byteBufferArray.length) {
                        byteBufferArray = ChannelOutboundBuffer.expandNioBufferArray(byteBufferArray, n5, n2);
                        NIO_BUFFERS.set(internalThreadLocalMap, byteBufferArray);
                    }
                    if (n6 == 1) {
                        ByteBuffer byteBuffer = channelOutboundBuffer$Entry.buf;
                        if (byteBuffer == null) {
                            channelOutboundBuffer$Entry.buf = byteBuffer = byteBuf.internalNioBuffer(n3, n4);
                        }
                        byteBufferArray[n2++] = byteBuffer;
                    } else {
                        n2 = ChannelOutboundBuffer.nioBuffers(channelOutboundBuffer$Entry, byteBuf, byteBufferArray, n2, n);
                    }
                    if (n2 >= n) break;
                }
            }
            channelOutboundBuffer$Entry = channelOutboundBuffer$Entry.next;
        }
        this.nioBufferCount = n2;
        this.nioBufferSize = l2;
        return byteBufferArray;
    }

    private static int nioBuffers(ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry, ByteBuf byteBuf, ByteBuffer[] byteBufferArray, int n, int n2) {
        ByteBuffer byteBuffer;
        ByteBuffer[] byteBufferArray2 = channelOutboundBuffer$Entry.bufs;
        if (byteBufferArray2 == null) {
            channelOutboundBuffer$Entry.bufs = byteBufferArray2 = byteBuf.nioBuffers();
        }
        for (int i = 0; i < byteBufferArray2.length && n < n2 && (byteBuffer = byteBufferArray2[i]) != null; ++i) {
            if (!byteBuffer.hasRemaining()) continue;
            byteBufferArray[n++] = byteBuffer;
        }
        return n;
    }

    private static ByteBuffer[] expandNioBufferArray(ByteBuffer[] byteBufferArray, int n, int n2) {
        int n3 = byteBufferArray.length;
        do {
            if ((n3 <<= 1) >= 0) continue;
            throw new IllegalStateException();
        } while (n > n3);
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n3];
        System.arraycopy(byteBufferArray, 0, byteBufferArray2, 0, n2);
        return byteBufferArray2;
    }

    public int nioBufferCount() {
        return this.nioBufferCount;
    }

    public long nioBufferSize() {
        return this.nioBufferSize;
    }

    public boolean isWritable() {
        return this.unwritable == 0;
    }

    public boolean getUserDefinedWritability(int n) {
        return (this.unwritable & ChannelOutboundBuffer.writabilityMask(n)) == 0;
    }

    public void setUserDefinedWritability(int n, boolean bl) {
        if (bl) {
            this.setUserDefinedWritability(n);
        } else {
            this.clearUserDefinedWritability(n);
        }
    }

    private void setUserDefinedWritability(int n) {
        block1: {
            int n2;
            int n3;
            int n4 = ~ChannelOutboundBuffer.writabilityMask(n);
            while (!UNWRITABLE_UPDATER.compareAndSet(this, n3 = this.unwritable, n2 = n3 & n4)) {
            }
            if (n3 == 0 || n2 != 0) break block1;
            this.fireChannelWritabilityChanged(true);
        }
    }

    private void clearUserDefinedWritability(int n) {
        block1: {
            int n2;
            int n3;
            int n4 = ChannelOutboundBuffer.writabilityMask(n);
            while (!UNWRITABLE_UPDATER.compareAndSet(this, n3 = this.unwritable, n2 = n3 | n4)) {
            }
            if (n3 != 0 || n2 == 0) break block1;
            this.fireChannelWritabilityChanged(true);
        }
    }

    private static int writabilityMask(int n) {
        if (n < 1 || n > 31) {
            throw new IllegalArgumentException("index: " + n + " (expected: 1~31)");
        }
        return 1 << n;
    }

    private void setWritable(boolean bl) {
        block1: {
            int n;
            int n2;
            while (!UNWRITABLE_UPDATER.compareAndSet(this, n2 = this.unwritable, n = n2 & 0xFFFFFFFE)) {
            }
            if (n2 == 0 || n != 0) break block1;
            this.fireChannelWritabilityChanged(bl);
        }
    }

    private void setUnwritable(boolean bl) {
        block1: {
            int n;
            int n2;
            while (!UNWRITABLE_UPDATER.compareAndSet(this, n2 = this.unwritable, n = n2 | 1)) {
            }
            if (n2 != 0) break block1;
            this.fireChannelWritabilityChanged(bl);
        }
    }

    private void fireChannelWritabilityChanged(boolean bl) {
        ChannelPipeline channelPipeline = this.channel.pipeline();
        if (bl) {
            Runnable runnable = this.fireChannelWritabilityChangedTask;
            if (runnable == null) {
                this.fireChannelWritabilityChangedTask = runnable = new ChannelOutboundBuffer$2(this, channelPipeline);
            }
            this.channel.eventLoop().execute(runnable);
        } else {
            channelPipeline.fireChannelWritabilityChanged();
        }
    }

    public int size() {
        return this.flushed;
    }

    public boolean isEmpty() {
        return this.flushed == 0;
    }

    void failFlushed(Throwable throwable, boolean bl) {
        if (this.inFail) {
            return;
        }
        try {
            this.inFail = true;
            while (this.remove0(throwable, bl)) {
            }
        }
        finally {
            this.inFail = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(Throwable throwable, boolean bl) {
        if (this.inFail) {
            this.channel.eventLoop().execute(new ChannelOutboundBuffer$3(this, throwable, bl));
            return;
        }
        this.inFail = true;
        if (!bl && this.channel.isOpen()) {
            throw new IllegalStateException("close() must be invoked after the channel is closed.");
        }
        if (!this.isEmpty()) {
            throw new IllegalStateException("close() must be invoked after all flushed writes are handled.");
        }
        try {
            for (ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.unflushedEntry; channelOutboundBuffer$Entry != null; channelOutboundBuffer$Entry = channelOutboundBuffer$Entry.recycleAndGetNext()) {
                int n = channelOutboundBuffer$Entry.pendingSize;
                TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, -n);
                if (channelOutboundBuffer$Entry.cancelled) continue;
                ReferenceCountUtil.safeRelease(channelOutboundBuffer$Entry.msg);
                ChannelOutboundBuffer.safeFail(channelOutboundBuffer$Entry.promise, throwable);
            }
        }
        finally {
            this.inFail = false;
        }
        this.clearNioBuffers();
    }

    void close(ClosedChannelException closedChannelException) {
        this.close(closedChannelException, false);
    }

    private static void safeSuccess(ChannelPromise channelPromise) {
        PromiseNotificationUtil.trySuccess(channelPromise, null, channelPromise instanceof VoidChannelPromise ? null : logger);
    }

    private static void safeFail(ChannelPromise channelPromise, Throwable throwable) {
        PromiseNotificationUtil.tryFailure(channelPromise, throwable, channelPromise instanceof VoidChannelPromise ? null : logger);
    }

    @Deprecated
    public void recycle() {
    }

    public long totalPendingWriteBytes() {
        return this.totalPendingSize;
    }

    public long bytesBeforeUnwritable() {
        long l = (long)this.channel.config().getWriteBufferHighWaterMark() - this.totalPendingSize;
        if (l > 0L) {
            return this.isWritable() ? l : 0L;
        }
        return 0L;
    }

    public long bytesBeforeWritable() {
        long l = this.totalPendingSize - (long)this.channel.config().getWriteBufferLowWaterMark();
        if (l > 0L) {
            return this.isWritable() ? 0L : l;
        }
        return 0L;
    }

    public void forEachFlushedMessage(ChannelOutboundBuffer$MessageProcessor channelOutboundBuffer$MessageProcessor) {
        ObjectUtil.checkNotNull(channelOutboundBuffer$MessageProcessor, "processor");
        ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry = this.flushedEntry;
        if (channelOutboundBuffer$Entry == null) {
            return;
        }
        do {
            if (channelOutboundBuffer$Entry.cancelled || channelOutboundBuffer$MessageProcessor.processMessage(channelOutboundBuffer$Entry.msg)) continue;
            return;
        } while (this.isFlushedEntry(channelOutboundBuffer$Entry = channelOutboundBuffer$Entry.next));
    }

    private boolean isFlushedEntry(ChannelOutboundBuffer$Entry channelOutboundBuffer$Entry) {
        return channelOutboundBuffer$Entry != null && channelOutboundBuffer$Entry != this.unflushedEntry;
    }
}

