/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel.nio;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import pro.gravit.repackage.io.netty.channel.ChannelException;
import pro.gravit.repackage.io.netty.channel.EventLoopException;
import pro.gravit.repackage.io.netty.channel.EventLoopTaskQueueFactory;
import pro.gravit.repackage.io.netty.channel.SelectStrategy;
import pro.gravit.repackage.io.netty.channel.SingleThreadEventLoop;
import pro.gravit.repackage.io.netty.channel.nio.AbstractNioChannel;
import pro.gravit.repackage.io.netty.channel.nio.AbstractNioChannel$NioUnsafe;
import pro.gravit.repackage.io.netty.channel.nio.NioEventLoop$1;
import pro.gravit.repackage.io.netty.channel.nio.NioEventLoop$2;
import pro.gravit.repackage.io.netty.channel.nio.NioEventLoop$3;
import pro.gravit.repackage.io.netty.channel.nio.NioEventLoop$4;
import pro.gravit.repackage.io.netty.channel.nio.NioEventLoop$5;
import pro.gravit.repackage.io.netty.channel.nio.NioEventLoop$6;
import pro.gravit.repackage.io.netty.channel.nio.NioEventLoop$SelectorTuple;
import pro.gravit.repackage.io.netty.channel.nio.NioEventLoopGroup;
import pro.gravit.repackage.io.netty.channel.nio.NioTask;
import pro.gravit.repackage.io.netty.channel.nio.SelectedSelectionKeySet;
import pro.gravit.repackage.io.netty.channel.nio.SelectedSelectionKeySetSelector;
import pro.gravit.repackage.io.netty.util.IntSupplier;
import pro.gravit.repackage.io.netty.util.concurrent.RejectedExecutionHandler;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.SystemPropertyUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public final class NioEventLoop
extends SingleThreadEventLoop {
    private static final InternalLogger logger;
    private static final int CLEANUP_INTERVAL = 256;
    private static final boolean DISABLE_KEY_SET_OPTIMIZATION;
    private static final int MIN_PREMATURE_SELECTOR_RETURNS = 3;
    private static final int SELECTOR_AUTO_REBUILD_THRESHOLD;
    private final IntSupplier selectNowSupplier = new NioEventLoop$1(this);
    private Selector selector;
    private Selector unwrappedSelector;
    private SelectedSelectionKeySet selectedKeys;
    private final SelectorProvider provider;
    private static final long AWAKE = -1L;
    private static final long NONE = Long.MAX_VALUE;
    private final AtomicLong nextWakeupNanos = new AtomicLong(-1L);
    private final SelectStrategy selectStrategy;
    private volatile int ioRatio = 50;
    private int cancelledKeys;
    private boolean needsToSelectAgain;

    NioEventLoop(NioEventLoopGroup nioEventLoopGroup, Executor executor, SelectorProvider selectorProvider, SelectStrategy selectStrategy, RejectedExecutionHandler rejectedExecutionHandler, EventLoopTaskQueueFactory eventLoopTaskQueueFactory, EventLoopTaskQueueFactory eventLoopTaskQueueFactory2) {
        super(nioEventLoopGroup, executor, false, NioEventLoop.newTaskQueue(eventLoopTaskQueueFactory), NioEventLoop.newTaskQueue(eventLoopTaskQueueFactory2), rejectedExecutionHandler);
        this.provider = ObjectUtil.checkNotNull(selectorProvider, "selectorProvider");
        this.selectStrategy = ObjectUtil.checkNotNull(selectStrategy, "selectStrategy");
        NioEventLoop$SelectorTuple nioEventLoop$SelectorTuple = this.openSelector();
        this.selector = nioEventLoop$SelectorTuple.selector;
        this.unwrappedSelector = nioEventLoop$SelectorTuple.unwrappedSelector;
    }

    private static Queue<Runnable> newTaskQueue(EventLoopTaskQueueFactory eventLoopTaskQueueFactory) {
        if (eventLoopTaskQueueFactory == null) {
            return NioEventLoop.newTaskQueue0(DEFAULT_MAX_PENDING_TASKS);
        }
        return eventLoopTaskQueueFactory.newTaskQueue(DEFAULT_MAX_PENDING_TASKS);
    }

    private NioEventLoop$SelectorTuple openSelector() {
        AbstractSelector abstractSelector;
        try {
            abstractSelector = this.provider.openSelector();
        }
        catch (IOException iOException) {
            throw new ChannelException("failed to open a new selector", iOException);
        }
        if (DISABLE_KEY_SET_OPTIMIZATION) {
            return new NioEventLoop$SelectorTuple(abstractSelector);
        }
        Object object = AccessController.doPrivileged(new NioEventLoop$3(this));
        if (!(object instanceof Class) || !((Class)object).isAssignableFrom(abstractSelector.getClass())) {
            if (object instanceof Throwable) {
                Throwable throwable = (Throwable)object;
                logger.trace("failed to instrument a special java.util.Set into: {}", (Object)abstractSelector, (Object)throwable);
            }
            return new NioEventLoop$SelectorTuple(abstractSelector);
        }
        Class clazz = (Class)object;
        SelectedSelectionKeySet selectedSelectionKeySet = new SelectedSelectionKeySet();
        Object object2 = AccessController.doPrivileged(new NioEventLoop$4(this, clazz, abstractSelector, selectedSelectionKeySet));
        if (object2 instanceof Exception) {
            this.selectedKeys = null;
            Exception exception = (Exception)object2;
            logger.trace("failed to instrument a special java.util.Set into: {}", (Object)abstractSelector, (Object)exception);
            return new NioEventLoop$SelectorTuple(abstractSelector);
        }
        this.selectedKeys = selectedSelectionKeySet;
        logger.trace("instrumented a special java.util.Set into: {}", (Object)abstractSelector);
        return new NioEventLoop$SelectorTuple(abstractSelector, new SelectedSelectionKeySetSelector(abstractSelector, selectedSelectionKeySet));
    }

    public SelectorProvider selectorProvider() {
        return this.provider;
    }

    @Override
    protected Queue<Runnable> newTaskQueue(int n) {
        return NioEventLoop.newTaskQueue0(n);
    }

    private static Queue<Runnable> newTaskQueue0(int n) {
        return n == Integer.MAX_VALUE ? PlatformDependent.newMpscQueue() : PlatformDependent.newMpscQueue(n);
    }

    public void register(SelectableChannel selectableChannel, int n, NioTask<?> nioTask) {
        ObjectUtil.checkNotNull(selectableChannel, "ch");
        if (n == 0) {
            throw new IllegalArgumentException("interestOps must be non-zero.");
        }
        if ((n & ~selectableChannel.validOps()) != 0) {
            throw new IllegalArgumentException("invalid interestOps: " + n + "(validOps: " + selectableChannel.validOps() + ')');
        }
        ObjectUtil.checkNotNull(nioTask, "task");
        if (this.isShutdown()) {
            throw new IllegalStateException("event loop shut down");
        }
        if (this.inEventLoop()) {
            this.register0(selectableChannel, n, nioTask);
        } else {
            try {
                this.submit(new NioEventLoop$5(this, selectableChannel, n, nioTask)).sync();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void register0(SelectableChannel selectableChannel, int n, NioTask<?> nioTask) {
        try {
            selectableChannel.register(this.unwrappedSelector, n, nioTask);
        }
        catch (Exception exception) {
            throw new EventLoopException("failed to register a channel", exception);
        }
    }

    public int getIoRatio() {
        return this.ioRatio;
    }

    public void setIoRatio(int n) {
        if (n <= 0 || n > 100) {
            throw new IllegalArgumentException("ioRatio: " + n + " (expected: 0 < ioRatio <= 100)");
        }
        this.ioRatio = n;
    }

    public void rebuildSelector() {
        if (!this.inEventLoop()) {
            this.execute(new NioEventLoop$6(this));
            return;
        }
        this.rebuildSelector0();
    }

    @Override
    public int registeredChannels() {
        return this.selector.keys().size() - this.cancelledKeys;
    }

    private void rebuildSelector0() {
        int n;
        block11: {
            NioEventLoop$SelectorTuple nioEventLoop$SelectorTuple;
            Selector selector = this.selector;
            if (selector == null) {
                return;
            }
            try {
                nioEventLoop$SelectorTuple = this.openSelector();
            }
            catch (Exception exception) {
                logger.warn("Failed to create a new Selector.", exception);
                return;
            }
            n = 0;
            for (SelectionKey selectionKey : selector.keys()) {
                Object object;
                Object object2 = selectionKey.attachment();
                try {
                    if (!selectionKey.isValid() || selectionKey.channel().keyFor(nioEventLoop$SelectorTuple.unwrappedSelector) != null) continue;
                    int n2 = selectionKey.interestOps();
                    selectionKey.cancel();
                    object = selectionKey.channel().register(nioEventLoop$SelectorTuple.unwrappedSelector, n2, object2);
                    if (object2 instanceof AbstractNioChannel) {
                        ((AbstractNioChannel)object2).selectionKey = object;
                    }
                    ++n;
                }
                catch (Exception exception) {
                    logger.warn("Failed to re-register a Channel to the new Selector.", exception);
                    if (object2 instanceof AbstractNioChannel) {
                        object = (AbstractNioChannel)object2;
                        ((AbstractNioChannel)object).unsafe().close(((AbstractNioChannel)object).unsafe().voidPromise());
                        continue;
                    }
                    object = (NioTask)object2;
                    NioEventLoop.invokeChannelUnregistered((NioTask<SelectableChannel>)object, selectionKey, exception);
                }
            }
            this.selector = nioEventLoop$SelectorTuple.selector;
            this.unwrappedSelector = nioEventLoop$SelectorTuple.unwrappedSelector;
            try {
                selector.close();
            }
            catch (Throwable throwable) {
                if (!logger.isWarnEnabled()) break block11;
                logger.warn("Failed to close the old Selector.", throwable);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("Migrated " + n + " channel(s) to the new Selector.");
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [17[CASE], 15[SWITCH]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean unexpectedSelectorWakeup(int n) {
        if (Thread.interrupted()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Selector.select() returned prematurely because Thread.currentThread().interrupt() was called. Use NioEventLoop.shutdownGracefully() to shutdown the NioEventLoop.");
            }
            return true;
        }
        if (SELECTOR_AUTO_REBUILD_THRESHOLD > 0 && n >= SELECTOR_AUTO_REBUILD_THRESHOLD) {
            logger.warn("Selector.select() returned prematurely {} times in a row; rebuilding Selector {}.", (Object)n, (Object)this.selector);
            this.rebuildSelector();
            return true;
        }
        return false;
    }

    private static void handleLoopException(Throwable throwable) {
        logger.warn("Unexpected exception in the selector loop.", throwable);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void processSelectedKeys() {
        if (this.selectedKeys != null) {
            this.processSelectedKeysOptimized();
        } else {
            this.processSelectedKeysPlain(this.selector.selectedKeys());
        }
    }

    @Override
    protected void cleanup() {
        try {
            this.selector.close();
        }
        catch (IOException iOException) {
            logger.warn("Failed to close a selector.", iOException);
        }
    }

    void cancel(SelectionKey selectionKey) {
        selectionKey.cancel();
        ++this.cancelledKeys;
        if (this.cancelledKeys >= 256) {
            this.cancelledKeys = 0;
            this.needsToSelectAgain = true;
        }
    }

    private void processSelectedKeysPlain(Set<SelectionKey> set) {
        if (set.isEmpty()) {
            return;
        }
        Iterator<SelectionKey> iterator = set.iterator();
        while (true) {
            SelectionKey selectionKey = iterator.next();
            Object object = selectionKey.attachment();
            iterator.remove();
            if (object instanceof AbstractNioChannel) {
                this.processSelectedKey(selectionKey, (AbstractNioChannel)object);
            } else {
                NioTask nioTask = (NioTask)object;
                NioEventLoop.processSelectedKey(selectionKey, nioTask);
            }
            if (!iterator.hasNext()) break;
            if (!this.needsToSelectAgain) continue;
            this.selectAgain();
            set = this.selector.selectedKeys();
            if (set.isEmpty()) break;
            iterator = set.iterator();
        }
    }

    private void processSelectedKeysOptimized() {
        for (int i = 0; i < this.selectedKeys.size; ++i) {
            SelectionKey selectionKey = this.selectedKeys.keys[i];
            this.selectedKeys.keys[i] = null;
            Object object = selectionKey.attachment();
            if (object instanceof AbstractNioChannel) {
                this.processSelectedKey(selectionKey, (AbstractNioChannel)object);
            } else {
                NioTask nioTask = (NioTask)object;
                NioEventLoop.processSelectedKey(selectionKey, nioTask);
            }
            if (!this.needsToSelectAgain) continue;
            this.selectedKeys.reset(i + 1);
            this.selectAgain();
            i = -1;
        }
    }

    private void processSelectedKey(SelectionKey selectionKey, AbstractNioChannel abstractNioChannel) {
        AbstractNioChannel$NioUnsafe abstractNioChannel$NioUnsafe = abstractNioChannel.unsafe();
        if (!selectionKey.isValid()) {
            NioEventLoop nioEventLoop;
            try {
                nioEventLoop = abstractNioChannel.eventLoop();
            }
            catch (Throwable throwable) {
                return;
            }
            if (nioEventLoop == this) {
                abstractNioChannel$NioUnsafe.close(abstractNioChannel$NioUnsafe.voidPromise());
            }
            return;
        }
        try {
            int n = selectionKey.readyOps();
            if ((n & 8) != 0) {
                int n2 = selectionKey.interestOps();
                selectionKey.interestOps(n2 &= 0xFFFFFFF7);
                abstractNioChannel$NioUnsafe.finishConnect();
            }
            if ((n & 4) != 0) {
                abstractNioChannel.unsafe().forceFlush();
            }
            if ((n & 0x11) != 0 || n == 0) {
                abstractNioChannel$NioUnsafe.read();
            }
        }
        catch (CancelledKeyException cancelledKeyException) {
            abstractNioChannel$NioUnsafe.close(abstractNioChannel$NioUnsafe.voidPromise());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processSelectedKey(SelectionKey selectionKey, NioTask<SelectableChannel> nioTask) {
        int n = 0;
        try {
            nioTask.channelReady(selectionKey.channel(), selectionKey);
            n = 1;
        }
        catch (Exception exception) {
            try {
                selectionKey.cancel();
                NioEventLoop.invokeChannelUnregistered(nioTask, selectionKey, exception);
                n = 2;
            }
            catch (Throwable throwable) {
                switch (n) {
                    case 0: {
                        selectionKey.cancel();
                        NioEventLoop.invokeChannelUnregistered(nioTask, selectionKey, null);
                        break;
                    }
                    case 1: {
                        if (selectionKey.isValid()) break;
                        NioEventLoop.invokeChannelUnregistered(nioTask, selectionKey, null);
                        break;
                    }
                }
                throw throwable;
            }
            switch (n) {
                case 0: {
                    selectionKey.cancel();
                    NioEventLoop.invokeChannelUnregistered(nioTask, selectionKey, null);
                    break;
                }
                case 1: {
                    if (!selectionKey.isValid()) {
                        NioEventLoop.invokeChannelUnregistered(nioTask, selectionKey, null);
                        break;
                    }
                }
            }
        }
        switch (n) {
            case 0: {
                selectionKey.cancel();
                NioEventLoop.invokeChannelUnregistered(nioTask, selectionKey, null);
                break;
            }
            case 1: {
                if (!selectionKey.isValid()) {
                    NioEventLoop.invokeChannelUnregistered(nioTask, selectionKey, null);
                }
                break;
            }
        }
    }

    private void closeAll() {
        this.selectAgain();
        Set<SelectionKey> set = this.selector.keys();
        ArrayList<AbstractNioChannel> arrayList = new ArrayList<AbstractNioChannel>(set.size());
        for (SelectionKey object : set) {
            Object object2 = object.attachment();
            if (object2 instanceof AbstractNioChannel) {
                arrayList.add((AbstractNioChannel)object2);
                continue;
            }
            object.cancel();
            NioTask nioTask = (NioTask)object2;
            NioEventLoop.invokeChannelUnregistered(nioTask, object, null);
        }
        for (AbstractNioChannel abstractNioChannel : arrayList) {
            abstractNioChannel.unsafe().close(abstractNioChannel.unsafe().voidPromise());
        }
    }

    private static void invokeChannelUnregistered(NioTask<SelectableChannel> nioTask, SelectionKey selectionKey, Throwable throwable) {
        try {
            nioTask.channelUnregistered(selectionKey.channel(), throwable);
        }
        catch (Exception exception) {
            logger.warn("Unexpected exception while running NioTask.channelUnregistered()", exception);
        }
    }

    @Override
    protected void wakeup(boolean bl) {
        if (!bl && this.nextWakeupNanos.getAndSet(-1L) != -1L) {
            this.selector.wakeup();
        }
    }

    @Override
    protected boolean beforeScheduledTaskSubmitted(long l) {
        return l < this.nextWakeupNanos.get();
    }

    @Override
    protected boolean afterScheduledTaskSubmitted(long l) {
        return l < this.nextWakeupNanos.get();
    }

    Selector unwrappedSelector() {
        return this.unwrappedSelector;
    }

    int selectNow() {
        return this.selector.selectNow();
    }

    private int select(long l) {
        if (l == Long.MAX_VALUE) {
            return this.selector.select();
        }
        long l2 = NioEventLoop.deadlineToDelayNanos(l + 995000L) / 1000000L;
        return l2 <= 0L ? this.selector.selectNow() : this.selector.select(l2);
    }

    private void selectAgain() {
        this.needsToSelectAgain = false;
        try {
            this.selector.selectNow();
        }
        catch (Throwable throwable) {
            logger.warn("Failed to update SelectionKeys.", throwable);
        }
    }

    static /* synthetic */ void access$000(NioEventLoop nioEventLoop, SelectableChannel selectableChannel, int n, NioTask nioTask) {
        nioEventLoop.register0(selectableChannel, n, nioTask);
    }

    static /* synthetic */ void access$100(NioEventLoop nioEventLoop) {
        nioEventLoop.rebuildSelector0();
    }

    static {
        int n;
        logger = InternalLoggerFactory.getInstance(NioEventLoop.class);
        DISABLE_KEY_SET_OPTIMIZATION = SystemPropertyUtil.getBoolean("pro.gravit.repackage.io.netty.noKeySetOptimization", false);
        String string = "sun.nio.ch.bugLevel";
        String string2 = SystemPropertyUtil.get("sun.nio.ch.bugLevel");
        if (string2 == null) {
            try {
                AccessController.doPrivileged(new NioEventLoop$2());
            }
            catch (SecurityException securityException) {
                logger.debug("Unable to get/set System Property: sun.nio.ch.bugLevel", securityException);
            }
        }
        if ((n = SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.selectorAutoRebuildThreshold", 512)) < 3) {
            n = 0;
        }
        SELECTOR_AUTO_REBUILD_THRESHOLD = n;
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.noKeySetOptimization: {}", (Object)DISABLE_KEY_SET_OPTIMIZATION);
            logger.debug("-Dio.netty.selectorAutoRebuildThreshold: {}", (Object)SELECTOR_AUTO_REBUILD_THRESHOLD);
        }
    }
}

