/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec;

import java.util.List;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufHolder;
import pro.gravit.repackage.io.netty.buffer.CompositeByteBuf;
import pro.gravit.repackage.io.netty.buffer.Unpooled;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.ChannelFutureListener;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelPipeline;
import pro.gravit.repackage.io.netty.handler.codec.DecoderResult;
import pro.gravit.repackage.io.netty.handler.codec.DecoderResultProvider;
import pro.gravit.repackage.io.netty.handler.codec.MessageAggregationException;
import pro.gravit.repackage.io.netty.handler.codec.MessageAggregator$1;
import pro.gravit.repackage.io.netty.handler.codec.MessageToMessageDecoder;
import pro.gravit.repackage.io.netty.handler.codec.TooLongFrameException;
import pro.gravit.repackage.io.netty.util.ReferenceCountUtil;
import pro.gravit.repackage.io.netty.util.concurrent.Future;
import pro.gravit.repackage.io.netty.util.concurrent.GenericFutureListener;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public abstract class MessageAggregator<I, S, C extends ByteBufHolder, O extends ByteBufHolder>
extends MessageToMessageDecoder<I> {
    private static final int DEFAULT_MAX_COMPOSITEBUFFER_COMPONENTS = 1024;
    private final int maxContentLength;
    private O currentMessage;
    private boolean handlingOversizedMessage;
    private int maxCumulationBufferComponents = 1024;
    private ChannelHandlerContext ctx;
    private ChannelFutureListener continueResponseWriteListener;
    private boolean aggregating;

    protected MessageAggregator(int n) {
        MessageAggregator.validateMaxContentLength(n);
        this.maxContentLength = n;
    }

    protected MessageAggregator(int n, Class<? extends I> clazz) {
        super(clazz);
        MessageAggregator.validateMaxContentLength(n);
        this.maxContentLength = n;
    }

    private static void validateMaxContentLength(int n) {
        ObjectUtil.checkPositiveOrZero(n, "maxContentLength");
    }

    @Override
    public boolean acceptInboundMessage(Object object) {
        if (!super.acceptInboundMessage(object)) {
            return false;
        }
        Object object2 = object;
        if (this.isAggregated(object2)) {
            return false;
        }
        if (this.isStartMessage(object2)) {
            this.aggregating = true;
            return true;
        }
        return this.aggregating && this.isContentMessage(object2);
    }

    protected abstract boolean isStartMessage(I var1);

    protected abstract boolean isContentMessage(I var1);

    protected abstract boolean isLastContentMessage(C var1);

    protected abstract boolean isAggregated(I var1);

    public final int maxContentLength() {
        return this.maxContentLength;
    }

    public final int maxCumulationBufferComponents() {
        return this.maxCumulationBufferComponents;
    }

    public final void setMaxCumulationBufferComponents(int n) {
        if (n < 2) {
            throw new IllegalArgumentException("maxCumulationBufferComponents: " + n + " (expected: >= 2)");
        }
        if (this.ctx != null) {
            throw new IllegalStateException("decoder properties cannot be changed once the decoder is added to a pipeline.");
        }
        this.maxCumulationBufferComponents = n;
    }

    @Deprecated
    public final boolean isHandlingOversizedMessage() {
        return this.handlingOversizedMessage;
    }

    protected final ChannelHandlerContext ctx() {
        if (this.ctx == null) {
            throw new IllegalStateException("not added to a pipeline yet");
        }
        return this.ctx;
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, I i, List<Object> list) {
        assert (this.aggregating);
        if (this.isStartMessage(i)) {
            Object object;
            this.handlingOversizedMessage = false;
            if (this.currentMessage != null) {
                this.currentMessage.release();
                this.currentMessage = null;
                throw new MessageAggregationException();
            }
            I i2 = i;
            Object object2 = this.newContinueResponse(i2, this.maxContentLength, channelHandlerContext.pipeline());
            if (object2 != null) {
                object = this.continueResponseWriteListener;
                if (object == null) {
                    object = new MessageAggregator$1(this, channelHandlerContext);
                    this.continueResponseWriteListener = object;
                }
                boolean bl = this.closeAfterContinueResponse(object2);
                this.handlingOversizedMessage = this.ignoreContentAfterContinueResponse(object2);
                ChannelFuture channelFuture = channelHandlerContext.writeAndFlush(object2).addListener((GenericFutureListener<? extends Future<? super Void>>)object);
                if (bl) {
                    channelFuture.addListener(ChannelFutureListener.CLOSE);
                    return;
                }
                if (this.handlingOversizedMessage) {
                    return;
                }
            } else if (this.isContentLengthInvalid(i2, this.maxContentLength)) {
                this.invokeHandleOversizedMessage(channelHandlerContext, i2);
                return;
            }
            if (i2 instanceof DecoderResultProvider && !((DecoderResultProvider)i2).decoderResult().isSuccess()) {
                object = i2 instanceof ByteBufHolder ? this.beginAggregation(i2, ((ByteBufHolder)i2).content().retain()) : this.beginAggregation(i2, Unpooled.EMPTY_BUFFER);
                this.finishAggregation0(object);
                list.add(object);
                return;
            }
            object = channelHandlerContext.alloc().compositeBuffer(this.maxCumulationBufferComponents);
            if (i2 instanceof ByteBufHolder) {
                MessageAggregator.appendPartialContent((CompositeByteBuf)object, ((ByteBufHolder)i2).content());
            }
            this.currentMessage = this.beginAggregation(i2, (ByteBuf)object);
        } else if (this.isContentMessage(i)) {
            boolean bl;
            if (this.currentMessage == null) {
                return;
            }
            CompositeByteBuf compositeByteBuf = (CompositeByteBuf)this.currentMessage.content();
            ByteBufHolder byteBufHolder = (ByteBufHolder)i;
            if (compositeByteBuf.readableBytes() > this.maxContentLength - byteBufHolder.content().readableBytes()) {
                O o = this.currentMessage;
                this.invokeHandleOversizedMessage(channelHandlerContext, o);
                return;
            }
            MessageAggregator.appendPartialContent(compositeByteBuf, byteBufHolder.content());
            this.aggregate(this.currentMessage, byteBufHolder);
            if (byteBufHolder instanceof DecoderResultProvider) {
                DecoderResult decoderResult = ((DecoderResultProvider)((Object)byteBufHolder)).decoderResult();
                if (!decoderResult.isSuccess()) {
                    if (this.currentMessage instanceof DecoderResultProvider) {
                        ((DecoderResultProvider)this.currentMessage).setDecoderResult(DecoderResult.failure(decoderResult.cause()));
                    }
                    bl = true;
                } else {
                    bl = this.isLastContentMessage(byteBufHolder);
                }
            } else {
                bl = this.isLastContentMessage(byteBufHolder);
            }
            if (bl) {
                this.finishAggregation0(this.currentMessage);
                list.add(this.currentMessage);
                this.currentMessage = null;
            }
        } else {
            throw new MessageAggregationException();
        }
    }

    private static void appendPartialContent(CompositeByteBuf compositeByteBuf, ByteBuf byteBuf) {
        if (byteBuf.isReadable()) {
            compositeByteBuf.addComponent(true, byteBuf.retain());
        }
    }

    protected abstract boolean isContentLengthInvalid(S var1, int var2);

    protected abstract Object newContinueResponse(S var1, int var2, ChannelPipeline var3);

    protected abstract boolean closeAfterContinueResponse(Object var1);

    protected abstract boolean ignoreContentAfterContinueResponse(Object var1);

    protected abstract O beginAggregation(S var1, ByteBuf var2);

    protected void aggregate(O o, C c) {
    }

    private void finishAggregation0(O o) {
        this.aggregating = false;
        this.finishAggregation(o);
    }

    protected void finishAggregation(O o) {
    }

    private void invokeHandleOversizedMessage(ChannelHandlerContext channelHandlerContext, S s) {
        this.handlingOversizedMessage = true;
        this.currentMessage = null;
        try {
            this.handleOversizedMessage(channelHandlerContext, s);
        }
        finally {
            ReferenceCountUtil.release(s);
        }
    }

    protected void handleOversizedMessage(ChannelHandlerContext channelHandlerContext, S s) {
        channelHandlerContext.fireExceptionCaught(new TooLongFrameException("content length exceeded " + this.maxContentLength() + " bytes."));
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        if (this.currentMessage != null && !channelHandlerContext.channel().config().isAutoRead()) {
            channelHandlerContext.read();
        }
        channelHandlerContext.fireChannelReadComplete();
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        try {
            super.channelInactive(channelHandlerContext);
        }
        finally {
            this.releaseCurrentMessage();
        }
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        try {
            super.handlerRemoved(channelHandlerContext);
        }
        finally {
            this.releaseCurrentMessage();
        }
    }

    private void releaseCurrentMessage() {
        if (this.currentMessage != null) {
            this.currentMessage.release();
            this.currentMessage = null;
            this.handlingOversizedMessage = false;
            this.aggregating = false;
        }
    }
}

