/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.base64;

import java.nio.ByteOrder;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.handler.codec.base64.Base64$Decoder;
import pro.gravit.repackage.io.netty.handler.codec.base64.Base64Dialect;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public final class Base64 {
    private static final int MAX_LINE_LENGTH = 76;
    private static final byte EQUALS_SIGN = 61;
    private static final byte NEW_LINE = 10;
    private static final byte WHITE_SPACE_ENC = -5;
    private static final byte EQUALS_SIGN_ENC = -1;

    private static byte[] alphabet(Base64Dialect base64Dialect) {
        return ObjectUtil.checkNotNull(base64Dialect, (String)"dialect").alphabet;
    }

    private static byte[] decodabet(Base64Dialect base64Dialect) {
        return ObjectUtil.checkNotNull(base64Dialect, (String)"dialect").decodabet;
    }

    private static boolean breakLines(Base64Dialect base64Dialect) {
        return ObjectUtil.checkNotNull(base64Dialect, (String)"dialect").breakLinesByDefault;
    }

    public static ByteBuf encode(ByteBuf byteBuf) {
        return Base64.encode(byteBuf, Base64Dialect.STANDARD);
    }

    public static ByteBuf encode(ByteBuf byteBuf, Base64Dialect base64Dialect) {
        return Base64.encode(byteBuf, Base64.breakLines(base64Dialect), base64Dialect);
    }

    public static ByteBuf encode(ByteBuf byteBuf, boolean bl) {
        return Base64.encode(byteBuf, bl, Base64Dialect.STANDARD);
    }

    public static ByteBuf encode(ByteBuf byteBuf, boolean bl, Base64Dialect base64Dialect) {
        ObjectUtil.checkNotNull(byteBuf, "src");
        ByteBuf byteBuf2 = Base64.encode(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes(), bl, base64Dialect);
        byteBuf.readerIndex(byteBuf.writerIndex());
        return byteBuf2;
    }

    public static ByteBuf encode(ByteBuf byteBuf, int n, int n2) {
        return Base64.encode(byteBuf, n, n2, Base64Dialect.STANDARD);
    }

    public static ByteBuf encode(ByteBuf byteBuf, int n, int n2, Base64Dialect base64Dialect) {
        return Base64.encode(byteBuf, n, n2, Base64.breakLines(base64Dialect), base64Dialect);
    }

    public static ByteBuf encode(ByteBuf byteBuf, int n, int n2, boolean bl) {
        return Base64.encode(byteBuf, n, n2, bl, Base64Dialect.STANDARD);
    }

    public static ByteBuf encode(ByteBuf byteBuf, int n, int n2, boolean bl, Base64Dialect base64Dialect) {
        return Base64.encode(byteBuf, n, n2, bl, base64Dialect, byteBuf.alloc());
    }

    public static ByteBuf encode(ByteBuf byteBuf, int n, int n2, boolean bl, Base64Dialect base64Dialect, ByteBufAllocator byteBufAllocator) {
        ObjectUtil.checkNotNull(byteBuf, "src");
        ObjectUtil.checkNotNull(base64Dialect, "dialect");
        ByteBuf byteBuf2 = byteBufAllocator.buffer(Base64.encodedBufferSize(n2, bl)).order(byteBuf.order());
        byte[] byArray = Base64.alphabet(base64Dialect);
        int n3 = 0;
        int n4 = 0;
        int n5 = n2 - 2;
        int n6 = 0;
        while (n3 < n5) {
            Base64.encode3to4(byteBuf, n3 + n, 3, byteBuf2, n4, byArray);
            if (bl && (n6 += 4) == 76) {
                byteBuf2.setByte(n4 + 4, 10);
                ++n4;
                n6 = 0;
            }
            n3 += 3;
            n4 += 4;
        }
        if (n3 < n2) {
            Base64.encode3to4(byteBuf, n3 + n, n2 - n3, byteBuf2, n4, byArray);
            n4 += 4;
        }
        if (n4 > 1 && byteBuf2.getByte(n4 - 1) == 10) {
            --n4;
        }
        return byteBuf2.slice(0, n4);
    }

    private static void encode3to4(ByteBuf byteBuf, int n, int n2, ByteBuf byteBuf2, int n3, byte[] byArray) {
        if (byteBuf.order() == ByteOrder.BIG_ENDIAN) {
            int n4;
            switch (n2) {
                case 1: {
                    n4 = Base64.toInt(byteBuf.getByte(n));
                    break;
                }
                case 2: {
                    n4 = Base64.toIntBE(byteBuf.getShort(n));
                    break;
                }
                default: {
                    n4 = n2 <= 0 ? 0 : Base64.toIntBE(byteBuf.getMedium(n));
                }
            }
            Base64.encode3to4BigEndian(n4, n2, byteBuf2, n3, byArray);
        } else {
            int n5;
            switch (n2) {
                case 1: {
                    n5 = Base64.toInt(byteBuf.getByte(n));
                    break;
                }
                case 2: {
                    n5 = Base64.toIntLE(byteBuf.getShort(n));
                    break;
                }
                default: {
                    n5 = n2 <= 0 ? 0 : Base64.toIntLE(byteBuf.getMedium(n));
                }
            }
            Base64.encode3to4LittleEndian(n5, n2, byteBuf2, n3, byArray);
        }
    }

    static int encodedBufferSize(int n, boolean bl) {
        long l = ((long)n << 2) / 3L;
        long l2 = l + 3L & 0xFFFFFFFFFFFFFFFCL;
        if (bl) {
            l2 += l / 76L;
        }
        return l2 < Integer.MAX_VALUE ? (int)l2 : Integer.MAX_VALUE;
    }

    private static int toInt(byte by) {
        return (by & 0xFF) << 16;
    }

    private static int toIntBE(short s) {
        return (s & 0xFF00) << 8 | (s & 0xFF) << 8;
    }

    private static int toIntLE(short s) {
        return (s & 0xFF) << 16 | s & 0xFF00;
    }

    private static int toIntBE(int n) {
        return n & 0xFF0000 | n & 0xFF00 | n & 0xFF;
    }

    private static int toIntLE(int n) {
        return (n & 0xFF) << 16 | n & 0xFF00 | (n & 0xFF0000) >>> 16;
    }

    private static void encode3to4BigEndian(int n, int n2, ByteBuf byteBuf, int n3, byte[] byArray) {
        switch (n2) {
            case 3: {
                byteBuf.setInt(n3, byArray[n >>> 18] << 24 | byArray[n >>> 12 & 0x3F] << 16 | byArray[n >>> 6 & 0x3F] << 8 | byArray[n & 0x3F]);
                break;
            }
            case 2: {
                byteBuf.setInt(n3, byArray[n >>> 18] << 24 | byArray[n >>> 12 & 0x3F] << 16 | byArray[n >>> 6 & 0x3F] << 8 | 0x3D);
                break;
            }
            case 1: {
                byteBuf.setInt(n3, byArray[n >>> 18] << 24 | byArray[n >>> 12 & 0x3F] << 16 | 0x3D00 | 0x3D);
                break;
            }
        }
    }

    private static void encode3to4LittleEndian(int n, int n2, ByteBuf byteBuf, int n3, byte[] byArray) {
        switch (n2) {
            case 3: {
                byteBuf.setInt(n3, byArray[n >>> 18] | byArray[n >>> 12 & 0x3F] << 8 | byArray[n >>> 6 & 0x3F] << 16 | byArray[n & 0x3F] << 24);
                break;
            }
            case 2: {
                byteBuf.setInt(n3, byArray[n >>> 18] | byArray[n >>> 12 & 0x3F] << 8 | byArray[n >>> 6 & 0x3F] << 16 | 0x3D000000);
                break;
            }
            case 1: {
                byteBuf.setInt(n3, byArray[n >>> 18] | byArray[n >>> 12 & 0x3F] << 8 | 0x3D0000 | 0x3D000000);
                break;
            }
        }
    }

    public static ByteBuf decode(ByteBuf byteBuf) {
        return Base64.decode(byteBuf, Base64Dialect.STANDARD);
    }

    public static ByteBuf decode(ByteBuf byteBuf, Base64Dialect base64Dialect) {
        ObjectUtil.checkNotNull(byteBuf, "src");
        ByteBuf byteBuf2 = Base64.decode(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes(), base64Dialect);
        byteBuf.readerIndex(byteBuf.writerIndex());
        return byteBuf2;
    }

    public static ByteBuf decode(ByteBuf byteBuf, int n, int n2) {
        return Base64.decode(byteBuf, n, n2, Base64Dialect.STANDARD);
    }

    public static ByteBuf decode(ByteBuf byteBuf, int n, int n2, Base64Dialect base64Dialect) {
        return Base64.decode(byteBuf, n, n2, base64Dialect, byteBuf.alloc());
    }

    public static ByteBuf decode(ByteBuf byteBuf, int n, int n2, Base64Dialect base64Dialect, ByteBufAllocator byteBufAllocator) {
        ObjectUtil.checkNotNull(byteBuf, "src");
        ObjectUtil.checkNotNull(base64Dialect, "dialect");
        return new Base64$Decoder(null).decode(byteBuf, n, n2, byteBufAllocator, base64Dialect);
    }

    static int decodedBufferSize(int n) {
        return n - (n >>> 2);
    }

    private Base64() {
    }

    static /* synthetic */ byte[] access$100(Base64Dialect base64Dialect) {
        return Base64.decodabet(base64Dialect);
    }
}

