/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http;

import pro.gravit.repackage.io.netty.handler.codec.http.DefaultHttpHeaders$HeaderValueConverter;

final class DefaultHttpHeaders$HeaderValueConverterAndValidator
extends DefaultHttpHeaders$HeaderValueConverter {
    static final DefaultHttpHeaders$HeaderValueConverterAndValidator INSTANCE = new DefaultHttpHeaders$HeaderValueConverterAndValidator();

    private DefaultHttpHeaders$HeaderValueConverterAndValidator() {
    }

    @Override
    public CharSequence convertObject(Object object) {
        CharSequence charSequence = super.convertObject(object);
        int n = 0;
        for (int i = 0; i < charSequence.length(); ++i) {
            n = DefaultHttpHeaders$HeaderValueConverterAndValidator.validateValueChar(charSequence, n, charSequence.charAt(i));
        }
        if (n != 0) {
            throw new IllegalArgumentException("a header value must not end with '\\r' or '\\n':" + charSequence);
        }
        return charSequence;
    }

    private static int validateValueChar(CharSequence charSequence, int n, char c) {
        if ((c & 0xFFFFFFF0) == 0) {
            switch (c) {
                case '\u0000': {
                    throw new IllegalArgumentException("a header value contains a prohibited character '\u0000': " + charSequence);
                }
                case '\u000b': {
                    throw new IllegalArgumentException("a header value contains a prohibited character '\\v': " + charSequence);
                }
                case '\f': {
                    throw new IllegalArgumentException("a header value contains a prohibited character '\\f': " + charSequence);
                }
            }
        }
        switch (n) {
            case 0: {
                switch (c) {
                    case '\r': {
                        return 1;
                    }
                    case '\n': {
                        return 2;
                    }
                }
                break;
            }
            case 1: {
                if (c == '\n') {
                    return 2;
                }
                throw new IllegalArgumentException("only '\\n' is allowed after '\\r': " + charSequence);
            }
            case 2: {
                switch (c) {
                    case '\t': 
                    case ' ': {
                        return 0;
                    }
                }
                throw new IllegalArgumentException("only ' ' and '\\t' are allowed after '\\n': " + charSequence);
            }
        }
        return n;
    }
}

