/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http;

import java.util.HashMap;
import java.util.Map;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.embedded.EmbeddedChannel;
import pro.gravit.repackage.io.netty.handler.codec.compression.Brotli;
import pro.gravit.repackage.io.netty.handler.codec.compression.BrotliOptions;
import pro.gravit.repackage.io.netty.handler.codec.compression.CompressionOptions;
import pro.gravit.repackage.io.netty.handler.codec.compression.DeflateOptions;
import pro.gravit.repackage.io.netty.handler.codec.compression.GzipOptions;
import pro.gravit.repackage.io.netty.handler.codec.compression.StandardCompressionOptions;
import pro.gravit.repackage.io.netty.handler.codec.compression.ZlibCodecFactory;
import pro.gravit.repackage.io.netty.handler.codec.compression.ZlibWrapper;
import pro.gravit.repackage.io.netty.handler.codec.compression.Zstd;
import pro.gravit.repackage.io.netty.handler.codec.compression.ZstdOptions;
import pro.gravit.repackage.io.netty.handler.codec.http.CompressionEncoderFactory;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpContent;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpContentCompressor$BrEncoderFactory;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpContentCompressor$DeflateEncoderFactory;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpContentCompressor$GzipEncoderFactory;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpContentCompressor$ZstdEncoderFactory;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpContentEncoder;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpContentEncoder$Result;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderNames;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpResponse;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public class HttpContentCompressor
extends HttpContentEncoder {
    private final boolean supportsCompressionOptions;
    private final BrotliOptions brotliOptions;
    private final GzipOptions gzipOptions;
    private final DeflateOptions deflateOptions;
    private final ZstdOptions zstdOptions;
    private final int compressionLevel;
    private final int windowBits;
    private final int memLevel;
    private final int contentSizeThreshold;
    private ChannelHandlerContext ctx;
    private final Map<String, CompressionEncoderFactory> factories;

    public HttpContentCompressor() {
        this(6);
    }

    @Deprecated
    public HttpContentCompressor(int n) {
        this(n, 15, 8, 0);
    }

    @Deprecated
    public HttpContentCompressor(int n, int n2, int n3) {
        this(n, n2, n3, 0);
    }

    @Deprecated
    public HttpContentCompressor(int n, int n2, int n3, int n4) {
        this.compressionLevel = ObjectUtil.checkInRange(n, 0, 9, "compressionLevel");
        this.windowBits = ObjectUtil.checkInRange(n2, 9, 15, "windowBits");
        this.memLevel = ObjectUtil.checkInRange(n3, 1, 9, "memLevel");
        this.contentSizeThreshold = ObjectUtil.checkPositiveOrZero(n4, "contentSizeThreshold");
        this.brotliOptions = null;
        this.gzipOptions = null;
        this.deflateOptions = null;
        this.zstdOptions = null;
        this.factories = null;
        this.supportsCompressionOptions = false;
    }

    public HttpContentCompressor(CompressionOptions ... compressionOptionsArray) {
        this(0, compressionOptionsArray);
    }

    public HttpContentCompressor(int n, CompressionOptions ... compressionOptionsArray) {
        this.contentSizeThreshold = ObjectUtil.checkPositiveOrZero(n, "contentSizeThreshold");
        BrotliOptions brotliOptions = null;
        GzipOptions gzipOptions = null;
        DeflateOptions deflateOptions = null;
        ZstdOptions zstdOptions = null;
        if (compressionOptionsArray == null || compressionOptionsArray.length == 0) {
            brotliOptions = Brotli.isAvailable() ? StandardCompressionOptions.brotli() : null;
            gzipOptions = StandardCompressionOptions.gzip();
            deflateOptions = StandardCompressionOptions.deflate();
            zstdOptions = Zstd.isAvailable() ? StandardCompressionOptions.zstd() : null;
        } else {
            ObjectUtil.deepCheckNotNull("compressionOptions", compressionOptionsArray);
            for (CompressionOptions compressionOptions : compressionOptionsArray) {
                if (compressionOptions instanceof BrotliOptions) {
                    brotliOptions = (BrotliOptions)compressionOptions;
                    continue;
                }
                if (compressionOptions instanceof GzipOptions) {
                    gzipOptions = (GzipOptions)compressionOptions;
                    continue;
                }
                if (compressionOptions instanceof DeflateOptions) {
                    deflateOptions = (DeflateOptions)compressionOptions;
                    continue;
                }
                if (compressionOptions instanceof ZstdOptions) {
                    zstdOptions = (ZstdOptions)compressionOptions;
                    continue;
                }
                throw new IllegalArgumentException("Unsupported " + CompressionOptions.class.getSimpleName() + ": " + compressionOptions);
            }
        }
        this.gzipOptions = gzipOptions;
        this.deflateOptions = deflateOptions;
        this.brotliOptions = brotliOptions;
        this.zstdOptions = zstdOptions;
        this.factories = new HashMap<String, CompressionEncoderFactory>();
        if (this.gzipOptions != null) {
            this.factories.put("gzip", new HttpContentCompressor$GzipEncoderFactory(this));
        }
        if (this.deflateOptions != null) {
            this.factories.put("deflate", new HttpContentCompressor$DeflateEncoderFactory(this, null));
        }
        if (this.brotliOptions != null) {
            this.factories.put("br", new HttpContentCompressor$BrEncoderFactory(this, null));
        }
        if (this.zstdOptions != null) {
            this.factories.put("zstd", new HttpContentCompressor$ZstdEncoderFactory(this, null));
        }
        this.compressionLevel = -1;
        this.windowBits = -1;
        this.memLevel = -1;
        this.supportsCompressionOptions = true;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
    }

    @Override
    protected HttpContentEncoder$Result beginEncode(HttpResponse httpResponse, String string) {
        String string2;
        if (this.contentSizeThreshold > 0 && httpResponse instanceof HttpContent && ((HttpContent)((Object)httpResponse)).content().readableBytes() < this.contentSizeThreshold) {
            return null;
        }
        String string3 = httpResponse.headers().get(HttpHeaderNames.CONTENT_ENCODING);
        if (string3 != null) {
            return null;
        }
        if (this.supportsCompressionOptions) {
            String string4 = this.determineEncoding(string);
            if (string4 == null) {
                return null;
            }
            CompressionEncoderFactory compressionEncoderFactory = this.factories.get(string4);
            if (compressionEncoderFactory == null) {
                throw new Error();
            }
            return new HttpContentEncoder$Result(string4, new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), compressionEncoderFactory.createEncoder()));
        }
        ZlibWrapper zlibWrapper = this.determineWrapper(string);
        if (zlibWrapper == null) {
            return null;
        }
        switch (zlibWrapper) {
            case GZIP: {
                string2 = "gzip";
                break;
            }
            case ZLIB: {
                string2 = "deflate";
                break;
            }
            default: {
                throw new Error();
            }
        }
        return new HttpContentEncoder$Result(string2, new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), ZlibCodecFactory.newZlibEncoder(zlibWrapper, this.compressionLevel, this.windowBits, this.memLevel)));
    }

    protected String determineEncoding(String string) {
        float f = -1.0f;
        float f2 = -1.0f;
        float f3 = -1.0f;
        float f4 = -1.0f;
        float f5 = -1.0f;
        for (String string2 : string.split(",")) {
            float f6 = 1.0f;
            int n = string2.indexOf(61);
            if (n != -1) {
                try {
                    f6 = Float.parseFloat(string2.substring(n + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    f6 = 0.0f;
                }
            }
            if (string2.contains("*")) {
                f = f6;
                continue;
            }
            if (string2.contains("br") && f6 > f2) {
                f2 = f6;
                continue;
            }
            if (string2.contains("zstd") && f6 > f3) {
                f3 = f6;
                continue;
            }
            if (string2.contains("gzip") && f6 > f4) {
                f4 = f6;
                continue;
            }
            if (!string2.contains("deflate") || !(f6 > f5)) continue;
            f5 = f6;
        }
        if (f2 > 0.0f || f3 > 0.0f || f4 > 0.0f || f5 > 0.0f) {
            if (f2 != -1.0f && f2 >= f3 && this.brotliOptions != null) {
                return "br";
            }
            if (f3 != -1.0f && f3 >= f4 && this.zstdOptions != null) {
                return "zstd";
            }
            if (f4 != -1.0f && f4 >= f5 && this.gzipOptions != null) {
                return "gzip";
            }
            if (f5 != -1.0f && this.deflateOptions != null) {
                return "deflate";
            }
        }
        if (f > 0.0f) {
            if (f2 == -1.0f && this.brotliOptions != null) {
                return "br";
            }
            if (f3 == -1.0f && this.zstdOptions != null) {
                return "zstd";
            }
            if (f4 == -1.0f && this.gzipOptions != null) {
                return "gzip";
            }
            if (f5 == -1.0f && this.deflateOptions != null) {
                return "deflate";
            }
        }
        return null;
    }

    @Deprecated
    protected ZlibWrapper determineWrapper(String string) {
        float f = -1.0f;
        float f2 = -1.0f;
        float f3 = -1.0f;
        for (String string2 : string.split(",")) {
            float f4 = 1.0f;
            int n = string2.indexOf(61);
            if (n != -1) {
                try {
                    f4 = Float.parseFloat(string2.substring(n + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    f4 = 0.0f;
                }
            }
            if (string2.contains("*")) {
                f = f4;
                continue;
            }
            if (string2.contains("gzip") && f4 > f2) {
                f2 = f4;
                continue;
            }
            if (!string2.contains("deflate") || !(f4 > f3)) continue;
            f3 = f4;
        }
        if (f2 > 0.0f || f3 > 0.0f) {
            if (f2 >= f3) {
                return ZlibWrapper.GZIP;
            }
            return ZlibWrapper.ZLIB;
        }
        if (f > 0.0f) {
            if (f2 == -1.0f) {
                return ZlibWrapper.GZIP;
            }
            if (f3 == -1.0f) {
                return ZlibWrapper.ZLIB;
            }
        }
        return null;
    }

    static /* synthetic */ GzipOptions access$400(HttpContentCompressor httpContentCompressor) {
        return httpContentCompressor.gzipOptions;
    }

    static /* synthetic */ DeflateOptions access$500(HttpContentCompressor httpContentCompressor) {
        return httpContentCompressor.deflateOptions;
    }

    static /* synthetic */ BrotliOptions access$600(HttpContentCompressor httpContentCompressor) {
        return httpContentCompressor.brotliOptions;
    }

    static /* synthetic */ ZstdOptions access$700(HttpContentCompressor httpContentCompressor) {
        return httpContentCompressor.zstdOptions;
    }
}

