/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http;

import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.handler.codec.TooLongFrameException;
import pro.gravit.repackage.io.netty.util.ByteProcessor;
import pro.gravit.repackage.io.netty.util.internal.AppendableCharSequence;

class HttpObjectDecoder$HeaderParser
implements ByteProcessor {
    private final AppendableCharSequence seq;
    private final int maxLength;
    int size;

    HttpObjectDecoder$HeaderParser(AppendableCharSequence appendableCharSequence, int n) {
        this.seq = appendableCharSequence;
        this.maxLength = n;
    }

    public AppendableCharSequence parse(ByteBuf byteBuf) {
        int n = this.size;
        this.seq.reset();
        int n2 = byteBuf.forEachByte(this);
        if (n2 == -1) {
            this.size = n;
            return null;
        }
        byteBuf.readerIndex(n2 + 1);
        return this.seq;
    }

    public void reset() {
        this.size = 0;
    }

    @Override
    public boolean process(byte by) {
        char c = (char)(by & 0xFF);
        if (c == '\n') {
            int n = this.seq.length();
            if (n >= 1 && this.seq.charAtUnsafe(n - 1) == '\r') {
                --this.size;
                this.seq.setLength(n - 1);
            }
            return false;
        }
        this.increaseCount();
        this.seq.append(c);
        return true;
    }

    protected final void increaseCount() {
        if (++this.size > this.maxLength) {
            throw this.newException(this.maxLength);
        }
    }

    protected TooLongFrameException newException(int n) {
        return new TooLongFrameException("HTTP header is larger than " + n + " bytes.");
    }
}

