/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http;

import java.util.List;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.Unpooled;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.handler.codec.ByteToMessageDecoder;
import pro.gravit.repackage.io.netty.handler.codec.DecoderResult;
import pro.gravit.repackage.io.netty.handler.codec.PrematureChannelClosureException;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultHttpContent;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultLastHttpContent;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpContent;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpExpectationFailedEvent;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderNames;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderValues;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaders;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpMessage;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpMessageDecoderResult;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpObjectDecoder$1;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpObjectDecoder$HeaderParser;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpObjectDecoder$LineParser;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpObjectDecoder$State;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpResponseStatus;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpUtil;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpVersion;
import pro.gravit.repackage.io.netty.handler.codec.http.LastHttpContent;
import pro.gravit.repackage.io.netty.util.internal.AppendableCharSequence;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public abstract class HttpObjectDecoder
extends ByteToMessageDecoder {
    public static final int DEFAULT_MAX_INITIAL_LINE_LENGTH = 4096;
    public static final int DEFAULT_MAX_HEADER_SIZE = 8192;
    public static final boolean DEFAULT_CHUNKED_SUPPORTED = true;
    public static final boolean DEFAULT_ALLOW_PARTIAL_CHUNKS = true;
    public static final int DEFAULT_MAX_CHUNK_SIZE = 8192;
    public static final boolean DEFAULT_VALIDATE_HEADERS = true;
    public static final int DEFAULT_INITIAL_BUFFER_SIZE = 128;
    public static final boolean DEFAULT_ALLOW_DUPLICATE_CONTENT_LENGTHS = false;
    private static final String EMPTY_VALUE = "";
    private final int maxChunkSize;
    private final boolean chunkedSupported;
    private final boolean allowPartialChunks;
    protected final boolean validateHeaders;
    private final boolean allowDuplicateContentLengths;
    private final HttpObjectDecoder$HeaderParser headerParser;
    private final HttpObjectDecoder$LineParser lineParser;
    private HttpMessage message;
    private long chunkSize;
    private long contentLength = Long.MIN_VALUE;
    private volatile boolean resetRequested;
    private CharSequence name;
    private CharSequence value;
    private LastHttpContent trailer;
    private HttpObjectDecoder$State currentState = HttpObjectDecoder$State.SKIP_CONTROL_CHARS;

    protected HttpObjectDecoder() {
        this(4096, 8192, 8192, true);
    }

    protected HttpObjectDecoder(int n, int n2, int n3, boolean bl) {
        this(n, n2, n3, bl, true);
    }

    protected HttpObjectDecoder(int n, int n2, int n3, boolean bl, boolean bl2) {
        this(n, n2, n3, bl, bl2, 128);
    }

    protected HttpObjectDecoder(int n, int n2, int n3, boolean bl, boolean bl2, int n4) {
        this(n, n2, n3, bl, bl2, n4, false);
    }

    protected HttpObjectDecoder(int n, int n2, int n3, boolean bl, boolean bl2, int n4, boolean bl3) {
        this(n, n2, n3, bl, bl2, n4, bl3, true);
    }

    protected HttpObjectDecoder(int n, int n2, int n3, boolean bl, boolean bl2, int n4, boolean bl3, boolean bl4) {
        ObjectUtil.checkPositive(n, "maxInitialLineLength");
        ObjectUtil.checkPositive(n2, "maxHeaderSize");
        ObjectUtil.checkPositive(n3, "maxChunkSize");
        AppendableCharSequence appendableCharSequence = new AppendableCharSequence(n4);
        this.lineParser = new HttpObjectDecoder$LineParser(this, appendableCharSequence, n);
        this.headerParser = new HttpObjectDecoder$HeaderParser(appendableCharSequence, n2);
        this.maxChunkSize = n3;
        this.chunkedSupported = bl;
        this.validateHeaders = bl2;
        this.allowDuplicateContentLengths = bl3;
        this.allowPartialChunks = bl4;
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (this.resetRequested) {
            this.resetNow();
        }
        switch (this.currentState) {
            case SKIP_CONTROL_CHARS: 
            case READ_INITIAL: {
                Object object;
                try {
                    object = this.lineParser.parse(byteBuf);
                    if (object == null) {
                        return;
                    }
                    String[] stringArray = HttpObjectDecoder.splitInitialLine((AppendableCharSequence)object);
                    if (stringArray.length < 3) {
                        this.currentState = HttpObjectDecoder$State.SKIP_CONTROL_CHARS;
                        return;
                    }
                    this.message = this.createMessage(stringArray);
                    this.currentState = HttpObjectDecoder$State.READ_HEADER;
                }
                catch (Exception exception) {
                    list.add(this.invalidMessage(byteBuf, exception));
                    return;
                }
            }
            case READ_HEADER: {
                Object object;
                try {
                    object = this.readHeaders(byteBuf);
                    if (object == null) {
                        return;
                    }
                    this.currentState = object;
                    switch (HttpObjectDecoder$1.$SwitchMap$io$netty$handler$codec$http$HttpObjectDecoder$State[((Enum)object).ordinal()]) {
                        case 1: {
                            list.add(this.message);
                            list.add(LastHttpContent.EMPTY_LAST_CONTENT);
                            this.resetNow();
                            return;
                        }
                        case 2: {
                            if (!this.chunkedSupported) {
                                throw new IllegalArgumentException("Chunked messages not supported");
                            }
                            list.add(this.message);
                            return;
                        }
                    }
                    long l = this.contentLength();
                    if (l == 0L || l == -1L && this.isDecodingRequest()) {
                        list.add(this.message);
                        list.add(LastHttpContent.EMPTY_LAST_CONTENT);
                        this.resetNow();
                        return;
                    }
                    assert (object == HttpObjectDecoder$State.READ_FIXED_LENGTH_CONTENT || object == HttpObjectDecoder$State.READ_VARIABLE_LENGTH_CONTENT);
                    list.add(this.message);
                    if (object == HttpObjectDecoder$State.READ_FIXED_LENGTH_CONTENT) {
                        this.chunkSize = l;
                    }
                    return;
                }
                catch (Exception exception) {
                    list.add(this.invalidMessage(byteBuf, exception));
                    return;
                }
            }
            case READ_VARIABLE_LENGTH_CONTENT: {
                int n = Math.min(byteBuf.readableBytes(), this.maxChunkSize);
                if (n > 0) {
                    ByteBuf byteBuf2 = byteBuf.readRetainedSlice(n);
                    list.add(new DefaultHttpContent(byteBuf2));
                }
                return;
            }
            case READ_FIXED_LENGTH_CONTENT: {
                int n = byteBuf.readableBytes();
                if (n == 0) {
                    return;
                }
                int n2 = Math.min(n, this.maxChunkSize);
                if ((long)n2 > this.chunkSize) {
                    n2 = (int)this.chunkSize;
                }
                ByteBuf byteBuf3 = byteBuf.readRetainedSlice(n2);
                this.chunkSize -= (long)n2;
                if (this.chunkSize == 0L) {
                    list.add(new DefaultLastHttpContent(byteBuf3, this.validateHeaders));
                    this.resetNow();
                } else {
                    list.add(new DefaultHttpContent(byteBuf3));
                }
                return;
            }
            case READ_CHUNK_SIZE: {
                try {
                    AppendableCharSequence appendableCharSequence = this.lineParser.parse(byteBuf);
                    if (appendableCharSequence == null) {
                        return;
                    }
                    int n = HttpObjectDecoder.getChunkSize(appendableCharSequence.toString());
                    this.chunkSize = n;
                    if (n == 0) {
                        this.currentState = HttpObjectDecoder$State.READ_CHUNK_FOOTER;
                        return;
                    }
                    this.currentState = HttpObjectDecoder$State.READ_CHUNKED_CONTENT;
                }
                catch (Exception exception) {
                    list.add(this.invalidChunk(byteBuf, exception));
                    return;
                }
            }
            case READ_CHUNKED_CONTENT: {
                assert (this.chunkSize <= Integer.MAX_VALUE);
                int n = Math.min((int)this.chunkSize, this.maxChunkSize);
                if (!this.allowPartialChunks && byteBuf.readableBytes() < n) {
                    return;
                }
                if ((n = Math.min(n, byteBuf.readableBytes())) == 0) {
                    return;
                }
                DefaultHttpContent defaultHttpContent = new DefaultHttpContent(byteBuf.readRetainedSlice(n));
                this.chunkSize -= (long)n;
                list.add(defaultHttpContent);
                if (this.chunkSize != 0L) {
                    return;
                }
                this.currentState = HttpObjectDecoder$State.READ_CHUNK_DELIMITER;
            }
            case READ_CHUNK_DELIMITER: {
                int n = byteBuf.writerIndex();
                int n3 = byteBuf.readerIndex();
                while (n > n3) {
                    byte by;
                    if ((by = byteBuf.getByte(n3++)) != 10) continue;
                    this.currentState = HttpObjectDecoder$State.READ_CHUNK_SIZE;
                    break;
                }
                byteBuf.readerIndex(n3);
                return;
            }
            case READ_CHUNK_FOOTER: {
                try {
                    LastHttpContent lastHttpContent = this.readTrailingHeaders(byteBuf);
                    if (lastHttpContent == null) {
                        return;
                    }
                    list.add(lastHttpContent);
                    this.resetNow();
                    return;
                }
                catch (Exception exception) {
                    list.add(this.invalidChunk(byteBuf, exception));
                    return;
                }
            }
            case BAD_MESSAGE: {
                byteBuf.skipBytes(byteBuf.readableBytes());
                break;
            }
            case UPGRADED: {
                int n = byteBuf.readableBytes();
                if (n <= 0) break;
                list.add(byteBuf.readBytes(n));
                break;
            }
        }
    }

    @Override
    protected void decodeLast(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        super.decodeLast(channelHandlerContext, byteBuf, list);
        if (this.resetRequested) {
            this.resetNow();
        }
        if (this.message != null) {
            boolean bl;
            boolean bl2 = HttpUtil.isTransferEncodingChunked(this.message);
            if (this.currentState == HttpObjectDecoder$State.READ_VARIABLE_LENGTH_CONTENT && !byteBuf.isReadable() && !bl2) {
                list.add(LastHttpContent.EMPTY_LAST_CONTENT);
                this.resetNow();
                return;
            }
            if (this.currentState == HttpObjectDecoder$State.READ_HEADER) {
                list.add(this.invalidMessage(Unpooled.EMPTY_BUFFER, new PrematureChannelClosureException("Connection closed before received headers")));
                this.resetNow();
                return;
            }
            if (this.isDecodingRequest() || bl2) {
                bl = true;
            } else {
                boolean bl3 = bl = this.contentLength() > 0L;
            }
            if (!bl) {
                list.add(LastHttpContent.EMPTY_LAST_CONTENT);
            }
            this.resetNow();
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object instanceof HttpExpectationFailedEvent) {
            switch (this.currentState) {
                case READ_CHUNK_SIZE: 
                case READ_VARIABLE_LENGTH_CONTENT: 
                case READ_FIXED_LENGTH_CONTENT: {
                    this.reset();
                    break;
                }
            }
        }
        super.userEventTriggered(channelHandlerContext, object);
    }

    protected boolean isContentAlwaysEmpty(HttpMessage httpMessage) {
        if (httpMessage instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)httpMessage;
            int n = httpResponse.status().code();
            if (n >= 100 && n < 200) {
                return n != 101 || httpResponse.headers().contains(HttpHeaderNames.SEC_WEBSOCKET_ACCEPT) || !httpResponse.headers().contains(HttpHeaderNames.UPGRADE, HttpHeaderValues.WEBSOCKET, true);
            }
            switch (n) {
                case 204: 
                case 304: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    protected boolean isSwitchingToNonHttp1Protocol(HttpResponse httpResponse) {
        if (httpResponse.status().code() != HttpResponseStatus.SWITCHING_PROTOCOLS.code()) {
            return false;
        }
        String string = httpResponse.headers().get(HttpHeaderNames.UPGRADE);
        return string == null || !string.contains(HttpVersion.HTTP_1_0.text()) && !string.contains(HttpVersion.HTTP_1_1.text());
    }

    public void reset() {
        this.resetRequested = true;
    }

    private void resetNow() {
        HttpResponse httpResponse;
        HttpMessage httpMessage = this.message;
        this.message = null;
        this.name = null;
        this.value = null;
        this.contentLength = Long.MIN_VALUE;
        this.lineParser.reset();
        this.headerParser.reset();
        this.trailer = null;
        if (!this.isDecodingRequest() && (httpResponse = (HttpResponse)httpMessage) != null && this.isSwitchingToNonHttp1Protocol(httpResponse)) {
            this.currentState = HttpObjectDecoder$State.UPGRADED;
            return;
        }
        this.resetRequested = false;
        this.currentState = HttpObjectDecoder$State.SKIP_CONTROL_CHARS;
    }

    private HttpMessage invalidMessage(ByteBuf byteBuf, Exception exception) {
        this.currentState = HttpObjectDecoder$State.BAD_MESSAGE;
        byteBuf.skipBytes(byteBuf.readableBytes());
        if (this.message == null) {
            this.message = this.createInvalidMessage();
        }
        this.message.setDecoderResult(DecoderResult.failure(exception));
        HttpMessage httpMessage = this.message;
        this.message = null;
        return httpMessage;
    }

    private HttpContent invalidChunk(ByteBuf byteBuf, Exception exception) {
        this.currentState = HttpObjectDecoder$State.BAD_MESSAGE;
        byteBuf.skipBytes(byteBuf.readableBytes());
        DefaultLastHttpContent defaultLastHttpContent = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER);
        defaultLastHttpContent.setDecoderResult(DecoderResult.failure(exception));
        this.message = null;
        this.trailer = null;
        return defaultLastHttpContent;
    }

    private HttpObjectDecoder$State readHeaders(ByteBuf byteBuf) {
        Object object;
        Object object2;
        HttpMessage httpMessage = this.message;
        HttpHeaders httpHeaders = httpMessage.headers();
        AppendableCharSequence appendableCharSequence = this.headerParser.parse(byteBuf);
        if (appendableCharSequence == null) {
            return null;
        }
        if (appendableCharSequence.length() > 0) {
            do {
                char c = appendableCharSequence.charAtUnsafe(0);
                if (this.name != null && (c == ' ' || c == '\t')) {
                    object2 = appendableCharSequence.toString().trim();
                    object = String.valueOf(this.value);
                    this.value = (String)object + ' ' + (String)object2;
                } else {
                    if (this.name != null) {
                        httpHeaders.add(this.name, (Object)this.value);
                    }
                    this.splitHeader(appendableCharSequence);
                }
                appendableCharSequence = this.headerParser.parse(byteBuf);
                if (appendableCharSequence != null) continue;
                return null;
            } while (appendableCharSequence.length() > 0);
        }
        if (this.name != null) {
            httpHeaders.add(this.name, (Object)this.value);
        }
        this.name = null;
        this.value = null;
        HttpMessageDecoderResult httpMessageDecoderResult = new HttpMessageDecoderResult(this.lineParser.size, this.headerParser.size);
        httpMessage.setDecoderResult(httpMessageDecoderResult);
        object2 = httpHeaders.getAll(HttpHeaderNames.CONTENT_LENGTH);
        if (!object2.isEmpty()) {
            object = httpMessage.protocolVersion();
            boolean bl = ((HttpVersion)object).majorVersion() < 1 || ((HttpVersion)object).majorVersion() == 1 && ((HttpVersion)object).minorVersion() == 0;
            this.contentLength = HttpUtil.normalizeAndGetContentLength((List<? extends CharSequence>)object2, bl, this.allowDuplicateContentLengths);
            if (this.contentLength != -1L) {
                httpHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)this.contentLength);
            }
        }
        if (this.isContentAlwaysEmpty(httpMessage)) {
            HttpUtil.setTransferEncodingChunked(httpMessage, false);
            return HttpObjectDecoder$State.SKIP_CONTROL_CHARS;
        }
        if (HttpUtil.isTransferEncodingChunked(httpMessage)) {
            if (!object2.isEmpty() && httpMessage.protocolVersion() == HttpVersion.HTTP_1_1) {
                this.handleTransferEncodingChunkedWithContentLength(httpMessage);
            }
            return HttpObjectDecoder$State.READ_CHUNK_SIZE;
        }
        if (this.contentLength() >= 0L) {
            return HttpObjectDecoder$State.READ_FIXED_LENGTH_CONTENT;
        }
        return HttpObjectDecoder$State.READ_VARIABLE_LENGTH_CONTENT;
    }

    protected void handleTransferEncodingChunkedWithContentLength(HttpMessage httpMessage) {
        httpMessage.headers().remove(HttpHeaderNames.CONTENT_LENGTH);
        this.contentLength = Long.MIN_VALUE;
    }

    private long contentLength() {
        if (this.contentLength == Long.MIN_VALUE) {
            this.contentLength = HttpUtil.getContentLength(this.message, -1L);
        }
        return this.contentLength;
    }

    private LastHttpContent readTrailingHeaders(ByteBuf byteBuf) {
        AppendableCharSequence appendableCharSequence = this.headerParser.parse(byteBuf);
        if (appendableCharSequence == null) {
            return null;
        }
        LastHttpContent lastHttpContent = this.trailer;
        if (appendableCharSequence.length() == 0 && lastHttpContent == null) {
            return LastHttpContent.EMPTY_LAST_CONTENT;
        }
        CharSequence charSequence = null;
        if (lastHttpContent == null) {
            lastHttpContent = this.trailer = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER, this.validateHeaders);
        }
        while (appendableCharSequence.length() > 0) {
            List<String> list;
            char c = appendableCharSequence.charAtUnsafe(0);
            if (charSequence != null && (c == ' ' || c == '\t')) {
                list = lastHttpContent.trailingHeaders().getAll(charSequence);
                if (!list.isEmpty()) {
                    int n = list.size() - 1;
                    String string = appendableCharSequence.toString().trim();
                    String string2 = (String)list.get(n);
                    list.set(n, string2 + string);
                }
            } else {
                this.splitHeader(appendableCharSequence);
                list = this.name;
                if (!(HttpHeaderNames.CONTENT_LENGTH.contentEqualsIgnoreCase((CharSequence)((Object)list)) || HttpHeaderNames.TRANSFER_ENCODING.contentEqualsIgnoreCase((CharSequence)((Object)list)) || HttpHeaderNames.TRAILER.contentEqualsIgnoreCase((CharSequence)((Object)list)))) {
                    lastHttpContent.trailingHeaders().add((CharSequence)((Object)list), (Object)this.value);
                }
                charSequence = this.name;
                this.name = null;
                this.value = null;
            }
            if ((appendableCharSequence = this.headerParser.parse(byteBuf)) != null) continue;
            return null;
        }
        this.trailer = null;
        return lastHttpContent;
    }

    protected abstract boolean isDecodingRequest();

    protected abstract HttpMessage createMessage(String[] var1);

    protected abstract HttpMessage createInvalidMessage();

    private static int getChunkSize(String string) {
        string = string.trim();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != ';' && !Character.isWhitespace(c) && !Character.isISOControl(c)) continue;
            string = string.substring(0, i);
            break;
        }
        return Integer.parseInt(string, 16);
    }

    private static String[] splitInitialLine(AppendableCharSequence appendableCharSequence) {
        int n = HttpObjectDecoder.findNonSPLenient(appendableCharSequence, 0);
        int n2 = HttpObjectDecoder.findSPLenient(appendableCharSequence, n);
        int n3 = HttpObjectDecoder.findNonSPLenient(appendableCharSequence, n2);
        int n4 = HttpObjectDecoder.findSPLenient(appendableCharSequence, n3);
        int n5 = HttpObjectDecoder.findNonSPLenient(appendableCharSequence, n4);
        int n6 = HttpObjectDecoder.findEndOfString(appendableCharSequence);
        return new String[]{appendableCharSequence.subStringUnsafe(n, n2), appendableCharSequence.subStringUnsafe(n3, n4), n5 < n6 ? appendableCharSequence.subStringUnsafe(n5, n6) : EMPTY_VALUE};
    }

    private void splitHeader(AppendableCharSequence appendableCharSequence) {
        int n;
        int n2;
        char c;
        int n3;
        int n4 = appendableCharSequence.length();
        for (n3 = n2 = HttpObjectDecoder.findNonWhitespace(appendableCharSequence, 0, false); n3 < n4 && (c = appendableCharSequence.charAtUnsafe(n3)) != ':' && (this.isDecodingRequest() || !HttpObjectDecoder.isOWS(c)); ++n3) {
        }
        if (n3 == n4) {
            throw new IllegalArgumentException("No colon found");
        }
        for (n = n3; n < n4; ++n) {
            if (appendableCharSequence.charAtUnsafe(n) != ':') continue;
            ++n;
            break;
        }
        this.name = appendableCharSequence.subStringUnsafe(n2, n3);
        int n5 = HttpObjectDecoder.findNonWhitespace(appendableCharSequence, n, true);
        if (n5 == n4) {
            this.value = EMPTY_VALUE;
        } else {
            int n6 = HttpObjectDecoder.findEndOfString(appendableCharSequence);
            this.value = appendableCharSequence.subStringUnsafe(n5, n6);
        }
    }

    private static int findNonSPLenient(AppendableCharSequence appendableCharSequence, int n) {
        for (int i = n; i < appendableCharSequence.length(); ++i) {
            char c = appendableCharSequence.charAtUnsafe(i);
            if (HttpObjectDecoder.isSPLenient(c)) continue;
            if (Character.isWhitespace(c)) {
                throw new IllegalArgumentException("Invalid separator");
            }
            return i;
        }
        return appendableCharSequence.length();
    }

    private static int findSPLenient(AppendableCharSequence appendableCharSequence, int n) {
        for (int i = n; i < appendableCharSequence.length(); ++i) {
            if (!HttpObjectDecoder.isSPLenient(appendableCharSequence.charAtUnsafe(i))) continue;
            return i;
        }
        return appendableCharSequence.length();
    }

    private static boolean isSPLenient(char c) {
        return c == ' ' || c == '\t' || c == '\u000b' || c == '\f' || c == '\r';
    }

    private static int findNonWhitespace(AppendableCharSequence appendableCharSequence, int n, boolean bl) {
        for (int i = n; i < appendableCharSequence.length(); ++i) {
            char c = appendableCharSequence.charAtUnsafe(i);
            if (!Character.isWhitespace(c)) {
                return i;
            }
            if (!bl || HttpObjectDecoder.isOWS(c)) continue;
            throw new IllegalArgumentException("Invalid separator, only a single space or horizontal tab allowed, but received a '" + c + "' (0x" + Integer.toHexString(c) + ")");
        }
        return appendableCharSequence.length();
    }

    private static int findEndOfString(AppendableCharSequence appendableCharSequence) {
        for (int i = appendableCharSequence.length() - 1; i > 0; --i) {
            if (Character.isWhitespace(appendableCharSequence.charAtUnsafe(i))) continue;
            return i + 1;
        }
        return 0;
    }

    private static boolean isOWS(char c) {
        return c == ' ' || c == '\t';
    }

    static /* synthetic */ HttpObjectDecoder$State access$000(HttpObjectDecoder httpObjectDecoder) {
        return httpObjectDecoder.currentState;
    }

    static /* synthetic */ HttpObjectDecoder$State access$002(HttpObjectDecoder httpObjectDecoder, HttpObjectDecoder$State httpObjectDecoder$State) {
        httpObjectDecoder.currentState = httpObjectDecoder$State;
        return httpObjectDecoder.currentState;
    }
}

