/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http;

import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderNames;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderValues;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaders;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpMessage;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpMethod;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpVersion;
import pro.gravit.repackage.io.netty.util.AsciiString;
import pro.gravit.repackage.io.netty.util.CharsetUtil;
import pro.gravit.repackage.io.netty.util.NetUtil;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public final class HttpUtil {
    private static final AsciiString CHARSET_EQUALS = AsciiString.of(HttpHeaderValues.CHARSET + "=");
    private static final AsciiString SEMICOLON = AsciiString.cached(";");
    private static final String COMMA_STRING = String.valueOf(',');

    private HttpUtil() {
    }

    public static boolean isOriginForm(URI uRI) {
        return uRI.getScheme() == null && uRI.getSchemeSpecificPart() == null && uRI.getHost() == null && uRI.getAuthority() == null;
    }

    public static boolean isAsteriskForm(URI uRI) {
        return "*".equals(uRI.getPath()) && uRI.getScheme() == null && uRI.getSchemeSpecificPart() == null && uRI.getHost() == null && uRI.getAuthority() == null && uRI.getQuery() == null && uRI.getFragment() == null;
    }

    public static boolean isKeepAlive(HttpMessage httpMessage) {
        return !httpMessage.headers().containsValue(HttpHeaderNames.CONNECTION, HttpHeaderValues.CLOSE, true) && (httpMessage.protocolVersion().isKeepAliveDefault() || httpMessage.headers().containsValue(HttpHeaderNames.CONNECTION, HttpHeaderValues.KEEP_ALIVE, true));
    }

    public static void setKeepAlive(HttpMessage httpMessage, boolean bl) {
        HttpUtil.setKeepAlive(httpMessage.headers(), httpMessage.protocolVersion(), bl);
    }

    public static void setKeepAlive(HttpHeaders httpHeaders, HttpVersion httpVersion, boolean bl) {
        if (httpVersion.isKeepAliveDefault()) {
            if (bl) {
                httpHeaders.remove(HttpHeaderNames.CONNECTION);
            } else {
                httpHeaders.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            }
        } else if (bl) {
            httpHeaders.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        } else {
            httpHeaders.remove(HttpHeaderNames.CONNECTION);
        }
    }

    public static long getContentLength(HttpMessage httpMessage) {
        String string = httpMessage.headers().get(HttpHeaderNames.CONTENT_LENGTH);
        if (string != null) {
            return Long.parseLong(string);
        }
        long l = HttpUtil.getWebSocketContentLength(httpMessage);
        if (l >= 0L) {
            return l;
        }
        throw new NumberFormatException("header not found: " + HttpHeaderNames.CONTENT_LENGTH);
    }

    public static long getContentLength(HttpMessage httpMessage, long l) {
        String string = httpMessage.headers().get(HttpHeaderNames.CONTENT_LENGTH);
        if (string != null) {
            return Long.parseLong(string);
        }
        long l2 = HttpUtil.getWebSocketContentLength(httpMessage);
        if (l2 >= 0L) {
            return l2;
        }
        return l;
    }

    public static int getContentLength(HttpMessage httpMessage, int n) {
        return (int)Math.min(Integer.MAX_VALUE, HttpUtil.getContentLength(httpMessage, (long)n));
    }

    private static int getWebSocketContentLength(HttpMessage httpMessage) {
        HttpResponse httpResponse;
        HttpHeaders httpHeaders = httpMessage.headers();
        if (httpMessage instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)httpMessage;
            if (HttpMethod.GET.equals(httpRequest.method()) && httpHeaders.contains(HttpHeaderNames.SEC_WEBSOCKET_KEY1) && httpHeaders.contains(HttpHeaderNames.SEC_WEBSOCKET_KEY2)) {
                return 8;
            }
        } else if (httpMessage instanceof HttpResponse && (httpResponse = (HttpResponse)httpMessage).status().code() == 101 && httpHeaders.contains(HttpHeaderNames.SEC_WEBSOCKET_ORIGIN) && httpHeaders.contains(HttpHeaderNames.SEC_WEBSOCKET_LOCATION)) {
            return 16;
        }
        return -1;
    }

    public static void setContentLength(HttpMessage httpMessage, long l) {
        httpMessage.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)l);
    }

    public static boolean isContentLengthSet(HttpMessage httpMessage) {
        return httpMessage.headers().contains(HttpHeaderNames.CONTENT_LENGTH);
    }

    public static boolean is100ContinueExpected(HttpMessage httpMessage) {
        return HttpUtil.isExpectHeaderValid(httpMessage) && httpMessage.headers().contains(HttpHeaderNames.EXPECT, HttpHeaderValues.CONTINUE, true);
    }

    static boolean isUnsupportedExpectation(HttpMessage httpMessage) {
        if (!HttpUtil.isExpectHeaderValid(httpMessage)) {
            return false;
        }
        String string = httpMessage.headers().get(HttpHeaderNames.EXPECT);
        return string != null && !HttpHeaderValues.CONTINUE.toString().equalsIgnoreCase(string);
    }

    private static boolean isExpectHeaderValid(HttpMessage httpMessage) {
        return httpMessage instanceof HttpRequest && httpMessage.protocolVersion().compareTo(HttpVersion.HTTP_1_1) >= 0;
    }

    public static void set100ContinueExpected(HttpMessage httpMessage, boolean bl) {
        if (bl) {
            httpMessage.headers().set((CharSequence)HttpHeaderNames.EXPECT, (Object)HttpHeaderValues.CONTINUE);
        } else {
            httpMessage.headers().remove(HttpHeaderNames.EXPECT);
        }
    }

    public static boolean isTransferEncodingChunked(HttpMessage httpMessage) {
        return httpMessage.headers().containsValue(HttpHeaderNames.TRANSFER_ENCODING, HttpHeaderValues.CHUNKED, true);
    }

    public static void setTransferEncodingChunked(HttpMessage httpMessage, boolean bl) {
        if (bl) {
            httpMessage.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            httpMessage.headers().remove(HttpHeaderNames.CONTENT_LENGTH);
        } else {
            List<String> list = httpMessage.headers().getAll(HttpHeaderNames.TRANSFER_ENCODING);
            if (list.isEmpty()) {
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>(list);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                CharSequence charSequence = (CharSequence)iterator.next();
                if (!HttpHeaderValues.CHUNKED.contentEqualsIgnoreCase(charSequence)) continue;
                iterator.remove();
            }
            if (arrayList.isEmpty()) {
                httpMessage.headers().remove(HttpHeaderNames.TRANSFER_ENCODING);
            } else {
                httpMessage.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, arrayList);
            }
        }
    }

    public static Charset getCharset(HttpMessage httpMessage) {
        return HttpUtil.getCharset(httpMessage, CharsetUtil.ISO_8859_1);
    }

    public static Charset getCharset(CharSequence charSequence) {
        if (charSequence != null) {
            return HttpUtil.getCharset(charSequence, CharsetUtil.ISO_8859_1);
        }
        return CharsetUtil.ISO_8859_1;
    }

    public static Charset getCharset(HttpMessage httpMessage, Charset charset) {
        String string = httpMessage.headers().get(HttpHeaderNames.CONTENT_TYPE);
        if (string != null) {
            return HttpUtil.getCharset(string, charset);
        }
        return charset;
    }

    public static Charset getCharset(CharSequence charSequence, Charset charset) {
        CharSequence charSequence2;
        if (charSequence != null && (charSequence2 = HttpUtil.getCharsetAsSequence(charSequence)) != null) {
            if (charSequence2.length() > 2 && charSequence2.charAt(0) == '\"' && charSequence2.charAt(charSequence2.length() - 1) == '\"') {
                charSequence2 = charSequence2.subSequence(1, charSequence2.length() - 1);
            }
            try {
                return Charset.forName(charSequence2.toString());
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
        return charset;
    }

    @Deprecated
    public static CharSequence getCharsetAsString(HttpMessage httpMessage) {
        return HttpUtil.getCharsetAsSequence(httpMessage);
    }

    public static CharSequence getCharsetAsSequence(HttpMessage httpMessage) {
        String string = httpMessage.headers().get(HttpHeaderNames.CONTENT_TYPE);
        if (string != null) {
            return HttpUtil.getCharsetAsSequence(string);
        }
        return null;
    }

    public static CharSequence getCharsetAsSequence(CharSequence charSequence) {
        ObjectUtil.checkNotNull(charSequence, "contentTypeValue");
        int n = AsciiString.indexOfIgnoreCaseAscii(charSequence, CHARSET_EQUALS, 0);
        if (n == -1) {
            return null;
        }
        int n2 = n + CHARSET_EQUALS.length();
        if (n2 < charSequence.length()) {
            CharSequence charSequence2 = charSequence.subSequence(n2, charSequence.length());
            int n3 = AsciiString.indexOfIgnoreCaseAscii(charSequence2, SEMICOLON, 0);
            if (n3 == -1) {
                return charSequence2;
            }
            return charSequence2.subSequence(0, n3);
        }
        return null;
    }

    public static CharSequence getMimeType(HttpMessage httpMessage) {
        String string = httpMessage.headers().get(HttpHeaderNames.CONTENT_TYPE);
        if (string != null) {
            return HttpUtil.getMimeType(string);
        }
        return null;
    }

    public static CharSequence getMimeType(CharSequence charSequence) {
        ObjectUtil.checkNotNull(charSequence, "contentTypeValue");
        int n = AsciiString.indexOfIgnoreCaseAscii(charSequence, SEMICOLON, 0);
        if (n != -1) {
            return charSequence.subSequence(0, n);
        }
        return charSequence.length() > 0 ? charSequence : null;
    }

    public static String formatHostnameForHttp(InetSocketAddress inetSocketAddress) {
        String string = NetUtil.getHostname(inetSocketAddress);
        if (NetUtil.isValidIpV6Address(string)) {
            if (!inetSocketAddress.isUnresolved()) {
                string = NetUtil.toAddressString(inetSocketAddress.getAddress());
            }
            return '[' + string + ']';
        }
        return string;
    }

    public static long normalizeAndGetContentLength(List<? extends CharSequence> list, boolean bl, boolean bl2) {
        boolean bl3;
        if (list.isEmpty()) {
            return -1L;
        }
        String string = list.get(0).toString();
        boolean bl4 = bl3 = list.size() > 1 || string.indexOf(44) >= 0;
        if (bl3 && !bl) {
            if (bl2) {
                String string2 = null;
                for (CharSequence charSequence : list) {
                    String[] stringArray;
                    for (String string3 : stringArray = charSequence.toString().split(COMMA_STRING, -1)) {
                        String string4 = string3.trim();
                        if (string2 == null) {
                            string2 = string4;
                            continue;
                        }
                        if (string4.equals(string2)) continue;
                        throw new IllegalArgumentException("Multiple Content-Length values found: " + list);
                    }
                }
                string = string2;
            } else {
                throw new IllegalArgumentException("Multiple Content-Length values found: " + list);
            }
        }
        if (string.isEmpty() || !Character.isDigit(string.charAt(0))) {
            throw new IllegalArgumentException("Content-Length value is not a number: " + string);
        }
        try {
            long l = Long.parseLong(string);
            return ObjectUtil.checkPositiveOrZero(l, "Content-Length value");
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Content-Length value is not a number: " + string, numberFormatException);
        }
    }
}

