/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.multipart;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.CompositeByteBuf;
import pro.gravit.repackage.io.netty.buffer.Unpooled;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpConstants;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.AbstractHttpData;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpData;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public abstract class AbstractMemoryHttpData
extends AbstractHttpData {
    private ByteBuf byteBuf = Unpooled.EMPTY_BUFFER;
    private int chunkPosition;

    protected AbstractMemoryHttpData(String string, Charset charset, long l) {
        super(string, charset, l);
    }

    @Override
    public void setContent(ByteBuf byteBuf) {
        ObjectUtil.checkNotNull(byteBuf, "buffer");
        long l = byteBuf.readableBytes();
        try {
            this.checkSize(l);
        }
        catch (IOException iOException) {
            byteBuf.release();
            throw iOException;
        }
        if (this.definedSize > 0L && this.definedSize < l) {
            byteBuf.release();
            throw new IOException("Out of size: " + l + " > " + this.definedSize);
        }
        if (this.byteBuf != null) {
            this.byteBuf.release();
        }
        this.byteBuf = byteBuf;
        this.size = l;
        this.setCompleted();
    }

    @Override
    public void setContent(InputStream inputStream) {
        ObjectUtil.checkNotNull(inputStream, "inputStream");
        byte[] byArray = new byte[16384];
        ByteBuf byteBuf = Unpooled.buffer();
        int n = 0;
        try {
            int n2 = inputStream.read(byArray);
            while (n2 > 0) {
                byteBuf.writeBytes(byArray, 0, n2);
                this.checkSize(n += n2);
                n2 = inputStream.read(byArray);
            }
        }
        catch (IOException iOException) {
            byteBuf.release();
            throw iOException;
        }
        this.size = n;
        if (this.definedSize > 0L && this.definedSize < this.size) {
            byteBuf.release();
            throw new IOException("Out of size: " + this.size + " > " + this.definedSize);
        }
        if (this.byteBuf != null) {
            this.byteBuf.release();
        }
        this.byteBuf = byteBuf;
        this.setCompleted();
    }

    @Override
    public void addContent(ByteBuf byteBuf, boolean bl) {
        if (byteBuf != null) {
            long l = byteBuf.readableBytes();
            try {
                this.checkSize(this.size + l);
            }
            catch (IOException iOException) {
                byteBuf.release();
                throw iOException;
            }
            if (this.definedSize > 0L && this.definedSize < this.size + l) {
                byteBuf.release();
                throw new IOException("Out of size: " + (this.size + l) + " > " + this.definedSize);
            }
            this.size += l;
            if (this.byteBuf == null) {
                this.byteBuf = byteBuf;
            } else if (l == 0L) {
                byteBuf.release();
            } else if (this.byteBuf.readableBytes() == 0) {
                this.byteBuf.release();
                this.byteBuf = byteBuf;
            } else if (this.byteBuf instanceof CompositeByteBuf) {
                CompositeByteBuf compositeByteBuf = (CompositeByteBuf)this.byteBuf;
                compositeByteBuf.addComponent(true, byteBuf);
            } else {
                CompositeByteBuf compositeByteBuf = Unpooled.compositeBuffer(Integer.MAX_VALUE);
                compositeByteBuf.addComponents(true, this.byteBuf, byteBuf);
                this.byteBuf = compositeByteBuf;
            }
        }
        if (bl) {
            this.setCompleted();
        } else {
            ObjectUtil.checkNotNull(byteBuf, "buffer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContent(File file) {
        ByteBuffer byteBuffer;
        ObjectUtil.checkNotNull(file, "file");
        long l = file.length();
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too big to be loaded in memory");
        }
        this.checkSize(l);
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
             FileChannel fileChannel = randomAccessFile.getChannel();){
            byte[] byArray = new byte[(int)l];
            byteBuffer = ByteBuffer.wrap(byArray);
            int n = 0;
            while ((long)n < l) {
                n += fileChannel.read(byteBuffer);
            }
        }
        byteBuffer.flip();
        if (this.byteBuf != null) {
            this.byteBuf.release();
        }
        this.byteBuf = Unpooled.wrappedBuffer(Integer.MAX_VALUE, byteBuffer);
        this.size = l;
        this.setCompleted();
    }

    @Override
    public void delete() {
        if (this.byteBuf != null) {
            this.byteBuf.release();
            this.byteBuf = null;
        }
    }

    @Override
    public byte[] get() {
        if (this.byteBuf == null) {
            return Unpooled.EMPTY_BUFFER.array();
        }
        byte[] byArray = new byte[this.byteBuf.readableBytes()];
        this.byteBuf.getBytes(this.byteBuf.readerIndex(), byArray);
        return byArray;
    }

    @Override
    public String getString() {
        return this.getString(HttpConstants.DEFAULT_CHARSET);
    }

    @Override
    public String getString(Charset charset) {
        if (this.byteBuf == null) {
            return "";
        }
        if (charset == null) {
            charset = HttpConstants.DEFAULT_CHARSET;
        }
        return this.byteBuf.toString(charset);
    }

    @Override
    public ByteBuf getByteBuf() {
        return this.byteBuf;
    }

    @Override
    public ByteBuf getChunk(int n) {
        if (this.byteBuf == null || n == 0 || this.byteBuf.readableBytes() == 0) {
            this.chunkPosition = 0;
            return Unpooled.EMPTY_BUFFER;
        }
        int n2 = this.byteBuf.readableBytes() - this.chunkPosition;
        if (n2 == 0) {
            this.chunkPosition = 0;
            return Unpooled.EMPTY_BUFFER;
        }
        int n3 = n;
        if (n2 < n) {
            n3 = n2;
        }
        ByteBuf byteBuf = this.byteBuf.retainedSlice(this.chunkPosition, n3);
        this.chunkPosition += n3;
        return byteBuf;
    }

    @Override
    public boolean isInMemory() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean renameTo(File file) {
        long l;
        ObjectUtil.checkNotNull(file, "dest");
        if (this.byteBuf == null) {
            if (!file.createNewFile()) {
                throw new IOException("file exists already: " + file);
            }
            return true;
        }
        int n = this.byteBuf.readableBytes();
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
             FileChannel fileChannel = randomAccessFile.getChannel();){
            if (this.byteBuf.nioBufferCount() == 1) {
                ByteBuffer byteBuffer = this.byteBuf.nioBuffer();
                for (l = 0L; l < (long)n; l += (long)fileChannel.write(byteBuffer)) {
                }
            } else {
                ByteBuffer[] byteBufferArray = this.byteBuf.nioBuffers();
                while (l < (long)n) {
                    l += fileChannel.write(byteBufferArray);
                }
            }
            fileChannel.force(false);
        }
        return l == (long)n;
    }

    @Override
    public File getFile() {
        throw new IOException("Not represented by a file");
    }

    @Override
    public HttpData touch() {
        return this.touch(null);
    }

    @Override
    public HttpData touch(Object object) {
        if (this.byteBuf != null) {
            this.byteBuf.touch(object);
        }
        return this;
    }
}

