/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.multipart;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.channel.ChannelException;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderNames;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderValues;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.AbstractDiskHttpData;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.FileUpload;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.FileUploadUtil;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.InterfaceHttpData;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.InterfaceHttpData$HttpDataType;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public class DiskFileUpload
extends AbstractDiskHttpData
implements FileUpload {
    public static String baseDirectory;
    public static boolean deleteOnExitTemporaryFile;
    public static final String prefix = "FUp_";
    public static final String postfix = ".tmp";
    private final String baseDir;
    private final boolean deleteOnExit;
    private String filename;
    private String contentType;
    private String contentTransferEncoding;

    public DiskFileUpload(String string, String string2, String string3, String string4, Charset charset, long l, String string5, boolean bl) {
        super(string, charset, l);
        this.setFilename(string2);
        this.setContentType(string3);
        this.setContentTransferEncoding(string4);
        this.baseDir = string5 == null ? baseDirectory : string5;
        this.deleteOnExit = bl;
    }

    public DiskFileUpload(String string, String string2, String string3, String string4, Charset charset, long l) {
        this(string, string2, string3, string4, charset, l, baseDirectory, deleteOnExitTemporaryFile);
    }

    @Override
    public InterfaceHttpData$HttpDataType getHttpDataType() {
        return InterfaceHttpData$HttpDataType.FileUpload;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public void setFilename(String string) {
        this.filename = ObjectUtil.checkNotNull(string, "filename");
    }

    public int hashCode() {
        return FileUploadUtil.hashCode(this);
    }

    public boolean equals(Object object) {
        return object instanceof FileUpload && FileUploadUtil.equals(this, (FileUpload)object);
    }

    @Override
    public int compareTo(InterfaceHttpData interfaceHttpData) {
        if (!(interfaceHttpData instanceof FileUpload)) {
            throw new ClassCastException("Cannot compare " + (Object)((Object)this.getHttpDataType()) + " with " + (Object)((Object)interfaceHttpData.getHttpDataType()));
        }
        return this.compareTo((FileUpload)interfaceHttpData);
    }

    @Override
    public int compareTo(FileUpload fileUpload) {
        return FileUploadUtil.compareTo(this, fileUpload);
    }

    @Override
    public void setContentType(String string) {
        this.contentType = ObjectUtil.checkNotNull(string, "contentType");
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getContentTransferEncoding() {
        return this.contentTransferEncoding;
    }

    @Override
    public void setContentTransferEncoding(String string) {
        this.contentTransferEncoding = string;
    }

    public String toString() {
        File file = null;
        try {
            file = this.getFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return HttpHeaderNames.CONTENT_DISPOSITION + ": " + HttpHeaderValues.FORM_DATA + "; " + HttpHeaderValues.NAME + "=\"" + this.getName() + "\"; " + HttpHeaderValues.FILENAME + "=\"" + this.filename + "\"\r\n" + HttpHeaderNames.CONTENT_TYPE + ": " + this.contentType + (this.getCharset() != null ? "; " + HttpHeaderValues.CHARSET + '=' + this.getCharset().name() + "\r\n" : "\r\n") + HttpHeaderNames.CONTENT_LENGTH + ": " + this.length() + "\r\nCompleted: " + this.isCompleted() + "\r\nIsInMemory: " + this.isInMemory() + "\r\nRealFile: " + (file != null ? file.getAbsolutePath() : "null") + " DeleteAfter: " + this.deleteOnExit;
    }

    @Override
    protected boolean deleteOnExit() {
        return this.deleteOnExit;
    }

    @Override
    protected String getBaseDirectory() {
        return this.baseDir;
    }

    @Override
    protected String getDiskFilename() {
        return "upload";
    }

    @Override
    protected String getPostfix() {
        return postfix;
    }

    @Override
    protected String getPrefix() {
        return prefix;
    }

    @Override
    public FileUpload copy() {
        ByteBuf byteBuf = this.content();
        return this.replace(byteBuf != null ? byteBuf.copy() : null);
    }

    @Override
    public FileUpload duplicate() {
        ByteBuf byteBuf = this.content();
        return this.replace(byteBuf != null ? byteBuf.duplicate() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileUpload retainedDuplicate() {
        ByteBuf byteBuf = this.content();
        if (byteBuf != null) {
            byteBuf = byteBuf.retainedDuplicate();
            boolean bl = false;
            try {
                FileUpload fileUpload = this.replace(byteBuf);
                bl = true;
                FileUpload fileUpload2 = fileUpload;
                return fileUpload2;
            }
            finally {
                if (!bl) {
                    byteBuf.release();
                }
            }
        }
        return this.replace(null);
    }

    @Override
    public FileUpload replace(ByteBuf byteBuf) {
        DiskFileUpload diskFileUpload = new DiskFileUpload(this.getName(), this.getFilename(), this.getContentType(), this.getContentTransferEncoding(), this.getCharset(), this.size, this.baseDir, this.deleteOnExit);
        if (byteBuf != null) {
            try {
                diskFileUpload.setContent(byteBuf);
            }
            catch (IOException iOException) {
                throw new ChannelException(iOException);
            }
        }
        return diskFileUpload;
    }

    @Override
    public FileUpload retain(int n) {
        super.retain(n);
        return this;
    }

    @Override
    public FileUpload retain() {
        super.retain();
        return this;
    }

    @Override
    public FileUpload touch() {
        super.touch();
        return this;
    }

    @Override
    public FileUpload touch(Object object) {
        super.touch(object);
        return this;
    }

    static {
        deleteOnExitTemporaryFile = true;
    }
}

