/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.multipart;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.Unpooled;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpConstants;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpContent;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.LastHttpContent;
import pro.gravit.repackage.io.netty.handler.codec.http.QueryStringDecoder;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.Attribute;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.CaseIgnoringComparator;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpDataFactory;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpPostBodyUtil$SeekAheadOptimize;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder$EndOfDataDecoderException;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder$ErrorDataDecoderException;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder$MultiPartStatus;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder$NotEnoughDataDecoderException;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpPostStandardRequestDecoder$UrlDecoder;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpPostStandardRequestDecoder$UrlEncodedDetector;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.InterfaceHttpData;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;

public class HttpPostStandardRequestDecoder
implements InterfaceHttpPostRequestDecoder {
    private final HttpDataFactory factory;
    private final HttpRequest request;
    private final Charset charset;
    private boolean isLastChunk;
    private final List<InterfaceHttpData> bodyListHttpData = new ArrayList<InterfaceHttpData>();
    private final Map<String, List<InterfaceHttpData>> bodyMapHttpData = new TreeMap<CharSequence, List<InterfaceHttpData>>(CaseIgnoringComparator.INSTANCE);
    private ByteBuf undecodedChunk;
    private int bodyListHttpDataRank;
    private HttpPostRequestDecoder$MultiPartStatus currentStatus = HttpPostRequestDecoder$MultiPartStatus.NOTSTARTED;
    private Attribute currentAttribute;
    private boolean destroyed;
    private int discardThreshold = 0xA00000;

    public HttpPostStandardRequestDecoder(HttpRequest httpRequest) {
        this(new DefaultHttpDataFactory(16384L), httpRequest, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostStandardRequestDecoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest) {
        this(httpDataFactory, httpRequest, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostStandardRequestDecoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest, Charset charset) {
        this.request = ObjectUtil.checkNotNull(httpRequest, "request");
        this.charset = ObjectUtil.checkNotNull(charset, "charset");
        this.factory = ObjectUtil.checkNotNull(httpDataFactory, "factory");
        try {
            if (httpRequest instanceof HttpContent) {
                this.offer((HttpContent)((Object)httpRequest));
            } else {
                this.parseBody();
            }
        }
        catch (Throwable throwable) {
            this.destroy();
            PlatformDependent.throwException(throwable);
        }
    }

    private void checkDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException(HttpPostStandardRequestDecoder.class.getSimpleName() + " was destroyed already");
        }
    }

    @Override
    public boolean isMultipart() {
        this.checkDestroyed();
        return false;
    }

    @Override
    public void setDiscardThreshold(int n) {
        this.discardThreshold = ObjectUtil.checkPositiveOrZero(n, "discardThreshold");
    }

    @Override
    public int getDiscardThreshold() {
        return this.discardThreshold;
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas() {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
        }
        return this.bodyListHttpData;
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas(String string) {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
        }
        return this.bodyMapHttpData.get(string);
    }

    @Override
    public InterfaceHttpData getBodyHttpData(String string) {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
        }
        List<InterfaceHttpData> list = this.bodyMapHttpData.get(string);
        if (list != null) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public HttpPostStandardRequestDecoder offer(HttpContent httpContent) {
        this.checkDestroyed();
        if (httpContent instanceof LastHttpContent) {
            this.isLastChunk = true;
        }
        ByteBuf byteBuf = httpContent.content();
        if (this.undecodedChunk == null) {
            this.undecodedChunk = byteBuf.alloc().buffer(byteBuf.readableBytes()).writeBytes(byteBuf);
        } else {
            this.undecodedChunk.writeBytes(byteBuf);
        }
        this.parseBody();
        if (this.undecodedChunk != null && this.undecodedChunk.writerIndex() > this.discardThreshold) {
            if (this.undecodedChunk.refCnt() == 1) {
                this.undecodedChunk.discardReadBytes();
            } else {
                ByteBuf byteBuf2 = this.undecodedChunk.alloc().buffer(this.undecodedChunk.readableBytes());
                byteBuf2.writeBytes(this.undecodedChunk);
                this.undecodedChunk.release();
                this.undecodedChunk = byteBuf2;
            }
        }
        return this;
    }

    @Override
    public boolean hasNext() {
        this.checkDestroyed();
        if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.EPILOGUE && this.bodyListHttpDataRank >= this.bodyListHttpData.size()) {
            throw new HttpPostRequestDecoder$EndOfDataDecoderException();
        }
        return !this.bodyListHttpData.isEmpty() && this.bodyListHttpDataRank < this.bodyListHttpData.size();
    }

    @Override
    public InterfaceHttpData next() {
        this.checkDestroyed();
        if (this.hasNext()) {
            return this.bodyListHttpData.get(this.bodyListHttpDataRank++);
        }
        return null;
    }

    @Override
    public InterfaceHttpData currentPartialHttpData() {
        return this.currentAttribute;
    }

    private void parseBody() {
        if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.PREEPILOGUE || this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.EPILOGUE) {
            if (this.isLastChunk) {
                this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.EPILOGUE;
            }
            return;
        }
        this.parseBodyAttributes();
    }

    protected void addHttpData(InterfaceHttpData interfaceHttpData) {
        if (interfaceHttpData == null) {
            return;
        }
        List<InterfaceHttpData> list = this.bodyMapHttpData.get(interfaceHttpData.getName());
        if (list == null) {
            list = new ArrayList<InterfaceHttpData>(1);
            this.bodyMapHttpData.put(interfaceHttpData.getName(), list);
        }
        list.add(interfaceHttpData);
        this.bodyListHttpData.add(interfaceHttpData);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseBodyAttributesStandard() {
        int n;
        int n2 = n = this.undecodedChunk.readerIndex();
        if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.NOTSTARTED) {
            this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.DISPOSITION;
        }
        boolean bl = true;
        try {
            int n3;
            block8: while (this.undecodedChunk.isReadable() && bl) {
                char c = (char)this.undecodedChunk.readUnsignedByte();
                ++n2;
                switch (this.currentStatus) {
                    case DISPOSITION: {
                        String string;
                        if (c == '=') {
                            this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.FIELD;
                            int n4 = n2 - 1;
                            string = HttpPostStandardRequestDecoder.decodeAttribute(this.undecodedChunk.toString(n, n4 - n, this.charset), this.charset);
                            this.currentAttribute = this.factory.createAttribute(this.request, string);
                            n = n2;
                            continue block8;
                        }
                        if (c != '&') continue block8;
                        this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.DISPOSITION;
                        n3 = n2 - 1;
                        string = HttpPostStandardRequestDecoder.decodeAttribute(this.undecodedChunk.toString(n, n3 - n, this.charset), this.charset);
                        this.currentAttribute = this.factory.createAttribute(this.request, string);
                        this.currentAttribute.setValue("");
                        this.addHttpData(this.currentAttribute);
                        this.currentAttribute = null;
                        n = n2;
                        bl = true;
                        continue block8;
                    }
                    case FIELD: {
                        if (c == '&') {
                            this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.DISPOSITION;
                            n3 = n2 - 1;
                            this.setFinalBuffer(this.undecodedChunk.retainedSlice(n, n3 - n));
                            n = n2;
                            bl = true;
                            continue block8;
                        }
                        if (c == '\r') {
                            if (this.undecodedChunk.isReadable()) {
                                c = (char)this.undecodedChunk.readUnsignedByte();
                                if (c != '\n') throw new HttpPostRequestDecoder$ErrorDataDecoderException("Bad end of line");
                                this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.PREEPILOGUE;
                                n3 = ++n2 - 2;
                                this.setFinalBuffer(this.undecodedChunk.retainedSlice(n, n3 - n));
                                n = n2;
                                bl = false;
                                continue block8;
                            }
                            --n2;
                            continue block8;
                        }
                        if (c != '\n') continue block8;
                        this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.PREEPILOGUE;
                        n3 = n2 - 1;
                        this.setFinalBuffer(this.undecodedChunk.retainedSlice(n, n3 - n));
                        n = n2;
                        bl = false;
                        continue block8;
                    }
                }
                bl = false;
            }
            if (this.isLastChunk && this.currentAttribute != null) {
                n3 = n2;
                if (n3 > n) {
                    this.setFinalBuffer(this.undecodedChunk.retainedSlice(n, n3 - n));
                } else if (!this.currentAttribute.isCompleted()) {
                    this.setFinalBuffer(Unpooled.EMPTY_BUFFER);
                }
                n = n2;
                this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.EPILOGUE;
            } else if (bl && this.currentAttribute != null && this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.FIELD) {
                this.currentAttribute.addContent(this.undecodedChunk.retainedSlice(n, n2 - n), false);
                n = n2;
            }
            this.undecodedChunk.readerIndex(n);
            return;
        }
        catch (HttpPostRequestDecoder$ErrorDataDecoderException httpPostRequestDecoder$ErrorDataDecoderException) {
            this.undecodedChunk.readerIndex(n);
            throw httpPostRequestDecoder$ErrorDataDecoderException;
        }
        catch (IOException iOException) {
            this.undecodedChunk.readerIndex(n);
            throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.undecodedChunk.readerIndex(n);
            throw new HttpPostRequestDecoder$ErrorDataDecoderException(illegalArgumentException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseBodyAttributes() {
        int n;
        if (this.undecodedChunk == null) {
            return;
        }
        if (!this.undecodedChunk.hasArray()) {
            this.parseBodyAttributesStandard();
            return;
        }
        HttpPostBodyUtil$SeekAheadOptimize httpPostBodyUtil$SeekAheadOptimize = new HttpPostBodyUtil$SeekAheadOptimize(this.undecodedChunk);
        int n2 = n = this.undecodedChunk.readerIndex();
        if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.NOTSTARTED) {
            this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.DISPOSITION;
        }
        boolean bl = true;
        try {
            int n3;
            block8: while (httpPostBodyUtil$SeekAheadOptimize.pos < httpPostBodyUtil$SeekAheadOptimize.limit) {
                char c = (char)(httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++] & 0xFF);
                ++n2;
                switch (this.currentStatus) {
                    case DISPOSITION: {
                        String string;
                        if (c == '=') {
                            this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.FIELD;
                            int n4 = n2 - 1;
                            string = HttpPostStandardRequestDecoder.decodeAttribute(this.undecodedChunk.toString(n, n4 - n, this.charset), this.charset);
                            this.currentAttribute = this.factory.createAttribute(this.request, string);
                            n = n2;
                            continue block8;
                        }
                        if (c != '&') continue block8;
                        this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.DISPOSITION;
                        n3 = n2 - 1;
                        string = HttpPostStandardRequestDecoder.decodeAttribute(this.undecodedChunk.toString(n, n3 - n, this.charset), this.charset);
                        this.currentAttribute = this.factory.createAttribute(this.request, string);
                        this.currentAttribute.setValue("");
                        this.addHttpData(this.currentAttribute);
                        this.currentAttribute = null;
                        n = n2;
                        bl = true;
                        continue block8;
                    }
                    case FIELD: {
                        if (c == '&') {
                            this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.DISPOSITION;
                            n3 = n2 - 1;
                            this.setFinalBuffer(this.undecodedChunk.retainedSlice(n, n3 - n));
                            n = n2;
                            bl = true;
                            continue block8;
                        }
                        if (c == '\r') {
                            if (httpPostBodyUtil$SeekAheadOptimize.pos < httpPostBodyUtil$SeekAheadOptimize.limit) {
                                c = (char)(httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++] & 0xFF);
                                ++n2;
                                if (c != '\n') {
                                    httpPostBodyUtil$SeekAheadOptimize.setReadPosition(0);
                                    throw new HttpPostRequestDecoder$ErrorDataDecoderException("Bad end of line");
                                }
                                this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.PREEPILOGUE;
                                n3 = n2 - 2;
                                httpPostBodyUtil$SeekAheadOptimize.setReadPosition(0);
                                this.setFinalBuffer(this.undecodedChunk.retainedSlice(n, n3 - n));
                                n = n2;
                                bl = false;
                                break block8;
                            }
                            if (httpPostBodyUtil$SeekAheadOptimize.limit <= 0) continue block8;
                            --n2;
                            continue block8;
                        }
                        if (c != '\n') continue block8;
                        this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.PREEPILOGUE;
                        n3 = n2 - 1;
                        httpPostBodyUtil$SeekAheadOptimize.setReadPosition(0);
                        this.setFinalBuffer(this.undecodedChunk.retainedSlice(n, n3 - n));
                        n = n2;
                        bl = false;
                        break block8;
                    }
                }
                httpPostBodyUtil$SeekAheadOptimize.setReadPosition(0);
                bl = false;
                break;
            }
            if (this.isLastChunk && this.currentAttribute != null) {
                n3 = n2;
                if (n3 > n) {
                    this.setFinalBuffer(this.undecodedChunk.retainedSlice(n, n3 - n));
                } else if (!this.currentAttribute.isCompleted()) {
                    this.setFinalBuffer(Unpooled.EMPTY_BUFFER);
                }
                n = n2;
                this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.EPILOGUE;
            } else if (bl && this.currentAttribute != null && this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.FIELD) {
                this.currentAttribute.addContent(this.undecodedChunk.retainedSlice(n, n2 - n), false);
                n = n2;
            }
            this.undecodedChunk.readerIndex(n);
            return;
        }
        catch (HttpPostRequestDecoder$ErrorDataDecoderException httpPostRequestDecoder$ErrorDataDecoderException) {
            this.undecodedChunk.readerIndex(n);
            throw httpPostRequestDecoder$ErrorDataDecoderException;
        }
        catch (IOException iOException) {
            this.undecodedChunk.readerIndex(n);
            throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.undecodedChunk.readerIndex(n);
            throw new HttpPostRequestDecoder$ErrorDataDecoderException(illegalArgumentException);
        }
    }

    private void setFinalBuffer(ByteBuf byteBuf) {
        this.currentAttribute.addContent(byteBuf, true);
        ByteBuf byteBuf2 = HttpPostStandardRequestDecoder.decodeAttribute(this.currentAttribute.getByteBuf(), this.charset);
        if (byteBuf2 != null) {
            this.currentAttribute.setContent(byteBuf2);
        }
        this.addHttpData(this.currentAttribute);
        this.currentAttribute = null;
    }

    private static String decodeAttribute(String string, Charset charset) {
        try {
            return QueryStringDecoder.decodeComponent(string, charset);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new HttpPostRequestDecoder$ErrorDataDecoderException("Bad string: '" + string + '\'', illegalArgumentException);
        }
    }

    private static ByteBuf decodeAttribute(ByteBuf byteBuf, Charset charset) {
        int n = byteBuf.forEachByte(new HttpPostStandardRequestDecoder$UrlEncodedDetector(null));
        if (n == -1) {
            return null;
        }
        ByteBuf byteBuf2 = byteBuf.alloc().buffer(byteBuf.readableBytes());
        HttpPostStandardRequestDecoder$UrlDecoder httpPostStandardRequestDecoder$UrlDecoder = new HttpPostStandardRequestDecoder$UrlDecoder(byteBuf2);
        int n2 = byteBuf.forEachByte(httpPostStandardRequestDecoder$UrlDecoder);
        if (HttpPostStandardRequestDecoder$UrlDecoder.access$100(httpPostStandardRequestDecoder$UrlDecoder) != 0) {
            if (n2 == -1) {
                n2 = byteBuf.readableBytes() - 1;
            }
            byteBuf2.release();
            throw new HttpPostRequestDecoder$ErrorDataDecoderException(String.format("Invalid hex byte at index '%d' in string: '%s'", n2 -= HttpPostStandardRequestDecoder$UrlDecoder.access$100(httpPostStandardRequestDecoder$UrlDecoder) - 1, byteBuf.toString(charset)));
        }
        return byteBuf2;
    }

    @Override
    public void destroy() {
        this.cleanFiles();
        for (InterfaceHttpData interfaceHttpData : this.bodyListHttpData) {
            if (interfaceHttpData.refCnt() <= 0) continue;
            interfaceHttpData.release();
        }
        this.destroyed = true;
        if (this.undecodedChunk != null && this.undecodedChunk.refCnt() > 0) {
            this.undecodedChunk.release();
            this.undecodedChunk = null;
        }
    }

    @Override
    public void cleanFiles() {
        this.checkDestroyed();
        this.factory.cleanRequestHttpData(this.request);
    }

    @Override
    public void removeHttpDataFromClean(InterfaceHttpData interfaceHttpData) {
        this.checkDestroyed();
        this.factory.removeHttpDataFromClean(this.request, interfaceHttpData);
    }
}

