/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.multipart;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.DiskFileUpload;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.FileUpload;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.InterfaceHttpData;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.InterfaceHttpData$HttpDataType;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.MemoryFileUpload;

public class MixedFileUpload
implements FileUpload {
    private final String baseDir;
    private final boolean deleteOnExit;
    private FileUpload fileUpload;
    private final long limitSize;
    private final long definedSize;
    private long maxSize = -1L;

    public MixedFileUpload(String string, String string2, String string3, String string4, Charset charset, long l, long l2) {
        this(string, string2, string3, string4, charset, l, l2, DiskFileUpload.baseDirectory, DiskFileUpload.deleteOnExitTemporaryFile);
    }

    public MixedFileUpload(String string, String string2, String string3, String string4, Charset charset, long l, long l2, String string5, boolean bl) {
        this.limitSize = l2;
        this.fileUpload = l > this.limitSize ? new DiskFileUpload(string, string2, string3, string4, charset, l) : new MemoryFileUpload(string, string2, string3, string4, charset, l);
        this.definedSize = l;
        this.baseDir = string5;
        this.deleteOnExit = bl;
    }

    @Override
    public long getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void setMaxSize(long l) {
        this.maxSize = l;
        this.fileUpload.setMaxSize(l);
    }

    @Override
    public void checkSize(long l) {
        if (this.maxSize >= 0L && l > this.maxSize) {
            throw new IOException("Size exceed allowed maximum capacity");
        }
    }

    @Override
    public void addContent(ByteBuf byteBuf, boolean bl) {
        if (this.fileUpload instanceof MemoryFileUpload) {
            try {
                this.checkSize(this.fileUpload.length() + (long)byteBuf.readableBytes());
                if (this.fileUpload.length() + (long)byteBuf.readableBytes() > this.limitSize) {
                    DiskFileUpload diskFileUpload = new DiskFileUpload(this.fileUpload.getName(), this.fileUpload.getFilename(), this.fileUpload.getContentType(), this.fileUpload.getContentTransferEncoding(), this.fileUpload.getCharset(), this.definedSize, this.baseDir, this.deleteOnExit);
                    diskFileUpload.setMaxSize(this.maxSize);
                    ByteBuf byteBuf2 = this.fileUpload.getByteBuf();
                    if (byteBuf2 != null && byteBuf2.isReadable()) {
                        diskFileUpload.addContent(byteBuf2.retain(), false);
                    }
                    this.fileUpload.release();
                    this.fileUpload = diskFileUpload;
                }
            }
            catch (IOException iOException) {
                byteBuf.release();
                throw iOException;
            }
        }
        this.fileUpload.addContent(byteBuf, bl);
    }

    @Override
    public void delete() {
        this.fileUpload.delete();
    }

    @Override
    public byte[] get() {
        return this.fileUpload.get();
    }

    @Override
    public ByteBuf getByteBuf() {
        return this.fileUpload.getByteBuf();
    }

    @Override
    public Charset getCharset() {
        return this.fileUpload.getCharset();
    }

    @Override
    public String getContentType() {
        return this.fileUpload.getContentType();
    }

    @Override
    public String getContentTransferEncoding() {
        return this.fileUpload.getContentTransferEncoding();
    }

    @Override
    public String getFilename() {
        return this.fileUpload.getFilename();
    }

    @Override
    public String getString() {
        return this.fileUpload.getString();
    }

    @Override
    public String getString(Charset charset) {
        return this.fileUpload.getString(charset);
    }

    @Override
    public boolean isCompleted() {
        return this.fileUpload.isCompleted();
    }

    @Override
    public boolean isInMemory() {
        return this.fileUpload.isInMemory();
    }

    @Override
    public long length() {
        return this.fileUpload.length();
    }

    @Override
    public long definedLength() {
        return this.fileUpload.definedLength();
    }

    @Override
    public boolean renameTo(File file) {
        return this.fileUpload.renameTo(file);
    }

    @Override
    public void setCharset(Charset charset) {
        this.fileUpload.setCharset(charset);
    }

    @Override
    public void setContent(ByteBuf byteBuf) {
        try {
            this.checkSize(byteBuf.readableBytes());
        }
        catch (IOException iOException) {
            byteBuf.release();
            throw iOException;
        }
        if ((long)byteBuf.readableBytes() > this.limitSize && this.fileUpload instanceof MemoryFileUpload) {
            FileUpload fileUpload = this.fileUpload;
            this.fileUpload = new DiskFileUpload(fileUpload.getName(), fileUpload.getFilename(), fileUpload.getContentType(), fileUpload.getContentTransferEncoding(), fileUpload.getCharset(), this.definedSize, this.baseDir, this.deleteOnExit);
            this.fileUpload.setMaxSize(this.maxSize);
            fileUpload.release();
        }
        this.fileUpload.setContent(byteBuf);
    }

    @Override
    public void setContent(File file) {
        this.checkSize(file.length());
        if (file.length() > this.limitSize && this.fileUpload instanceof MemoryFileUpload) {
            FileUpload fileUpload = this.fileUpload;
            this.fileUpload = new DiskFileUpload(fileUpload.getName(), fileUpload.getFilename(), fileUpload.getContentType(), fileUpload.getContentTransferEncoding(), fileUpload.getCharset(), this.definedSize, this.baseDir, this.deleteOnExit);
            this.fileUpload.setMaxSize(this.maxSize);
            fileUpload.release();
        }
        this.fileUpload.setContent(file);
    }

    @Override
    public void setContent(InputStream inputStream) {
        if (this.fileUpload instanceof MemoryFileUpload) {
            FileUpload fileUpload = this.fileUpload;
            this.fileUpload = new DiskFileUpload(this.fileUpload.getName(), this.fileUpload.getFilename(), this.fileUpload.getContentType(), this.fileUpload.getContentTransferEncoding(), this.fileUpload.getCharset(), this.definedSize, this.baseDir, this.deleteOnExit);
            this.fileUpload.setMaxSize(this.maxSize);
            fileUpload.release();
        }
        this.fileUpload.setContent(inputStream);
    }

    @Override
    public void setContentType(String string) {
        this.fileUpload.setContentType(string);
    }

    @Override
    public void setContentTransferEncoding(String string) {
        this.fileUpload.setContentTransferEncoding(string);
    }

    @Override
    public void setFilename(String string) {
        this.fileUpload.setFilename(string);
    }

    @Override
    public InterfaceHttpData$HttpDataType getHttpDataType() {
        return this.fileUpload.getHttpDataType();
    }

    @Override
    public String getName() {
        return this.fileUpload.getName();
    }

    public int hashCode() {
        return this.fileUpload.hashCode();
    }

    public boolean equals(Object object) {
        return this.fileUpload.equals(object);
    }

    @Override
    public int compareTo(InterfaceHttpData interfaceHttpData) {
        return this.fileUpload.compareTo(interfaceHttpData);
    }

    public String toString() {
        return "Mixed: " + this.fileUpload;
    }

    @Override
    public ByteBuf getChunk(int n) {
        return this.fileUpload.getChunk(n);
    }

    @Override
    public File getFile() {
        return this.fileUpload.getFile();
    }

    @Override
    public FileUpload copy() {
        return this.fileUpload.copy();
    }

    @Override
    public FileUpload duplicate() {
        return this.fileUpload.duplicate();
    }

    @Override
    public FileUpload retainedDuplicate() {
        return this.fileUpload.retainedDuplicate();
    }

    @Override
    public FileUpload replace(ByteBuf byteBuf) {
        return this.fileUpload.replace(byteBuf);
    }

    @Override
    public ByteBuf content() {
        return this.fileUpload.content();
    }

    @Override
    public int refCnt() {
        return this.fileUpload.refCnt();
    }

    @Override
    public FileUpload retain() {
        this.fileUpload.retain();
        return this;
    }

    @Override
    public FileUpload retain(int n) {
        this.fileUpload.retain(n);
        return this;
    }

    @Override
    public FileUpload touch() {
        this.fileUpload.touch();
        return this;
    }

    @Override
    public FileUpload touch(Object object) {
        this.fileUpload.touch(object);
        return this;
    }

    @Override
    public boolean release() {
        return this.fileUpload.release();
    }

    @Override
    public boolean release(int n) {
        return this.fileUpload.release(n);
    }
}

