/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.websocketx;

import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelOutboundHandler;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.handler.codec.MessageToMessageDecoder;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketProtocolHandler$1;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketProtocolHandler$2;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketProtocolHandler$3;
import pro.gravit.repackage.io.netty.util.ReferenceCountUtil;
import pro.gravit.repackage.io.netty.util.concurrent.PromiseNotifier;
import pro.gravit.repackage.io.netty.util.concurrent.ScheduledFuture;

abstract class WebSocketProtocolHandler
extends MessageToMessageDecoder<WebSocketFrame>
implements ChannelOutboundHandler {
    private final boolean dropPongFrames;
    private final WebSocketCloseStatus closeStatus;
    private final long forceCloseTimeoutMillis;
    private ChannelPromise closeSent;

    WebSocketProtocolHandler() {
        this(true);
    }

    WebSocketProtocolHandler(boolean bl) {
        this(bl, null, 0L);
    }

    WebSocketProtocolHandler(boolean bl, WebSocketCloseStatus webSocketCloseStatus, long l) {
        this.dropPongFrames = bl;
        this.closeStatus = webSocketCloseStatus;
        this.forceCloseTimeoutMillis = l;
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame, List<Object> list) {
        if (webSocketFrame instanceof PingWebSocketFrame) {
            webSocketFrame.content().retain();
            channelHandlerContext.channel().writeAndFlush(new PongWebSocketFrame(webSocketFrame.content()));
            WebSocketProtocolHandler.readIfNeeded(channelHandlerContext);
            return;
        }
        if (webSocketFrame instanceof PongWebSocketFrame && this.dropPongFrames) {
            WebSocketProtocolHandler.readIfNeeded(channelHandlerContext);
            return;
        }
        list.add(webSocketFrame.retain());
    }

    private static void readIfNeeded(ChannelHandlerContext channelHandlerContext) {
        if (!channelHandlerContext.channel().config().isAutoRead()) {
            channelHandlerContext.read();
        }
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        if (this.closeStatus == null || !channelHandlerContext.channel().isActive()) {
            channelHandlerContext.close(channelPromise);
        } else {
            if (this.closeSent == null) {
                this.write(channelHandlerContext, new CloseWebSocketFrame(this.closeStatus), channelHandlerContext.newPromise());
            }
            this.flush(channelHandlerContext);
            this.applyCloseSentTimeout(channelHandlerContext);
            this.closeSent.addListener(new WebSocketProtocolHandler$1(this, channelHandlerContext, channelPromise));
        }
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (this.closeSent != null) {
            ReferenceCountUtil.release(object);
            channelPromise.setFailure(new ClosedChannelException());
        } else if (object instanceof CloseWebSocketFrame) {
            this.closeSent(channelPromise.unvoid());
            channelHandlerContext.write(object).addListener(new PromiseNotifier(false, this.closeSent));
        } else {
            channelHandlerContext.write(object, channelPromise);
        }
    }

    void closeSent(ChannelPromise channelPromise) {
        this.closeSent = channelPromise;
    }

    private void applyCloseSentTimeout(ChannelHandlerContext channelHandlerContext) {
        if (this.closeSent.isDone() || this.forceCloseTimeoutMillis < 0L) {
            return;
        }
        ScheduledFuture<?> scheduledFuture = channelHandlerContext.executor().schedule(new WebSocketProtocolHandler$2(this), this.forceCloseTimeoutMillis, TimeUnit.MILLISECONDS);
        this.closeSent.addListener(new WebSocketProtocolHandler$3(this, scheduledFuture));
    }

    protected WebSocketHandshakeException buildHandshakeException(String string) {
        return new WebSocketHandshakeException(string);
    }

    @Override
    public void bind(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, ChannelPromise channelPromise) {
        channelHandlerContext.bind(socketAddress, channelPromise);
    }

    @Override
    public void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        channelHandlerContext.connect(socketAddress, socketAddress2, channelPromise);
    }

    @Override
    public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.disconnect(channelPromise);
    }

    @Override
    public void deregister(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.deregister(channelPromise);
    }

    @Override
    public void read(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.read();
    }

    @Override
    public void flush(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.flush();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        channelHandlerContext.fireExceptionCaught(throwable);
        channelHandlerContext.close();
    }

    static /* synthetic */ ChannelPromise access$000(WebSocketProtocolHandler webSocketProtocolHandler) {
        return webSocketProtocolHandler.closeSent;
    }
}

