/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.websocketx;

import java.util.regex.Pattern;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.Unpooled;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultFullHttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.FullHttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.FullHttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderNames;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderValues;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaders;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpResponseStatus;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpVersion;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocket00FrameDecoder;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocket00FrameEncoder;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketServerHandshakeException;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketUtil;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketVersion;

public class WebSocketServerHandshaker00
extends WebSocketServerHandshaker {
    private static final Pattern BEGINNING_DIGIT = Pattern.compile("[^0-9]");
    private static final Pattern BEGINNING_SPACE = Pattern.compile("[^ ]");

    public WebSocketServerHandshaker00(String string, String string2, int n) {
        this(string, string2, WebSocketDecoderConfig.newBuilder().maxFramePayloadLength(n).build());
    }

    public WebSocketServerHandshaker00(String string, String string2, WebSocketDecoderConfig webSocketDecoderConfig) {
        super(WebSocketVersion.V00, string, string2, webSocketDecoderConfig);
    }

    @Override
    protected FullHttpResponse newHandshakeResponse(FullHttpRequest fullHttpRequest, HttpHeaders httpHeaders) {
        if (!fullHttpRequest.headers().containsValue(HttpHeaderNames.CONNECTION, HttpHeaderValues.UPGRADE, true) || !HttpHeaderValues.WEBSOCKET.contentEqualsIgnoreCase(fullHttpRequest.headers().get(HttpHeaderNames.UPGRADE))) {
            throw new WebSocketServerHandshakeException("not a WebSocket handshake request: missing upgrade", fullHttpRequest);
        }
        boolean bl = fullHttpRequest.headers().contains(HttpHeaderNames.SEC_WEBSOCKET_KEY1) && fullHttpRequest.headers().contains(HttpHeaderNames.SEC_WEBSOCKET_KEY2);
        String string = fullHttpRequest.headers().get(HttpHeaderNames.ORIGIN);
        if (string == null && !bl) {
            throw new WebSocketServerHandshakeException("Missing origin header, got only " + fullHttpRequest.headers().names(), fullHttpRequest);
        }
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, new HttpResponseStatus(101, bl ? "WebSocket Protocol Handshake" : "Web Socket Protocol Handshake"), fullHttpRequest.content().alloc().buffer(0));
        if (httpHeaders != null) {
            defaultFullHttpResponse.headers().add(httpHeaders);
        }
        defaultFullHttpResponse.headers().set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE);
        if (bl) {
            String string2;
            defaultFullHttpResponse.headers().add((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN, (Object)string);
            defaultFullHttpResponse.headers().add((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_LOCATION, (Object)this.uri());
            String string3 = fullHttpRequest.headers().get(HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL);
            if (string3 != null) {
                string2 = this.selectSubprotocol(string3);
                if (string2 == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Requested subprotocol(s) not supported: {}", (Object)string3);
                    }
                } else {
                    defaultFullHttpResponse.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)string2);
                }
            }
            string2 = fullHttpRequest.headers().get(HttpHeaderNames.SEC_WEBSOCKET_KEY1);
            String string4 = fullHttpRequest.headers().get(HttpHeaderNames.SEC_WEBSOCKET_KEY2);
            int n = (int)(Long.parseLong(BEGINNING_DIGIT.matcher(string2).replaceAll("")) / (long)BEGINNING_SPACE.matcher(string2).replaceAll("").length());
            int n2 = (int)(Long.parseLong(BEGINNING_DIGIT.matcher(string4).replaceAll("")) / (long)BEGINNING_SPACE.matcher(string4).replaceAll("").length());
            long l = fullHttpRequest.content().readLong();
            ByteBuf byteBuf = Unpooled.wrappedBuffer(new byte[16]).setIndex(0, 0);
            byteBuf.writeInt(n);
            byteBuf.writeInt(n2);
            byteBuf.writeLong(l);
            defaultFullHttpResponse.content().writeBytes(WebSocketUtil.md5(byteBuf.array()));
        } else {
            defaultFullHttpResponse.headers().add((CharSequence)HttpHeaderNames.WEBSOCKET_ORIGIN, (Object)string);
            defaultFullHttpResponse.headers().add((CharSequence)HttpHeaderNames.WEBSOCKET_LOCATION, (Object)this.uri());
            String string5 = fullHttpRequest.headers().get(HttpHeaderNames.WEBSOCKET_PROTOCOL);
            if (string5 != null) {
                defaultFullHttpResponse.headers().set((CharSequence)HttpHeaderNames.WEBSOCKET_PROTOCOL, (Object)this.selectSubprotocol(string5));
            }
        }
        return defaultFullHttpResponse;
    }

    @Override
    public ChannelFuture close(Channel channel, CloseWebSocketFrame closeWebSocketFrame, ChannelPromise channelPromise) {
        return channel.writeAndFlush(closeWebSocketFrame, channelPromise);
    }

    @Override
    public ChannelFuture close(ChannelHandlerContext channelHandlerContext, CloseWebSocketFrame closeWebSocketFrame, ChannelPromise channelPromise) {
        return channelHandlerContext.writeAndFlush(closeWebSocketFrame, channelPromise);
    }

    @Override
    protected WebSocketFrameDecoder newWebsocketDecoder() {
        return new WebSocket00FrameDecoder(this.decoderConfig());
    }

    @Override
    protected WebSocketFrameEncoder newWebSocketEncoder() {
        return new WebSocket00FrameEncoder();
    }
}

