/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.websocketx;

import pro.gravit.repackage.io.netty.handler.codec.http.DefaultFullHttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.FullHttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.FullHttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderNames;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderValues;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaders;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpResponseStatus;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpVersion;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocket07FrameDecoder;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocket07FrameEncoder;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketServerHandshakeException;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketUtil;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import pro.gravit.repackage.io.netty.util.CharsetUtil;

public class WebSocketServerHandshaker07
extends WebSocketServerHandshaker {
    public static final String WEBSOCKET_07_ACCEPT_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";

    public WebSocketServerHandshaker07(String string, String string2, boolean bl, int n) {
        this(string, string2, bl, n, false);
    }

    public WebSocketServerHandshaker07(String string, String string2, boolean bl, int n, boolean bl2) {
        this(string, string2, WebSocketDecoderConfig.newBuilder().allowExtensions(bl).maxFramePayloadLength(n).allowMaskMismatch(bl2).build());
    }

    public WebSocketServerHandshaker07(String string, String string2, WebSocketDecoderConfig webSocketDecoderConfig) {
        super(WebSocketVersion.V07, string, string2, webSocketDecoderConfig);
    }

    @Override
    protected FullHttpResponse newHandshakeResponse(FullHttpRequest fullHttpRequest, HttpHeaders httpHeaders) {
        String string = fullHttpRequest.headers().get(HttpHeaderNames.SEC_WEBSOCKET_KEY);
        if (string == null) {
            throw new WebSocketServerHandshakeException("not a WebSocket request: missing key", fullHttpRequest);
        }
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS, fullHttpRequest.content().alloc().buffer(0));
        if (httpHeaders != null) {
            defaultFullHttpResponse.headers().add(httpHeaders);
        }
        String string2 = string + WEBSOCKET_07_ACCEPT_GUID;
        byte[] byArray = WebSocketUtil.sha1(string2.getBytes(CharsetUtil.US_ASCII));
        String string3 = WebSocketUtil.base64(byArray);
        if (logger.isDebugEnabled()) {
            logger.debug("WebSocket version 07 server handshake key: {}, response: {}.", (Object)string, (Object)string3);
        }
        defaultFullHttpResponse.headers().set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ACCEPT, (Object)string3);
        String string4 = fullHttpRequest.headers().get(HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL);
        if (string4 != null) {
            String string5 = this.selectSubprotocol(string4);
            if (string5 == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Requested subprotocol(s) not supported: {}", (Object)string4);
                }
            } else {
                defaultFullHttpResponse.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)string5);
            }
        }
        return defaultFullHttpResponse;
    }

    @Override
    protected WebSocketFrameDecoder newWebsocketDecoder() {
        return new WebSocket07FrameDecoder(this.decoderConfig());
    }

    @Override
    protected WebSocketFrameEncoder newWebSocketEncoder() {
        return new WebSocket07FrameEncoder(false);
    }
}

