/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.websocketx;

import java.util.concurrent.TimeUnit;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.ChannelFutureListener;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelInboundHandlerAdapter;
import pro.gravit.repackage.io.netty.channel.ChannelPipeline;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultFullHttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.FullHttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderNames;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpMethod;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpResponseStatus;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpUtil;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpVersion;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketServerProtocolConfig;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandshakeHandler$1;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandshakeHandler$2;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandshakeHandler$3;
import pro.gravit.repackage.io.netty.handler.ssl.SslHandler;
import pro.gravit.repackage.io.netty.util.concurrent.ScheduledFuture;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

class WebSocketServerProtocolHandshakeHandler
extends ChannelInboundHandlerAdapter {
    private final WebSocketServerProtocolConfig serverConfig;
    private ChannelHandlerContext ctx;
    private ChannelPromise handshakePromise;

    WebSocketServerProtocolHandshakeHandler(WebSocketServerProtocolConfig webSocketServerProtocolConfig) {
        this.serverConfig = ObjectUtil.checkNotNull(webSocketServerProtocolConfig, "serverConfig");
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
        this.handshakePromise = channelHandlerContext.newPromise();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        FullHttpRequest fullHttpRequest = (FullHttpRequest)object;
        if (!this.isWebSocketPath(fullHttpRequest)) {
            channelHandlerContext.fireChannelRead(object);
            return;
        }
        try {
            if (!HttpMethod.GET.equals(fullHttpRequest.method())) {
                WebSocketServerProtocolHandshakeHandler.sendHttpResponse(channelHandlerContext, fullHttpRequest, new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN, channelHandlerContext.alloc().buffer(0)));
                return;
            }
            WebSocketServerHandshakerFactory webSocketServerHandshakerFactory = new WebSocketServerHandshakerFactory(WebSocketServerProtocolHandshakeHandler.getWebSocketLocation(channelHandlerContext.pipeline(), fullHttpRequest, this.serverConfig.websocketPath()), this.serverConfig.subprotocols(), this.serverConfig.decoderConfig());
            WebSocketServerHandshaker webSocketServerHandshaker = webSocketServerHandshakerFactory.newHandshaker(fullHttpRequest);
            ChannelPromise channelPromise = this.handshakePromise;
            if (webSocketServerHandshaker == null) {
                WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(channelHandlerContext.channel());
            } else {
                WebSocketServerProtocolHandler.setHandshaker(channelHandlerContext.channel(), webSocketServerHandshaker);
                channelHandlerContext.pipeline().remove(this);
                ChannelFuture channelFuture = webSocketServerHandshaker.handshake(channelHandlerContext.channel(), fullHttpRequest);
                channelFuture.addListener(new WebSocketServerProtocolHandshakeHandler$1(this, channelPromise, channelHandlerContext, fullHttpRequest, webSocketServerHandshaker));
                this.applyHandshakeTimeout();
            }
        }
        finally {
            fullHttpRequest.release();
        }
    }

    private boolean isWebSocketPath(FullHttpRequest fullHttpRequest) {
        boolean bl;
        String string = this.serverConfig.websocketPath();
        String string2 = fullHttpRequest.uri();
        boolean bl2 = string2.startsWith(string);
        boolean bl3 = bl = "/".equals(string) || this.checkNextUri(string2, string);
        return this.serverConfig.checkStartsWith() ? bl2 && bl : string2.equals(string);
    }

    private boolean checkNextUri(String string, String string2) {
        int n = string2.length();
        if (string.length() > n) {
            char c = string.charAt(n);
            return c == '/' || c == '?';
        }
        return true;
    }

    private static void sendHttpResponse(ChannelHandlerContext channelHandlerContext, HttpRequest httpRequest, HttpResponse httpResponse) {
        ChannelFuture channelFuture = channelHandlerContext.channel().writeAndFlush(httpResponse);
        if (!HttpUtil.isKeepAlive(httpRequest) || httpResponse.status().code() != 200) {
            channelFuture.addListener(ChannelFutureListener.CLOSE);
        }
    }

    private static String getWebSocketLocation(ChannelPipeline channelPipeline, HttpRequest httpRequest, String string) {
        String string2 = "ws";
        if (channelPipeline.get(SslHandler.class) != null) {
            string2 = "wss";
        }
        String string3 = httpRequest.headers().get(HttpHeaderNames.HOST);
        return string2 + "://" + string3 + string;
    }

    private void applyHandshakeTimeout() {
        ChannelPromise channelPromise = this.handshakePromise;
        long l = this.serverConfig.handshakeTimeoutMillis();
        if (l <= 0L || channelPromise.isDone()) {
            return;
        }
        ScheduledFuture<?> scheduledFuture = this.ctx.executor().schedule(new WebSocketServerProtocolHandshakeHandler$2(this, channelPromise), l, TimeUnit.MILLISECONDS);
        channelPromise.addListener(new WebSocketServerProtocolHandshakeHandler$3(this, scheduledFuture));
    }

    static /* synthetic */ ChannelHandlerContext access$000(WebSocketServerProtocolHandshakeHandler webSocketServerProtocolHandshakeHandler) {
        return webSocketServerProtocolHandshakeHandler.ctx;
    }
}

