/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.websocketx;

import java.security.MessageDigest;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.Unpooled;
import pro.gravit.repackage.io.netty.handler.codec.base64.Base64;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketUtil$1;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketUtil$2;
import pro.gravit.repackage.io.netty.util.CharsetUtil;
import pro.gravit.repackage.io.netty.util.concurrent.FastThreadLocal;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.SuppressJava6Requirement;

final class WebSocketUtil {
    private static final FastThreadLocal<MessageDigest> MD5 = new WebSocketUtil$1();
    private static final FastThreadLocal<MessageDigest> SHA1 = new WebSocketUtil$2();

    static byte[] md5(byte[] byArray) {
        return WebSocketUtil.digest(MD5, byArray);
    }

    static byte[] sha1(byte[] byArray) {
        return WebSocketUtil.digest(SHA1, byArray);
    }

    private static byte[] digest(FastThreadLocal<MessageDigest> fastThreadLocal, byte[] byArray) {
        MessageDigest messageDigest = fastThreadLocal.get();
        messageDigest.reset();
        return messageDigest.digest(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressJava6Requirement(reason="Guarded with java version check")
    static String base64(byte[] byArray) {
        String string;
        if (PlatformDependent.javaVersion() >= 8) {
            return java.util.Base64.getEncoder().encodeToString(byArray);
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer(byArray);
        try {
            ByteBuf byteBuf2 = Base64.encode(byteBuf);
            try {
                string = byteBuf2.toString(CharsetUtil.UTF_8);
            }
            finally {
                byteBuf2.release();
            }
        }
        finally {
            byteBuf.release();
        }
        return string;
    }

    static byte[] randomBytes(int n) {
        byte[] byArray = new byte[n];
        PlatformDependent.threadLocalRandom().nextBytes(byArray);
        return byArray;
    }

    static int randomNumber(int n, int n2) {
        assert (n < n2);
        double d = PlatformDependent.threadLocalRandom().nextDouble();
        return (int)((double)n + d * (double)(n2 - n));
    }

    private WebSocketUtil() {
    }
}

