/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import pro.gravit.repackage.io.netty.channel.ChannelDuplexHandler;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderNames;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaders;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpResponseStatus;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions.WebSocketExtension;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionUtil;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtension;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandler$1;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandler$2;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandshaker;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public class WebSocketServerExtensionHandler
extends ChannelDuplexHandler {
    private final List<WebSocketServerExtensionHandshaker> extensionHandshakers;
    private List<WebSocketServerExtension> validExtensions;

    public WebSocketServerExtensionHandler(WebSocketServerExtensionHandshaker ... webSocketServerExtensionHandshakerArray) {
        this.extensionHandshakers = Arrays.asList(ObjectUtil.checkNonEmpty(webSocketServerExtensionHandshakerArray, "extensionHandshakers"));
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        String string;
        HttpRequest httpRequest;
        if (object instanceof HttpRequest && WebSocketExtensionUtil.isWebsocketUpgrade((httpRequest = (HttpRequest)object).headers()) && (string = httpRequest.headers().getAsString(HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS)) != null) {
            List<WebSocketExtensionData> list = WebSocketExtensionUtil.extractExtensions(string);
            int n = 0;
            for (WebSocketExtensionData webSocketExtensionData : list) {
                Iterator<WebSocketServerExtensionHandshaker> iterator = this.extensionHandshakers.iterator();
                WebSocketExtension webSocketExtension = null;
                while (webSocketExtension == null && iterator.hasNext()) {
                    WebSocketServerExtensionHandshaker webSocketServerExtensionHandshaker = iterator.next();
                    webSocketExtension = webSocketServerExtensionHandshaker.handshakeExtension(webSocketExtensionData);
                }
                if (webSocketExtension == null || (webSocketExtension.rsv() & n) != 0) continue;
                if (this.validExtensions == null) {
                    this.validExtensions = new ArrayList<WebSocketServerExtension>(1);
                }
                n |= webSocketExtension.rsv();
                this.validExtensions.add((WebSocketServerExtension)webSocketExtension);
            }
        }
        super.channelRead(channelHandlerContext, object);
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        HttpResponse httpResponse;
        if (object instanceof HttpResponse && HttpResponseStatus.SWITCHING_PROTOCOLS.equals((httpResponse = (HttpResponse)object).status())) {
            this.handlePotentialUpgrade(channelHandlerContext, channelPromise, httpResponse);
        }
        super.write(channelHandlerContext, object, channelPromise);
    }

    private void handlePotentialUpgrade(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise, HttpResponse httpResponse) {
        HttpHeaders httpHeaders = httpResponse.headers();
        if (WebSocketExtensionUtil.isWebsocketUpgrade(httpHeaders)) {
            if (this.validExtensions != null) {
                String string = httpHeaders.getAsString(HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS);
                ArrayList<WebSocketExtensionData> arrayList = new ArrayList<WebSocketExtensionData>(this.extensionHandshakers.size());
                for (WebSocketServerExtension webSocketServerExtension : this.validExtensions) {
                    arrayList.add(webSocketServerExtension.newReponseData());
                }
                String string2 = WebSocketExtensionUtil.computeMergeExtensionsHeaderValue(string, arrayList);
                channelPromise.addListener(new WebSocketServerExtensionHandler$1(this, channelHandlerContext));
                if (string2 != null) {
                    httpHeaders.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS, (Object)string2);
                }
            }
            channelPromise.addListener(new WebSocketServerExtensionHandler$2(this, channelHandlerContext));
        }
    }

    static /* synthetic */ List access$000(WebSocketServerExtensionHandler webSocketServerExtensionHandler) {
        return webSocketServerExtensionHandler.validExtensions;
    }
}

