/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.spdy;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import pro.gravit.repackage.io.netty.handler.codec.spdy.SpdySession;
import pro.gravit.repackage.io.netty.handler.codec.spdy.SpdySession$StreamComparator;
import pro.gravit.repackage.io.netty.handler.codec.spdy.SpdySession$StreamState;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;

final class SpdySession {
    private final AtomicInteger activeLocalStreams = new AtomicInteger();
    private final AtomicInteger activeRemoteStreams = new AtomicInteger();
    private final Map<Integer, SpdySession$StreamState> activeStreams = PlatformDependent.newConcurrentHashMap();
    private final SpdySession$StreamComparator streamComparator = new SpdySession$StreamComparator(this);
    private final AtomicInteger sendWindowSize;
    private final AtomicInteger receiveWindowSize;

    SpdySession(int n, int n2) {
        this.sendWindowSize = new AtomicInteger(n);
        this.receiveWindowSize = new AtomicInteger(n2);
    }

    int numActiveStreams(boolean bl) {
        if (bl) {
            return this.activeRemoteStreams.get();
        }
        return this.activeLocalStreams.get();
    }

    boolean noActiveStreams() {
        return this.activeStreams.isEmpty();
    }

    boolean isActiveStream(int n) {
        return this.activeStreams.containsKey(n);
    }

    Map<Integer, SpdySession$StreamState> activeStreams() {
        TreeMap<Integer, SpdySession$StreamState> treeMap = new TreeMap<Integer, SpdySession$StreamState>(this.streamComparator);
        treeMap.putAll(this.activeStreams);
        return treeMap;
    }

    void acceptStream(int n, byte by, boolean bl, boolean bl2, int n2, int n3, boolean bl3) {
        SpdySession$StreamState spdySession$StreamState;
        if (!(bl && bl2 || (spdySession$StreamState = this.activeStreams.put(n, new SpdySession$StreamState(by, bl, bl2, n2, n3))) != null)) {
            if (bl3) {
                this.activeRemoteStreams.incrementAndGet();
            } else {
                this.activeLocalStreams.incrementAndGet();
            }
        }
    }

    private SpdySession$StreamState removeActiveStream(int n, boolean bl) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.remove(n);
        if (spdySession$StreamState != null) {
            if (bl) {
                this.activeRemoteStreams.decrementAndGet();
            } else {
                this.activeLocalStreams.decrementAndGet();
            }
        }
        return spdySession$StreamState;
    }

    void removeStream(int n, Throwable throwable, boolean bl) {
        SpdySession$StreamState spdySession$StreamState = this.removeActiveStream(n, bl);
        if (spdySession$StreamState != null) {
            spdySession$StreamState.clearPendingWrites(throwable);
        }
    }

    boolean isRemoteSideClosed(int n) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n);
        return spdySession$StreamState == null || spdySession$StreamState.isRemoteSideClosed();
    }

    void closeRemoteSide(int n, boolean bl) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n);
        if (spdySession$StreamState != null) {
            spdySession$StreamState.closeRemoteSide();
            if (spdySession$StreamState.isLocalSideClosed()) {
                this.removeActiveStream(n, bl);
            }
        }
    }

    boolean isLocalSideClosed(int n) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n);
        return spdySession$StreamState == null || spdySession$StreamState.isLocalSideClosed();
    }

    void closeLocalSide(int n, boolean bl) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n);
        if (spdySession$StreamState != null) {
            spdySession$StreamState.closeLocalSide();
            if (spdySession$StreamState.isRemoteSideClosed()) {
                this.removeActiveStream(n, bl);
            }
        }
    }

    boolean hasReceivedReply(int n) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n);
        return spdySession$StreamState != null && spdySession$StreamState.hasReceivedReply();
    }

    void receivedReply(int n) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n);
        if (spdySession$StreamState != null) {
            spdySession$StreamState.receivedReply();
        }
    }

    int getSendWindowSize(int n) {
        if (n == 0) {
            return this.sendWindowSize.get();
        }
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n);
        return spdySession$StreamState != null ? spdySession$StreamState.getSendWindowSize() : -1;
    }

    int updateSendWindowSize(int n, int n2) {
        if (n == 0) {
            return this.sendWindowSize.addAndGet(n2);
        }
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n);
        return spdySession$StreamState != null ? spdySession$StreamState.updateSendWindowSize(n2) : -1;
    }

    int updateReceiveWindowSize(int n, int n2) {
        if (n == 0) {
            return this.receiveWindowSize.addAndGet(n2);
        }
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n);
        if (spdySession$StreamState == null) {
            return -1;
        }
        if (n2 > 0) {
            spdySession$StreamState.setReceiveWindowSizeLowerBound(0);
        }
        return spdySession$StreamState.updateReceiveWindowSize(n2);
    }

    int getReceiveWindowSizeLowerBound(int n) {
        if (n == 0) {
            return 0;
        }
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n);
        return spdySession$StreamState != null ? spdySession$StreamState.getReceiveWindowSizeLowerBound() : 0;
    }

    void updateAllSendWindowSizes(int n) {
        for (SpdySession$StreamState spdySession$StreamState : this.activeStreams.values()) {
            spdySession$StreamState.updateSendWindowSize(n);
        }
    }

    void updateAllReceiveWindowSizes(int n) {
        for (SpdySession$StreamState spdySession$StreamState : this.activeStreams.values()) {
            spdySession$StreamState.updateReceiveWindowSize(n);
            if (n >= 0) continue;
            spdySession$StreamState.setReceiveWindowSizeLowerBound(n);
        }
    }

    boolean putPendingWrite(int n, PendingWrite pendingWrite) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n);
        return spdySession$StreamState != null && spdySession$StreamState.putPendingWrite(pendingWrite);
    }

    PendingWrite getPendingWrite(int n) {
        if (n == 0) {
            for (Map.Entry<Integer, SpdySession$StreamState> entry : this.activeStreams().entrySet()) {
                PendingWrite pendingWrite;
                SpdySession$StreamState spdySession$StreamState = entry.getValue();
                if (spdySession$StreamState.getSendWindowSize() <= 0 || (pendingWrite = spdySession$StreamState.getPendingWrite()) == null) continue;
                return pendingWrite;
            }
            return null;
        }
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n);
        return spdySession$StreamState != null ? spdySession$StreamState.getPendingWrite() : null;
    }

    PendingWrite removePendingWrite(int n) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n);
        return spdySession$StreamState != null ? spdySession$StreamState.removePendingWrite() : null;
    }

    static /* synthetic */ Map access$000(SpdySession spdySession) {
        return spdySession.activeStreams;
    }
}

