/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ipfilter;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import pro.gravit.repackage.io.netty.handler.ipfilter.IpFilterRule;
import pro.gravit.repackage.io.netty.handler.ipfilter.IpFilterRuleType;
import pro.gravit.repackage.io.netty.handler.ipfilter.IpSubnetFilterRule$Ip4SubnetFilterRule;
import pro.gravit.repackage.io.netty.handler.ipfilter.IpSubnetFilterRule$Ip6SubnetFilterRule;
import pro.gravit.repackage.io.netty.util.NetUtil;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.SocketUtils;

public final class IpSubnetFilterRule
implements Comparable<IpSubnetFilterRule>,
IpFilterRule {
    private final IpFilterRule filterRule;
    private final String ipAddress;

    public IpSubnetFilterRule(String string, int n, IpFilterRuleType ipFilterRuleType) {
        try {
            this.ipAddress = string;
            this.filterRule = IpSubnetFilterRule.selectFilterRule(SocketUtils.addressByName(string), n, ipFilterRuleType);
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException("ipAddress", unknownHostException);
        }
    }

    public IpSubnetFilterRule(InetAddress inetAddress, int n, IpFilterRuleType ipFilterRuleType) {
        this.ipAddress = inetAddress.getHostAddress();
        this.filterRule = IpSubnetFilterRule.selectFilterRule(inetAddress, n, ipFilterRuleType);
    }

    private static IpFilterRule selectFilterRule(InetAddress inetAddress, int n, IpFilterRuleType ipFilterRuleType) {
        ObjectUtil.checkNotNull(inetAddress, "ipAddress");
        ObjectUtil.checkNotNull(ipFilterRuleType, "ruleType");
        if (inetAddress instanceof Inet4Address) {
            return new IpSubnetFilterRule$Ip4SubnetFilterRule((Inet4Address)inetAddress, n, ipFilterRuleType, null);
        }
        if (inetAddress instanceof Inet6Address) {
            return new IpSubnetFilterRule$Ip6SubnetFilterRule((Inet6Address)inetAddress, n, ipFilterRuleType, null);
        }
        throw new IllegalArgumentException("Only IPv4 and IPv6 addresses are supported");
    }

    @Override
    public boolean matches(InetSocketAddress inetSocketAddress) {
        return this.filterRule.matches(inetSocketAddress);
    }

    @Override
    public IpFilterRuleType ruleType() {
        return this.filterRule.ruleType();
    }

    String getIpAddress() {
        return this.ipAddress;
    }

    IpFilterRule getFilterRule() {
        return this.filterRule;
    }

    @Override
    public int compareTo(IpSubnetFilterRule ipSubnetFilterRule) {
        if (this.filterRule instanceof IpSubnetFilterRule$Ip4SubnetFilterRule) {
            return IpSubnetFilterRule.compareInt(IpSubnetFilterRule$Ip4SubnetFilterRule.access$200((IpSubnetFilterRule$Ip4SubnetFilterRule)this.filterRule), IpSubnetFilterRule$Ip4SubnetFilterRule.access$200((IpSubnetFilterRule$Ip4SubnetFilterRule)ipSubnetFilterRule.filterRule));
        }
        return IpSubnetFilterRule$Ip6SubnetFilterRule.access$300((IpSubnetFilterRule$Ip6SubnetFilterRule)this.filterRule).compareTo(IpSubnetFilterRule$Ip6SubnetFilterRule.access$300((IpSubnetFilterRule$Ip6SubnetFilterRule)ipSubnetFilterRule.filterRule));
    }

    @Override
    int compareTo(InetSocketAddress inetSocketAddress) {
        if (this.filterRule instanceof IpSubnetFilterRule$Ip4SubnetFilterRule) {
            IpSubnetFilterRule$Ip4SubnetFilterRule ipSubnetFilterRule$Ip4SubnetFilterRule = (IpSubnetFilterRule$Ip4SubnetFilterRule)this.filterRule;
            return IpSubnetFilterRule.compareInt(IpSubnetFilterRule$Ip4SubnetFilterRule.access$200(ipSubnetFilterRule$Ip4SubnetFilterRule), NetUtil.ipv4AddressToInt((Inet4Address)inetSocketAddress.getAddress()) & IpSubnetFilterRule$Ip4SubnetFilterRule.access$400(ipSubnetFilterRule$Ip4SubnetFilterRule));
        }
        IpSubnetFilterRule$Ip6SubnetFilterRule ipSubnetFilterRule$Ip6SubnetFilterRule = (IpSubnetFilterRule$Ip6SubnetFilterRule)this.filterRule;
        return IpSubnetFilterRule$Ip6SubnetFilterRule.access$300(ipSubnetFilterRule$Ip6SubnetFilterRule).compareTo(IpSubnetFilterRule$Ip6SubnetFilterRule.access$500((Inet6Address)inetSocketAddress.getAddress()).and(IpSubnetFilterRule$Ip6SubnetFilterRule.access$300(ipSubnetFilterRule$Ip6SubnetFilterRule)));
    }

    private static int compareInt(int n, int n2) {
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }
}

