/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ipfilter;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import pro.gravit.repackage.io.netty.channel.ChannelHandler;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.handler.ipfilter.AbstractRemoteAddressFilter;
import pro.gravit.repackage.io.netty.handler.ipfilter.IpFilterRule;
import pro.gravit.repackage.io.netty.handler.ipfilter.IpFilterRuleType;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public class RuleBasedIpFilter
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    private final boolean acceptIfNotFound;
    private final List<IpFilterRule> rules;

    public RuleBasedIpFilter(IpFilterRule ... ipFilterRuleArray) {
        this(true, ipFilterRuleArray);
    }

    public RuleBasedIpFilter(boolean bl, IpFilterRule ... ipFilterRuleArray) {
        ObjectUtil.checkNotNull(ipFilterRuleArray, "rules");
        this.acceptIfNotFound = bl;
        this.rules = new ArrayList<IpFilterRule>(ipFilterRuleArray.length);
        for (IpFilterRule ipFilterRule : ipFilterRuleArray) {
            if (ipFilterRule == null) continue;
            this.rules.add(ipFilterRule);
        }
    }

    @Override
    protected boolean accept(ChannelHandlerContext channelHandlerContext, InetSocketAddress inetSocketAddress) {
        for (IpFilterRule ipFilterRule : this.rules) {
            if (!ipFilterRule.matches(inetSocketAddress)) continue;
            return ipFilterRule.ruleType() == IpFilterRuleType.ACCEPT;
        }
        return this.acceptIfNotFound;
    }
}

