/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.pcap;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.channel.ChannelDuplexHandler;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.channel.socket.DatagramChannel;
import pro.gravit.repackage.io.netty.channel.socket.DatagramPacket;
import pro.gravit.repackage.io.netty.channel.socket.ServerSocketChannel;
import pro.gravit.repackage.io.netty.channel.socket.SocketChannel;
import pro.gravit.repackage.io.netty.handler.pcap.EthernetPacket;
import pro.gravit.repackage.io.netty.handler.pcap.IPPacket;
import pro.gravit.repackage.io.netty.handler.pcap.PcapWriter;
import pro.gravit.repackage.io.netty.handler.pcap.TCPPacket;
import pro.gravit.repackage.io.netty.handler.pcap.TCPPacket$TCPFlag;
import pro.gravit.repackage.io.netty.handler.pcap.UDPPacket;
import pro.gravit.repackage.io.netty.util.NetUtil;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public final class PcapWriteHandler
extends ChannelDuplexHandler
implements Closeable {
    private final InternalLogger logger = InternalLoggerFactory.getInstance(PcapWriteHandler.class);
    private PcapWriter pCapWriter;
    private final OutputStream outputStream;
    private final boolean captureZeroByte;
    private final boolean writePcapGlobalHeader;
    private int sendSegmentNumber = 1;
    private int receiveSegmentNumber = 1;
    private InetSocketAddress srcAddr;
    private InetSocketAddress dstAddr;
    private boolean isClosed;

    public PcapWriteHandler(OutputStream outputStream) {
        this(outputStream, false, true);
    }

    public PcapWriteHandler(OutputStream outputStream, boolean bl, boolean bl2) {
        this.outputStream = ObjectUtil.checkNotNull(outputStream, "OutputStream");
        this.captureZeroByte = bl;
        this.writePcapGlobalHeader = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelActive(ChannelHandlerContext channelHandlerContext) {
        Comparable<ByteBuf> comparable;
        ByteBufAllocator byteBufAllocator = channelHandlerContext.alloc();
        if (this.writePcapGlobalHeader) {
            comparable = byteBufAllocator.buffer();
            try {
                this.pCapWriter = new PcapWriter(this.outputStream, (ByteBuf)comparable);
            }
            catch (IOException iOException) {
                channelHandlerContext.channel().close();
                channelHandlerContext.fireExceptionCaught(iOException);
                this.logger.error("Caught Exception While Initializing PcapWriter, Closing Channel.", iOException);
            }
            finally {
                comparable.release();
            }
        } else {
            this.pCapWriter = new PcapWriter(this.outputStream);
        }
        if (channelHandlerContext.channel() instanceof SocketChannel) {
            if (channelHandlerContext.channel().parent() instanceof ServerSocketChannel) {
                this.srcAddr = (InetSocketAddress)channelHandlerContext.channel().remoteAddress();
                this.dstAddr = (InetSocketAddress)channelHandlerContext.channel().localAddress();
            } else {
                this.srcAddr = (InetSocketAddress)channelHandlerContext.channel().localAddress();
                this.dstAddr = (InetSocketAddress)channelHandlerContext.channel().remoteAddress();
            }
            this.logger.debug("Initiating Fake TCP 3-Way Handshake");
            comparable = byteBufAllocator.buffer();
            try {
                TCPPacket.writePacket(comparable, null, 0, 0, this.srcAddr.getPort(), this.dstAddr.getPort(), new TCPPacket$TCPFlag[]{TCPPacket$TCPFlag.SYN});
                this.completeTCPWrite(this.srcAddr, this.dstAddr, (ByteBuf)comparable, byteBufAllocator, channelHandlerContext);
                TCPPacket.writePacket(comparable, null, 0, 1, this.dstAddr.getPort(), this.srcAddr.getPort(), new TCPPacket$TCPFlag[]{TCPPacket$TCPFlag.SYN, TCPPacket$TCPFlag.ACK});
                this.completeTCPWrite(this.dstAddr, this.srcAddr, (ByteBuf)comparable, byteBufAllocator, channelHandlerContext);
                TCPPacket.writePacket(comparable, null, 1, 1, this.srcAddr.getPort(), this.dstAddr.getPort(), new TCPPacket$TCPFlag[]{TCPPacket$TCPFlag.ACK});
                this.completeTCPWrite(this.srcAddr, this.dstAddr, (ByteBuf)comparable, byteBufAllocator, channelHandlerContext);
            }
            finally {
                comparable.release();
            }
            this.logger.debug("Finished Fake TCP 3-Way Handshake");
        } else if (channelHandlerContext.channel() instanceof DatagramChannel && (comparable = (DatagramChannel)channelHandlerContext.channel()).isConnected()) {
            this.srcAddr = (InetSocketAddress)channelHandlerContext.channel().localAddress();
            this.dstAddr = (InetSocketAddress)channelHandlerContext.channel().remoteAddress();
        }
        super.channelActive(channelHandlerContext);
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        if (!this.isClosed) {
            if (channelHandlerContext.channel() instanceof SocketChannel) {
                this.handleTCP(channelHandlerContext, object, false);
            } else if (channelHandlerContext.channel() instanceof DatagramChannel) {
                this.handleUDP(channelHandlerContext, object);
            } else {
                this.logger.debug("Discarding Pcap Write for Unknown Channel Type: {}", (Object)channelHandlerContext.channel());
            }
        }
        super.channelRead(channelHandlerContext, object);
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (!this.isClosed) {
            if (channelHandlerContext.channel() instanceof SocketChannel) {
                this.handleTCP(channelHandlerContext, object, true);
            } else if (channelHandlerContext.channel() instanceof DatagramChannel) {
                this.handleUDP(channelHandlerContext, object);
            } else {
                this.logger.debug("Discarding Pcap Write for Unknown Channel Type: {}", (Object)channelHandlerContext.channel());
            }
        }
        super.write(channelHandlerContext, object, channelPromise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTCP(ChannelHandlerContext channelHandlerContext, Object object, boolean bl) {
        if (object instanceof ByteBuf) {
            if (((ByteBuf)object).readableBytes() == 0 && !this.captureZeroByte) {
                this.logger.debug("Discarding Zero Byte TCP Packet. isWriteOperation {}", (Object)bl);
                return;
            }
            ByteBufAllocator byteBufAllocator = channelHandlerContext.alloc();
            ByteBuf byteBuf = ((ByteBuf)object).duplicate();
            ByteBuf byteBuf2 = byteBufAllocator.buffer();
            int n = byteBuf.readableBytes();
            try {
                if (bl) {
                    TCPPacket.writePacket(byteBuf2, byteBuf, this.sendSegmentNumber, this.receiveSegmentNumber, this.srcAddr.getPort(), this.dstAddr.getPort(), TCPPacket$TCPFlag.ACK);
                    this.completeTCPWrite(this.srcAddr, this.dstAddr, byteBuf2, byteBufAllocator, channelHandlerContext);
                    this.logTCP(true, n, this.sendSegmentNumber, this.receiveSegmentNumber, this.srcAddr, this.dstAddr, false);
                    this.sendSegmentNumber += n;
                    TCPPacket.writePacket(byteBuf2, null, this.receiveSegmentNumber, this.sendSegmentNumber, this.dstAddr.getPort(), this.srcAddr.getPort(), TCPPacket$TCPFlag.ACK);
                    this.completeTCPWrite(this.dstAddr, this.srcAddr, byteBuf2, byteBufAllocator, channelHandlerContext);
                    this.logTCP(true, n, this.sendSegmentNumber, this.receiveSegmentNumber, this.dstAddr, this.srcAddr, true);
                }
                TCPPacket.writePacket(byteBuf2, byteBuf, this.receiveSegmentNumber, this.sendSegmentNumber, this.dstAddr.getPort(), this.srcAddr.getPort(), TCPPacket$TCPFlag.ACK);
                this.completeTCPWrite(this.dstAddr, this.srcAddr, byteBuf2, byteBufAllocator, channelHandlerContext);
                this.logTCP(false, n, this.receiveSegmentNumber, this.sendSegmentNumber, this.dstAddr, this.srcAddr, false);
                this.receiveSegmentNumber += n;
                TCPPacket.writePacket(byteBuf2, null, this.sendSegmentNumber, this.receiveSegmentNumber, this.srcAddr.getPort(), this.dstAddr.getPort(), TCPPacket$TCPFlag.ACK);
                this.completeTCPWrite(this.srcAddr, this.dstAddr, byteBuf2, byteBufAllocator, channelHandlerContext);
                this.logTCP(false, n, this.sendSegmentNumber, this.receiveSegmentNumber, this.srcAddr, this.dstAddr, true);
            }
            finally {
                byteBuf2.release();
            }
        } else {
            this.logger.debug("Discarding Pcap Write for TCP Object: {}", object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeTCPWrite(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, ByteBuf byteBuf, ByteBufAllocator byteBufAllocator, ChannelHandlerContext channelHandlerContext) {
        ByteBuf byteBuf2 = byteBufAllocator.buffer();
        ByteBuf byteBuf3 = byteBufAllocator.buffer();
        ByteBuf byteBuf4 = byteBufAllocator.buffer();
        try {
            if (inetSocketAddress.getAddress() instanceof Inet4Address && inetSocketAddress2.getAddress() instanceof Inet4Address) {
                IPPacket.writeTCPv4(byteBuf2, byteBuf, NetUtil.ipv4AddressToInt((Inet4Address)inetSocketAddress.getAddress()), NetUtil.ipv4AddressToInt((Inet4Address)inetSocketAddress2.getAddress()));
                EthernetPacket.writeIPv4(byteBuf3, byteBuf2);
            } else if (inetSocketAddress.getAddress() instanceof Inet6Address && inetSocketAddress2.getAddress() instanceof Inet6Address) {
                IPPacket.writeTCPv6(byteBuf2, byteBuf, inetSocketAddress.getAddress().getAddress(), inetSocketAddress2.getAddress().getAddress());
                EthernetPacket.writeIPv6(byteBuf3, byteBuf2);
            } else {
                this.logger.error("Source and Destination IP Address versions are not same. Source Address: {}, Destination Address: {}", (Object)inetSocketAddress.getAddress(), (Object)inetSocketAddress2.getAddress());
                return;
            }
            this.pCapWriter.writePacket(byteBuf4, byteBuf3);
        }
        catch (IOException iOException) {
            this.logger.error("Caught Exception While Writing Packet into Pcap", iOException);
            channelHandlerContext.fireExceptionCaught(iOException);
        }
        finally {
            byteBuf2.release();
            byteBuf3.release();
            byteBuf4.release();
        }
    }

    private void logTCP(boolean bl, int n, int n2, int n3, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, boolean bl2) {
        if (this.logger.isDebugEnabled()) {
            if (bl2) {
                this.logger.debug("Writing TCP ACK, isWriteOperation {}, Segment Number {}, Ack Number {}, Src Addr {}, Dst Addr {}", bl, n2, n3, inetSocketAddress2, inetSocketAddress);
            } else {
                this.logger.debug("Writing TCP Data of {} Bytes, isWriteOperation {}, Segment Number {}, Ack Number {}, Src Addr {}, Dst Addr {}", n, bl, n2, n3, inetSocketAddress, inetSocketAddress2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUDP(ChannelHandlerContext channelHandlerContext, Object object) {
        ByteBuf byteBuf = channelHandlerContext.alloc().buffer();
        try {
            if (object instanceof DatagramPacket) {
                if (((ByteBuf)((DatagramPacket)object).content()).readableBytes() == 0 && !this.captureZeroByte) {
                    this.logger.debug("Discarding Zero Byte UDP Packet");
                    return;
                }
                DatagramPacket datagramPacket = ((DatagramPacket)object).duplicate();
                InetSocketAddress inetSocketAddress = (InetSocketAddress)datagramPacket.sender();
                InetSocketAddress inetSocketAddress2 = (InetSocketAddress)datagramPacket.recipient();
                if (inetSocketAddress == null) {
                    inetSocketAddress = (InetSocketAddress)channelHandlerContext.channel().localAddress();
                }
                this.logger.debug("Writing UDP Data of {} Bytes, Src Addr {}, Dst Addr {}", ((ByteBuf)datagramPacket.content()).readableBytes(), inetSocketAddress, inetSocketAddress2);
                UDPPacket.writePacket(byteBuf, (ByteBuf)datagramPacket.content(), inetSocketAddress.getPort(), inetSocketAddress2.getPort());
                this.completeUDPWrite(inetSocketAddress, inetSocketAddress2, byteBuf, channelHandlerContext.alloc(), channelHandlerContext);
            } else if (object instanceof ByteBuf && ((DatagramChannel)channelHandlerContext.channel()).isConnected()) {
                if (((ByteBuf)object).readableBytes() == 0 && !this.captureZeroByte) {
                    this.logger.debug("Discarding Zero Byte UDP Packet");
                    return;
                }
                ByteBuf byteBuf2 = ((ByteBuf)object).duplicate();
                this.logger.debug("Writing UDP Data of {} Bytes, Src Addr {}, Dst Addr {}", byteBuf2.readableBytes(), this.srcAddr, this.dstAddr);
                UDPPacket.writePacket(byteBuf, byteBuf2, this.srcAddr.getPort(), this.dstAddr.getPort());
                this.completeUDPWrite(this.srcAddr, this.dstAddr, byteBuf, channelHandlerContext.alloc(), channelHandlerContext);
            } else {
                this.logger.debug("Discarding Pcap Write for UDP Object: {}", object);
            }
        }
        finally {
            byteBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeUDPWrite(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, ByteBuf byteBuf, ByteBufAllocator byteBufAllocator, ChannelHandlerContext channelHandlerContext) {
        ByteBuf byteBuf2 = byteBufAllocator.buffer();
        ByteBuf byteBuf3 = byteBufAllocator.buffer();
        ByteBuf byteBuf4 = byteBufAllocator.buffer();
        try {
            if (inetSocketAddress.getAddress() instanceof Inet4Address && inetSocketAddress2.getAddress() instanceof Inet4Address) {
                IPPacket.writeUDPv4(byteBuf2, byteBuf, NetUtil.ipv4AddressToInt((Inet4Address)inetSocketAddress.getAddress()), NetUtil.ipv4AddressToInt((Inet4Address)inetSocketAddress2.getAddress()));
                EthernetPacket.writeIPv4(byteBuf3, byteBuf2);
            } else if (inetSocketAddress.getAddress() instanceof Inet6Address && inetSocketAddress2.getAddress() instanceof Inet6Address) {
                IPPacket.writeUDPv6(byteBuf2, byteBuf, inetSocketAddress.getAddress().getAddress(), inetSocketAddress2.getAddress().getAddress());
                EthernetPacket.writeIPv6(byteBuf3, byteBuf2);
            } else {
                this.logger.error("Source and Destination IP Address versions are not same. Source Address: {}, Destination Address: {}", (Object)inetSocketAddress.getAddress(), (Object)inetSocketAddress2.getAddress());
                return;
            }
            this.pCapWriter.writePacket(byteBuf4, byteBuf3);
        }
        catch (IOException iOException) {
            this.logger.error("Caught Exception While Writing Packet into Pcap", iOException);
            channelHandlerContext.fireExceptionCaught(iOException);
        }
        finally {
            byteBuf2.release();
            byteBuf3.release();
            byteBuf4.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.channel() instanceof SocketChannel) {
            this.logger.debug("Starting Fake TCP FIN+ACK Flow to close connection");
            ByteBufAllocator byteBufAllocator = channelHandlerContext.alloc();
            ByteBuf byteBuf = byteBufAllocator.buffer();
            try {
                TCPPacket.writePacket(byteBuf, null, this.sendSegmentNumber, this.receiveSegmentNumber, this.srcAddr.getPort(), this.dstAddr.getPort(), TCPPacket$TCPFlag.FIN, TCPPacket$TCPFlag.ACK);
                this.completeTCPWrite(this.srcAddr, this.dstAddr, byteBuf, byteBufAllocator, channelHandlerContext);
                TCPPacket.writePacket(byteBuf, null, this.receiveSegmentNumber, this.sendSegmentNumber, this.dstAddr.getPort(), this.srcAddr.getPort(), TCPPacket$TCPFlag.FIN, TCPPacket$TCPFlag.ACK);
                this.completeTCPWrite(this.dstAddr, this.srcAddr, byteBuf, byteBufAllocator, channelHandlerContext);
                TCPPacket.writePacket(byteBuf, null, this.sendSegmentNumber + 1, this.receiveSegmentNumber + 1, this.srcAddr.getPort(), this.dstAddr.getPort(), TCPPacket$TCPFlag.ACK);
                this.completeTCPWrite(this.srcAddr, this.dstAddr, byteBuf, byteBufAllocator, channelHandlerContext);
            }
            finally {
                byteBuf.release();
            }
            this.logger.debug("Finished Fake TCP FIN+ACK Flow to close connection");
        }
        this.close();
        super.handlerRemoved(channelHandlerContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        if (channelHandlerContext.channel() instanceof SocketChannel) {
            ByteBuf byteBuf = channelHandlerContext.alloc().buffer();
            try {
                TCPPacket.writePacket(byteBuf, null, this.sendSegmentNumber, this.receiveSegmentNumber, this.srcAddr.getPort(), this.dstAddr.getPort(), TCPPacket$TCPFlag.RST, TCPPacket$TCPFlag.ACK);
                this.completeTCPWrite(this.srcAddr, this.dstAddr, byteBuf, channelHandlerContext.alloc(), channelHandlerContext);
            }
            finally {
                byteBuf.release();
            }
            this.logger.debug("Sent Fake TCP RST to close connection");
        }
        this.close();
        channelHandlerContext.fireExceptionCaught(throwable);
    }

    @Override
    public void close() {
        if (this.isClosed) {
            this.logger.debug("PcapWriterHandler is already closed");
        } else {
            this.isClosed = true;
            this.pCapWriter.close();
            this.logger.debug("PcapWriterHandler is now closed");
        }
    }
}

