/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl;

import java.util.Locale;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.handler.ssl.SniCompletionEvent;
import pro.gravit.repackage.io.netty.handler.ssl.SslClientHelloHandler;
import pro.gravit.repackage.io.netty.util.CharsetUtil;
import pro.gravit.repackage.io.netty.util.concurrent.Future;

public abstract class AbstractSniHandler<T>
extends SslClientHelloHandler<T> {
    private String hostname;

    private static String extractSniHostname(ByteBuf byteBuf) {
        int n = byteBuf.readerIndex();
        int n2 = byteBuf.writerIndex();
        if (n2 - (n += 34) >= 6) {
            int n3;
            int n4;
            short s = byteBuf.getUnsignedByte(n);
            int n5 = byteBuf.getUnsignedShort(n += s + 1);
            short s2 = byteBuf.getUnsignedByte(n += n5 + 2);
            n += s2 + 1;
            if ((n4 = (n += 2) + (n3 = byteBuf.getUnsignedShort(n))) <= n2) {
                while (n4 - n >= 4) {
                    int n6;
                    int n7 = byteBuf.getUnsignedShort(n);
                    n += 2;
                    if (n4 - (n += 2) < (n6 = byteBuf.getUnsignedShort(n))) break;
                    if (n7 == 0) {
                        int n8;
                        if (n4 - (n += 2) < 3) break;
                        short s3 = byteBuf.getUnsignedByte(n);
                        ++n;
                        if (s3 != 0 || n4 - (n += 2) < (n8 = byteBuf.getUnsignedShort(n))) break;
                        String string = byteBuf.toString(n, n8, CharsetUtil.US_ASCII);
                        return string.toLowerCase(Locale.US);
                    }
                    n += n6;
                }
            }
        }
        return null;
    }

    @Override
    protected Future<T> lookup(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        this.hostname = byteBuf == null ? null : AbstractSniHandler.extractSniHostname(byteBuf);
        return this.lookup(channelHandlerContext, this.hostname);
    }

    @Override
    protected void onLookupComplete(ChannelHandlerContext channelHandlerContext, Future<T> future) {
        try {
            this.onLookupComplete(channelHandlerContext, this.hostname, future);
        }
        finally {
            AbstractSniHandler.fireSniCompletionEvent(channelHandlerContext, this.hostname, future);
        }
    }

    protected abstract Future<T> lookup(ChannelHandlerContext var1, String var2);

    protected abstract void onLookupComplete(ChannelHandlerContext var1, String var2, Future<T> var3);

    private static void fireSniCompletionEvent(ChannelHandlerContext channelHandlerContext, String string, Future<?> future) {
        Throwable throwable = future.cause();
        if (throwable == null) {
            channelHandlerContext.fireUserEventTriggered(new SniCompletionEvent(string));
        } else {
            channelHandlerContext.fireUserEventTriggered(new SniCompletionEvent(string, throwable));
        }
    }
}

