/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl;

import java.security.cert.X509Certificate;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslKeyMaterial;
import pro.gravit.repackage.io.netty.internal.tcnative.SSL;
import pro.gravit.repackage.io.netty.util.AbstractReferenceCounted;
import pro.gravit.repackage.io.netty.util.IllegalReferenceCountException;
import pro.gravit.repackage.io.netty.util.ResourceLeakDetector;
import pro.gravit.repackage.io.netty.util.ResourceLeakDetectorFactory;
import pro.gravit.repackage.io.netty.util.ResourceLeakTracker;

final class DefaultOpenSslKeyMaterial
extends AbstractReferenceCounted
implements OpenSslKeyMaterial {
    private static final ResourceLeakDetector<DefaultOpenSslKeyMaterial> leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(DefaultOpenSslKeyMaterial.class);
    private final ResourceLeakTracker<DefaultOpenSslKeyMaterial> leak;
    private final X509Certificate[] x509CertificateChain;
    private long chain;
    private long privateKey;

    DefaultOpenSslKeyMaterial(long l, long l2, X509Certificate[] x509CertificateArray) {
        this.chain = l;
        this.privateKey = l2;
        this.x509CertificateChain = x509CertificateArray;
        this.leak = leakDetector.track(this);
    }

    @Override
    public X509Certificate[] certificateChain() {
        return (X509Certificate[])this.x509CertificateChain.clone();
    }

    @Override
    public long certificateChainAddress() {
        if (this.refCnt() <= 0) {
            throw new IllegalReferenceCountException();
        }
        return this.chain;
    }

    @Override
    public long privateKeyAddress() {
        if (this.refCnt() <= 0) {
            throw new IllegalReferenceCountException();
        }
        return this.privateKey;
    }

    @Override
    protected void deallocate() {
        SSL.freeX509Chain((long)this.chain);
        this.chain = 0L;
        SSL.freePrivateKey((long)this.privateKey);
        this.privateKey = 0L;
        if (this.leak != null) {
            boolean bl = this.leak.close(this);
            assert (bl);
        }
    }

    @Override
    public DefaultOpenSslKeyMaterial retain() {
        if (this.leak != null) {
            this.leak.record();
        }
        super.retain();
        return this;
    }

    @Override
    public DefaultOpenSslKeyMaterial retain(int n) {
        if (this.leak != null) {
            this.leak.record();
        }
        super.retain(n);
        return this;
    }

    @Override
    public DefaultOpenSslKeyMaterial touch() {
        if (this.leak != null) {
            this.leak.record();
        }
        super.touch();
        return this;
    }

    @Override
    public DefaultOpenSslKeyMaterial touch(Object object) {
        if (this.leak != null) {
            this.leak.record(object);
        }
        return this;
    }

    @Override
    public boolean release() {
        if (this.leak != null) {
            this.leak.record();
        }
        return super.release();
    }

    @Override
    public boolean release(int n) {
        if (this.leak != null) {
            this.leak.record();
        }
        return super.release(n);
    }
}

