/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl;

import java.net.SocketAddress;
import java.util.List;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufUtil;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelOutboundHandler;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.handler.codec.ByteToMessageDecoder;
import pro.gravit.repackage.io.netty.handler.ssl.NotSslRecordException;
import pro.gravit.repackage.io.netty.handler.ssl.SniCompletionEvent;
import pro.gravit.repackage.io.netty.handler.ssl.SslClientHelloHandler$1;
import pro.gravit.repackage.io.netty.handler.ssl.SslUtils;
import pro.gravit.repackage.io.netty.util.concurrent.Future;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public abstract class SslClientHelloHandler<T>
extends ByteToMessageDecoder
implements ChannelOutboundHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SslClientHelloHandler.class);
    private boolean handshakeFailed;
    private boolean suppressRead;
    private boolean readPending;
    private ByteBuf handshakeBuffer;

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (!this.suppressRead && !this.handshakeFailed) {
            try {
                int n;
                int n2 = byteBuf.readerIndex();
                int n3 = -1;
                block7: for (int i = byteBuf.readableBytes(); i >= 5; i -= n) {
                    short s = byteBuf.getUnsignedByte(n2);
                    switch (s) {
                        case 20: 
                        case 21: {
                            int n4 = SslUtils.getEncryptedPacketLength(byteBuf, n2);
                            if (n4 == -2) {
                                this.handshakeFailed = true;
                                NotSslRecordException notSslRecordException = new NotSslRecordException("not an SSL/TLS record: " + ByteBufUtil.hexDump(byteBuf));
                                byteBuf.skipBytes(byteBuf.readableBytes());
                                channelHandlerContext.fireUserEventTriggered(new SniCompletionEvent(notSslRecordException));
                                SslUtils.handleHandshakeFailure(channelHandlerContext, notSslRecordException, true);
                                throw notSslRecordException;
                            }
                            if (n4 == -1) {
                                return;
                            }
                            this.select(channelHandlerContext, null);
                            return;
                        }
                        case 22: {
                            short s2 = byteBuf.getUnsignedByte(n2 + 1);
                            if (s2 != 3) break;
                            n = byteBuf.getUnsignedShort(n2 + 3) + 5;
                            if (i < n) {
                                return;
                            }
                            if (n == 5) {
                                this.select(channelHandlerContext, null);
                                return;
                            }
                            int n5 = n2 + n;
                            if (n3 == -1) {
                                if (n2 + 4 > n5) {
                                    return;
                                }
                                short s3 = byteBuf.getUnsignedByte(n2 + 5);
                                if (s3 != 1) {
                                    this.select(channelHandlerContext, null);
                                    return;
                                }
                                n3 = byteBuf.getUnsignedMedium(n2 + 5 + 1);
                                n2 += 4;
                                if (n3 + 4 + 5 <= (n -= 4)) {
                                    this.select(channelHandlerContext, byteBuf.retainedSlice(n2 += 5, n3));
                                    return;
                                }
                                if (this.handshakeBuffer == null) {
                                    this.handshakeBuffer = channelHandlerContext.alloc().buffer(n3);
                                } else {
                                    this.handshakeBuffer.clear();
                                }
                            }
                            this.handshakeBuffer.writeBytes(byteBuf, n2 + 5, n - 5);
                            n2 += n;
                            if (n3 > this.handshakeBuffer.readableBytes()) continue block7;
                            ByteBuf byteBuf2 = this.handshakeBuffer.setIndex(0, n3);
                            this.handshakeBuffer = null;
                            this.select(channelHandlerContext, byteBuf2);
                            return;
                        }
                    }
                    this.select(channelHandlerContext, null);
                    return;
                }
            }
            catch (NotSslRecordException notSslRecordException) {
                throw notSslRecordException;
            }
            catch (Exception exception) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Unexpected client hello packet: " + ByteBufUtil.hexDump(byteBuf), exception);
                }
                this.select(channelHandlerContext, null);
            }
        }
    }

    private void releaseHandshakeBuffer() {
        SslClientHelloHandler.releaseIfNotNull(this.handshakeBuffer);
        this.handshakeBuffer = null;
    }

    private static void releaseIfNotNull(ByteBuf byteBuf) {
        if (byteBuf != null) {
            byteBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void select(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        try {
            Future<T> future = this.lookup(channelHandlerContext, byteBuf);
            if (future.isDone()) {
                this.onLookupComplete(channelHandlerContext, future);
            } else {
                this.suppressRead = true;
                ByteBuf byteBuf2 = byteBuf;
                future.addListener(new SslClientHelloHandler$1(this, byteBuf2, channelHandlerContext));
                byteBuf = null;
            }
        }
        catch (Throwable throwable) {
            PlatformDependent.throwException(throwable);
        }
        finally {
            SslClientHelloHandler.releaseIfNotNull(byteBuf);
        }
    }

    @Override
    protected void handlerRemoved0(ChannelHandlerContext channelHandlerContext) {
        this.releaseHandshakeBuffer();
        super.handlerRemoved0(channelHandlerContext);
    }

    protected abstract Future<T> lookup(ChannelHandlerContext var1, ByteBuf var2);

    protected abstract void onLookupComplete(ChannelHandlerContext var1, Future<T> var2);

    @Override
    public void read(ChannelHandlerContext channelHandlerContext) {
        if (this.suppressRead) {
            this.readPending = true;
        } else {
            channelHandlerContext.read();
        }
    }

    @Override
    public void bind(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, ChannelPromise channelPromise) {
        channelHandlerContext.bind(socketAddress, channelPromise);
    }

    @Override
    public void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        channelHandlerContext.connect(socketAddress, socketAddress2, channelPromise);
    }

    @Override
    public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.disconnect(channelPromise);
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.close(channelPromise);
    }

    @Override
    public void deregister(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.deregister(channelPromise);
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        channelHandlerContext.write(object, channelPromise);
    }

    @Override
    public void flush(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.flush();
    }

    static /* synthetic */ void access$000(ByteBuf byteBuf) {
        SslClientHelloHandler.releaseIfNotNull(byteBuf);
    }

    static /* synthetic */ boolean access$102(SslClientHelloHandler sslClientHelloHandler, boolean bl) {
        sslClientHelloHandler.suppressRead = bl;
        return sslClientHelloHandler.suppressRead;
    }

    static /* synthetic */ boolean access$200(SslClientHelloHandler sslClientHelloHandler) {
        return sslClientHelloHandler.readPending;
    }

    static /* synthetic */ boolean access$202(SslClientHelloHandler sslClientHelloHandler, boolean bl) {
        sslClientHelloHandler.readPending = bl;
        return sslClientHelloHandler.readPending;
    }
}

