/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl.util;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import pro.gravit.repackage.io.netty.handler.ssl.util.SimpleKeyManagerFactory;
import pro.gravit.repackage.io.netty.handler.ssl.util.X509KeyManagerWrapper;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.SuppressJava6Requirement;

final class SimpleKeyManagerFactory$SimpleKeyManagerFactorySpi
extends KeyManagerFactorySpi {
    private SimpleKeyManagerFactory parent;
    private volatile KeyManager[] keyManagers;

    private SimpleKeyManagerFactory$SimpleKeyManagerFactorySpi() {
    }

    void init(SimpleKeyManagerFactory simpleKeyManagerFactory) {
        this.parent = simpleKeyManagerFactory;
    }

    @Override
    protected void engineInit(KeyStore keyStore, char[] cArray) {
        try {
            this.parent.engineInit(keyStore, cArray);
        }
        catch (KeyStoreException keyStoreException) {
            throw keyStoreException;
        }
        catch (Exception exception) {
            throw new KeyStoreException(exception);
        }
    }

    @Override
    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) {
        try {
            this.parent.engineInit(managerFactoryParameters);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw invalidAlgorithmParameterException;
        }
        catch (Exception exception) {
            throw new InvalidAlgorithmParameterException(exception);
        }
    }

    @Override
    protected KeyManager[] engineGetKeyManagers() {
        KeyManager[] keyManagerArray = this.keyManagers;
        if (keyManagerArray == null) {
            keyManagerArray = this.parent.engineGetKeyManagers();
            if (PlatformDependent.javaVersion() >= 7) {
                SimpleKeyManagerFactory$SimpleKeyManagerFactorySpi.wrapIfNeeded(keyManagerArray);
            }
            this.keyManagers = keyManagerArray;
        }
        return (KeyManager[])keyManagerArray.clone();
    }

    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    private static void wrapIfNeeded(KeyManager[] keyManagerArray) {
        for (int i = 0; i < keyManagerArray.length; ++i) {
            KeyManager keyManager = keyManagerArray[i];
            if (!(keyManager instanceof X509KeyManager) || keyManager instanceof X509ExtendedKeyManager) continue;
            keyManagerArray[i] = new X509KeyManagerWrapper((X509KeyManager)keyManager);
        }
    }
}

