/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.resolver;

import java.util.Arrays;
import java.util.List;
import pro.gravit.repackage.io.netty.resolver.CompositeNameResolver$1;
import pro.gravit.repackage.io.netty.resolver.CompositeNameResolver$2;
import pro.gravit.repackage.io.netty.resolver.NameResolver;
import pro.gravit.repackage.io.netty.resolver.SimpleNameResolver;
import pro.gravit.repackage.io.netty.util.concurrent.EventExecutor;
import pro.gravit.repackage.io.netty.util.concurrent.Promise;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public final class CompositeNameResolver<T>
extends SimpleNameResolver<T> {
    private final NameResolver<T>[] resolvers;

    public CompositeNameResolver(EventExecutor eventExecutor, NameResolver<T> ... nameResolverArray) {
        super(eventExecutor);
        ObjectUtil.checkNotNull(nameResolverArray, "resolvers");
        for (int i = 0; i < nameResolverArray.length; ++i) {
            ObjectUtil.checkNotNull(nameResolverArray[i], "resolvers[" + i + ']');
        }
        if (nameResolverArray.length < 2) {
            throw new IllegalArgumentException("resolvers: " + Arrays.asList(nameResolverArray) + " (expected: at least 2 resolvers)");
        }
        this.resolvers = (NameResolver[])nameResolverArray.clone();
    }

    @Override
    protected void doResolve(String string, Promise<T> promise) {
        this.doResolveRec(string, promise, 0, null);
    }

    private void doResolveRec(String string, Promise<T> promise, int n, Throwable throwable) {
        if (n >= this.resolvers.length) {
            promise.setFailure(throwable);
        } else {
            NameResolver<T> nameResolver = this.resolvers[n];
            nameResolver.resolve(string).addListener(new CompositeNameResolver$1(this, promise, string, n));
        }
    }

    @Override
    protected void doResolveAll(String string, Promise<List<T>> promise) {
        this.doResolveAllRec(string, promise, 0, null);
    }

    private void doResolveAllRec(String string, Promise<List<T>> promise, int n, Throwable throwable) {
        if (n >= this.resolvers.length) {
            promise.setFailure(throwable);
        } else {
            NameResolver<T> nameResolver = this.resolvers[n];
            nameResolver.resolveAll(string).addListener(new CompositeNameResolver$2(this, promise, string, n));
        }
    }

    static /* synthetic */ void access$000(CompositeNameResolver compositeNameResolver, String string, Promise promise, int n, Throwable throwable) {
        compositeNameResolver.doResolveRec(string, promise, n, throwable);
    }

    static /* synthetic */ void access$100(CompositeNameResolver compositeNameResolver, String string, Promise promise, int n, Throwable throwable) {
        compositeNameResolver.doResolveAllRec(string, promise, n, throwable);
    }
}

